package org.lsst.ccs.subsystem.utility.data;

import org.lsst.ccs.subsystem.utility.constants.ConditionState;
import org.lsst.ccs.subsystem.utility.constants.LatchState;
import org.lsst.ccs.subsystem.utility.constants.PLCState;
import org.lsst.ccs.subsystem.utility.constants.SwitchState;
import java.io.Serializable;
import java.util.Arrays;

/**
 *  Contains the state of the protection subsystem
 *
 *  @author Owen Saxton
 */
public class MpmSysState implements Serializable {
    
    public static final String KEY = "MPMState";
    public static final int
        PLC_TRUNK = 0,
        PLC_COLD  = 1,
        PLC_CRYO  = 2,
        NUM_PLCS  = 3;
    public static final int
        SW_BLOCK_UT_POWER   = 0,
        SW_BLOCK_REB_POWER  = 1,
        SW_BLOCK_COOLANT    = 2,
        SW_BLOCK_COLD_REFG  = 3,
        SW_BLOCK_COLD_HEAT  = 4,
        SW_BLOCK_CRYO_REFG  = 5,
        SW_BLOCK_CRYO_HEAT  = 6,
        NUM_SWITCHES        = 7;
    public static final int
        LATCH_UT_TEMP        = 0,
        LATCH_UT_LEAK        = 1,
        LATCH_UT_LEAK_FAULT  = 2,
        LATCH_UT_SMOKE       = 3,
        LATCH_UT_SMOKE_FAULT = 4,
        LATCH_COLD_TEMP_HIGH = 5,
        LATCH_COLD_TEMP_LOW  = 6,
        LATCH_CRYO_TEMP_HIGH = 7,
        LATCH_CRYO_TEMP_LOW  = 8,
        LATCH_CRYO_VACUUM    = 9,
        LATCH_HEX_VACUUM     = 10,
        NUM_LATCHES          = 11;
    public static final int
        COND_UT_POWER  = 0,
        COND_REB_POWER = 1,
        COND_COOLANT   = 2,
        COND_COLD_REFG = 3,
        COND_COLD_HEAT = 4,
        COND_CRYO_REFG = 5,
        COND_CRYO_HEAT = 6,
        NUM_CONDITIONS = 7;

    private int tickMillis;           // Data status update period (ms)
    private final PLCState[] plcState = new PLCState[NUM_PLCS];  // PLC state array
    private final SwitchState[] switchState = new SwitchState[NUM_SWITCHES];  // Switch state array
    private final LatchState[] latchState = new LatchState[NUM_LATCHES];  // Latched PLC conditions array
    private final ConditionState[] conditionState = new ConditionState[NUM_CONDITIONS];  // PLC conditions array

    public MpmSysState() {
        Arrays.fill(plcState, PLCState.ALIVE);
        Arrays.fill(switchState, SwitchState.OFFLINE);
        Arrays.fill(latchState, LatchState.OFFLINE);
        Arrays.fill(conditionState, ConditionState.OFF);
    }

    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public void setPlcState(int plc, PLCState value) {
        plcState[plc] = value;
    }

    public PLCState getPlcState(int plc) {
        return plcState[plc];
    }

    public void setSwitchState(int sw, SwitchState state) {
        switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return switchState[sw];
    }

    public void setLatch(int latch, LatchState state) {
        latchState[latch] = state;
    }

    public LatchState getLatch(int latch) {
        return latchState[latch];
    }

    public void setCondition(int cond, ConditionState state) {
        conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return conditionState[cond];
    }

    private static final long serialVersionUID = -8032854988404965419L;
}
