package org.lsst.ccs.subsystem.utility.constants;

import org.lsst.ccs.bus.data.Alert;

/**
 * Protection Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum MpmAlert {

    /**
     * Vacuum PLC is unresponsive or has error conditions
     */
    PROT_PLC_NOT_ALIVE("ProtPLCNotAlive", "Protection PLC not alive"),
    COLD_TEMP_HIGH("ColdTempHigh", "Cold temperature high"),
    COLD_TEMP_LOW("ColdTempLow", "Cold temperature low"),
    CRYO_TEMP_HIGH("CryoTempHigh", "Cryo temperature high"),
    CRYO_TEMP_LOW("CryoTempLow", "Cryo temperature low"),
    CRYO_VACUUM_BAD("CryoVacuumBad", "Cryo vacuum bad"),
    HEX_VACUUM_BAD("HexVacuumBad", "Hex vacuum bad"),
    UT_TEMP_HIGH("UtTempHigh", "UT temperature high"),
    UT_COOLANT_LEAK("UtCoolantLeak", "UT coolant leak"),
    UT_SMOKE_DETC("UtSmokeDetc", "UT smoke detected");
        
    private final String id, description;
    
    MpmAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert getAlert() {
        return new Alert(id, description);
    }
    
}
