/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ts8;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Data;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.utilities.image.FitsCheckSum;
import org.lsst.ccs.utilities.logging.Logger;

public class FitsUtilities {
    private double STDVBIAS_CUTOFF = 100.0;
    Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.ts8.fitsutilities");

    List<PDValue> readPhotoDiodeFile(File fileName) throws FileNotFoundException, IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(fileName));){
            String line;
            ArrayList<PDValue> result = new ArrayList<PDValue>();
            while ((line = in.readLine()) != null) {
                String[] tokens = line.split(" ");
                double time = Double.parseDouble(tokens[0]);
                double value = Double.parseDouble(tokens[1]);
                result.add(new PDValue(time, value));
            }
            ArrayList<PDValue> arrayList = result;
            return arrayList;
        }
    }

    double analyzePhotoDiodeValues(List<PDValue> pddata) {
        double FRAC_SIG_MIN_LIMIT = 0.05;
        double pdsum = 0.0;
        double pdsum_sig = 0.0;
        double pdsum_base = 0.0;
        double GUARD = 999.0;
        double pdmax = -GUARD;
        double pdmin = GUARD;
        int nelem_sig = 0;
        int nelem_base = 0;
        for (PDValue data : pddata) {
            double pdval = data.getValue();
            pdsum += pdval;
            if (pdval == 0.0) continue;
            if (pdval < pdmin) {
                pdmin = pdval;
            }
            if (!(pdval > pdmax)) continue;
            pdmax = pdval;
        }
        double pdavg_all = pdsum / (double)pddata.size();
        this.log.info((Object)("Average of all PD values is " + pdavg_all));
        double pdcut = (pdmin + pdmax) / 2.0;
        this.log.info((Object)("The cut between the two PD levels is " + pdcut));
        pdsum_sig = 0.0;
        for (PDValue data : pddata) {
            double pdval = data.getValue();
            if (pdval < pdcut) {
                pdsum_sig += pdval;
                ++nelem_sig;
                continue;
            }
            pdsum_base += pdval;
            ++nelem_base;
        }
        double pdavg_sig = pdsum_sig / (double)nelem_sig;
        double pdavg_base = pdsum_base / (double)nelem_base;
        this.log.info((Object)("Number elements in shutter open region = " + nelem_sig));
        double pdval_previous = 0.0;
        double pdtime_previous = 0.0;
        double pdtime_sum = 0.0;
        double frac_sig_previous = 0.0;
        int nint = 0;
        double pdint = 0.0;
        for (PDValue data : pddata) {
            double pdval = data.getValue();
            double pdtime = data.getTime();
            double frac_sig = (pdval - pdavg_base) / (pdavg_sig - pdavg_base);
            if (frac_sig > 0.05 || frac_sig_previous > 0.05) {
                double delta_time = pdtime - pdtime_previous;
                pdint += ((pdval + pdval_previous) / 2.0 - pdavg_base) * delta_time;
                pdtime_sum += delta_time;
                ++nint;
            }
            pdval_previous = pdval;
            pdtime_previous = pdtime;
            frac_sig_previous = frac_sig;
        }
        double pdavg_expo = pdint / pdtime_sum;
        this.log.info((Object)("Sum of PD values in luminous region = " + pdsum));
        this.log.info((Object)("PD average value during exposure = " + pdavg_sig));
        this.log.info((Object)("PD average value baseline = " + pdavg_base));
        this.log.info((Object)("PD average value sig-baseline = " + (pdavg_sig - pdavg_base)));
        this.log.info((Object)("Number elements integrated = " + nint));
        this.log.info((Object)("Integration summed time = " + pdtime_sum));
        this.log.info((Object)("PD average from integration = " + pdavg_expo));
        this.log.info((Object)"NOTE: The MONDIODE value will use EXPTIME.");
        return pdint / 1.0E-9;
    }

    private BinaryTableHDU createPhotoDiodeHDU(List<PDValue> data, String extnam, String c1name, String c2name, double tstart) throws FitsException {
        BinaryTable binTable = new BinaryTable();
        double[] times = new double[data.size()];
        double[] values = new double[data.size()];
        int i = 0;
        for (PDValue datum : data) {
            times[i] = datum.getTime();
            values[i] = datum.getValue();
            ++i;
        }
        binTable.addColumn((Object)times);
        binTable.addColumn((Object)values);
        Header header = new Header((Data)binTable);
        header.addValue("EXTNAME", extnam, "Name of the extension");
        header.addValue("TSTART", tstart, "Time of Start of Readings");
        BinaryTableHDU bhdu = new BinaryTableHDU(header, binTable);
        bhdu.setColumnName(0, c1name, "time");
        bhdu.setColumnName(1, c2name, "values");
        bhdu.info(System.out);
        return bhdu;
    }

    public void showPhotoDiodeAnalysis(File pddatfile) throws IOException, FitsException {
        List<PDValue> data = this.readPhotoDiodeFile(pddatfile);
        double pdint = this.analyzePhotoDiodeValues(data);
    }

    public void updatePhotoDiodeValues(File pddatfile, File fitsfile, String extnam, String c1name, String c2name, double tstart) throws IOException, FitsException {
        List<PDValue> data = this.readPhotoDiodeFile(pddatfile);
        double pdint = this.analyzePhotoDiodeValues(data);
        double pdavg = 0.0;
        BinaryTableHDU bhdu = this.createPhotoDiodeHDU(data, extnam, c1name, c2name, tstart);
        File tmpName = File.createTempFile("tmp", "fits", fitsfile.getParentFile());
        try (Fits in = new Fits(fitsfile);
             BufferedFile out = new BufferedFile(tmpName, "rw");){
            in.read();
            BasicHDU primary = in.getHDU(0);
            double exptime = primary.getHeader().getDoubleValue("EXPTIME", 1.0);
            if (primary.getHeader().containsKey("MONDIODE")) {
                primary.getHeader().deleteKey("MONDIODE");
            }
            pdavg = 0.0;
            if (exptime > 0.0) {
                pdavg = pdint / exptime;
            }
            primary.getHeader().addValue("MONDIODE", pdavg, "avg PD value (nA) during expo");
            FitsCheckSum.setChecksum((BasicHDU)primary);
            primary.write((ArrayDataOutput)out);
            for (int ihdu = 1; ihdu < in.getNumberOfHDUs(); ++ihdu) {
                BasicHDU hdu = in.getHDU(ihdu);
                String extn = hdu.getHeader().getStringValue("EXTNAME");
                if (extn.equals(extnam)) continue;
                hdu.write((ArrayDataOutput)out);
            }
            FitsCheckSum.setChecksum((BasicHDU)bhdu);
            bhdu.write((ArrayDataOutput)out);
        }
        Files.move(tmpName.toPath(), fitsfile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public double getFluxStats(File fitsfile) throws FitsException, IOException {
        try (Fits fits = new Fits(fitsfile);){
            double minflux = Double.MAX_VALUE;
            double fluxsum = 0.0;
            double fluxsumQA = 0.0;
            double[] fluxvals = new double[16];
            int fluxentries = 0;
            int fluxentriesQA = 0;
            fits.read();
            Header primary = fits.getHDU(0).getHeader();
            double gain = primary.getDoubleValue("CCDGAIN");
            double exptime = fits.getHDU(0).getHeader().getDoubleValue("EXPTIME");
            for (int ihdu = 1; ihdu < fits.getNumberOfHDUs(); ++ihdu) {
                Header extension = fits.getHDU(ihdu).getHeader();
                String extn = extension.getStringValue("EXTNAME");
                if (!extn.contains("Segment")) continue;
                double avg = fits.getHDU(ihdu).getHeader().getDoubleValue("AVERAGE");
                double bias = fits.getHDU(ihdu).getHeader().getDoubleValue("AVGBIAS");
                double signal = (avg - bias) * gain;
                double flux = Math.max(signal / exptime, 1.0);
                minflux = Math.min(minflux, flux);
                fluxsum += flux;
                double stdvbias = fits.getHDU(ihdu).getHeader().getDoubleValue("STDVBIAS");
                if (stdvbias < this.STDVBIAS_CUTOFF) {
                    fluxsumQA += flux;
                    ++fluxentriesQA;
                }
                fluxvals[fluxentries] = flux;
                ++fluxentries;
                this.log.info((Object)(extn + " signal = " + signal + " exptime = " + exptime + " flux = " + flux + " minflux for CCD = " + minflux));
            }
            double flux_cutoff = fluxsumQA / (3.0 * (double)fluxentriesQA);
            int num_used = 0;
            double flux_resum = 0.0;
            for (int idx = 0; idx < 16; ++idx) {
                int ihdu = idx + 1;
                double stdvbias = fits.getHDU(ihdu).getHeader().getDoubleValue("STDVBIAS");
                if (fluxvals[idx] > flux_cutoff && stdvbias < this.STDVBIAS_CUTOFF) {
                    flux_resum += fluxvals[idx];
                    ++num_used;
                    continue;
                }
                this.log.info((Object)("Rejected segement " + ihdu + " - flux = " + fluxvals[idx] + " stdvbias = " + stdvbias));
            }
            this.log.info((Object)("flux_cutoff = " + flux_cutoff + " , number flux values used = " + num_used));
            double sensor_flux = num_used > 0 ? flux_resum / (double)num_used : 0.0;
            this.log.info((Object)("flux with all segments = " + fluxsum / (double)fluxentries));
            this.log.info((Object)("flux with bad segments removed = " + sensor_flux));
            double d = sensor_flux;
            return d;
        }
    }

    static class PDValue {
        private double time;
        private double value;

        private PDValue(double time, double value) {
            this.time = time;
            this.value = value;
        }

        public double getTime() {
            return this.time;
        }

        public double getValue() {
            return this.value;
        }
    }
}

