/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ts8;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.subsystem.ts8.TS8Subsystem;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.HeaderSpecification;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.image.ReadOutParameters;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class TS8SimpleTest
extends CcsTestCaseTemplate {
    private static Subsystem testSubsystem = null;
    private static TS8Subsystem ts8Main = null;
    private static Subsystem teststandSubsystem = null;
    private static PeriodicTask tsstatePublisher;
    private static ConcurrentMessagingUtils cmu;
    private static Agent listener;
    private final Object tsstatePublicationLock = new Object();

    @BeforeClass
    public static void createSubsystem() throws Exception {
        System.setProperty("org.lsst.ccs.run.mode", "simulation");
        testSubsystem = BootUtils.getSubsystemFromFile((String)"ts8_fits_files_writing", (String)"");
        testSubsystem.startAgent();
        ts8Main = (TS8Subsystem)testSubsystem.getComponentLookup().getComponentByPath("main");
        teststandSubsystem = new Subsystem("ts", AgentInfo.AgentType.WORKER);
        teststandSubsystem.startAgent();
        Scheduler scheduler = new Scheduler("Scheduler for " + teststandSubsystem.getName(), 3);
        scheduler.setLogger(teststandSubsystem.getLogger());
        tsstatePublisher = new PeriodicTask(scheduler, () -> {
            TSConfig teststandc = new TSConfig();
            TSState teststandState = new TSState(0, teststandc.getCfgstate(), 1000);
            teststandState.setVolts(4.5);
            teststandState.setBIAS_curr(3.3);
            teststandState.setBIASon(0);
            teststandState.setCurr(1.1);
            teststandState.setTemp(34.3);
            teststandState.setVac(22.2);
            teststandState.setLmpPwr(75.23);
            teststandState.setWl(21.0);
            teststandState.setSw1(2.1);
            teststandState.setSw2(0.3);
            teststandState.setXedpos(7);
            teststandState.setShutpos(12);
            teststandState.setSrctype("str");
            teststandState.setMonotype("abc");
            teststandState.setPDcnt(4);
            teststandState.setPDnplc(45.111);
            teststandState.setPDtype("efg");
            teststandState.setBIAStype("zzz");
            teststandState.setFilter("i");
            teststandState.setWarning("warn");
            KeyValueData kd = new KeyValueData("TSState", (Serializable)teststandState);
            teststandSubsystem.publishSubsystemDataOnStatusBus(kd);
        }, true, "heartbeat", Level.SEVERE, 1L, TimeUnit.SECONDS);
        tsstatePublisher.start();
        listener = new Agent("agent_listner", AgentInfo.AgentType.CONSOLE);
        listener.startAgent();
        cmu = new ConcurrentMessagingUtils(listener.getMessagingAccess());
    }

    @AfterClass
    public static void shutdownSubsystem() throws Exception {
        tsstatePublisher.stop();
        testSubsystem.shutdownAgent();
        teststandSubsystem.shutdownAgent();
        listener.shutdownAgent();
        System.setProperty("org.lsst.ccs.run.mode", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeaderKeywordSetting() throws Exception {
        TSStateListener tsStateListener = new TSStateListener();
        Object object = this.tsstatePublicationLock;
        synchronized (object) {
            listener.getMessagingAccess().addStatusMessageListener((StatusMessageListener)tsStateListener);
            this.tsstatePublicationLock.wait();
        }
        ts8Main.setHeader("StickyAddedPrimaryHeader", (Object)"value", true);
        ts8Main.setHeader("NonStickyAddedPrimaryHeader", (Object)"value", false);
        String sensorId = "R00.Reb0.S01";
        ts8Main.setCCDHeader(sensorId, "StickyCCDHeader", (Object)"value", true);
        ts8Main.setCCDHeader(sensorId, "NonStickyCCDHeader", (Object)"value", false);
        ts8Main.setMeasuredCCDTemperature(sensorId, 32.3);
        FitsService metadataProvider = ((REBDevice)ts8Main.getRebDevices().get(0)).getImageProc().getFitsService();
        Thread.sleep(1000L);
        Raft g = (Raft)ts8Main.getGeometry();
        for (Reb reb : g.getChildrenList()) {
            for (CCD ccd : reb.getChildrenList()) {
                ReadOutParameters readOutParameters = new ReadOutParameters(ccd.getType());
                DefaultImageSet imageSet = new DefaultImageSet(ccd, readOutParameters);
                System.out.println("Processing sensor " + imageSet.getCCD().getUniqueId());
                MetaDataSet primaryMetadata = metadataProvider.getPrimaryHeaderMetadata((ImageSet)imageSet);
                MetaDataSet ccdMetadata = metadataProvider.getAdditionalExtendedHeaderMetadata((ImageSet)imageSet, imageSet.getCCD().getUniqueId());
                Assert.assertEquals((Object)"value", (Object)primaryMetadata.getValue("StickyAddedPrimaryHeader"));
                Assert.assertEquals((Object)"value", (Object)primaryMetadata.getValue("NonStickyAddedPrimaryHeader"));
                if (imageSet.getCCD().getUniqueId().equals(sensorId)) {
                    Assert.assertEquals((Object)"value", (Object)ccdMetadata.getValue("StickyCCDHeader"));
                    Assert.assertEquals((Object)"value", (Object)ccdMetadata.getValue("NonStickyCCDHeader"));
                }
                Map headers = FitsHeadersSpecifications.getHeaderSpecifications();
                for (String headerName : headers.keySet()) {
                    HeaderSpecification specs = (HeaderSpecification)headers.get(headerName);
                    for (HeaderSpecification.HeaderLine line : specs.getHeaders()) {
                        String metaName = line.getMetaName();
                        if (metaName == null || !metaName.contains("TSState")) continue;
                        Assert.assertTrue((primaryMetadata.getValue("StatusAggregator", metaName) != null ? 1 : 0) != 0);
                    }
                }
            }
        }
        metadataProvider.clearNonStickyHeaderKeywordValues();
        ts8Main.setHeader("StickyAddedPrimaryHeader", (Object)"value2", true);
        ts8Main.setCCDHeader(sensorId, "StickyCCDHeader", (Object)"value2", true);
        CCD ccd = (CCD)g.findGeometry(sensorId);
        metadataProvider = ((REBDevice)ts8Main.getRebDevices().get(0)).getImageProc().getFitsService();
        Thread.sleep(1000L);
        DefaultImageSet imageSet = new DefaultImageSet(ccd, new ReadOutParameters(ccd.getType()));
        MetaDataSet primaryMetadata = metadataProvider.getPrimaryHeaderMetadata((ImageSet)imageSet);
        MetaDataSet ccdMetadata = metadataProvider.getAdditionalExtendedHeaderMetadata((ImageSet)imageSet, imageSet.getCCD().getUniqueId());
        Assert.assertEquals((Object)"value2", (Object)primaryMetadata.getValue("StickyAddedPrimaryHeader"));
        Assert.assertEquals((Object)"value2", (Object)ccdMetadata.getValue("StickyCCDHeader"));
        Assert.assertEquals((Object)false, (Object)(primaryMetadata.getValue("NonStickyCCDHeader") != null ? 1 : 0));
        Assert.assertEquals((Object)false, (Object)(primaryMetadata.getValue("NonStickyAddedPrimaryHeader") != null ? 1 : 0));
        Assert.assertEquals((Object)32.3, (Object)ccdMetadata.getValue("MeasuredTemperature"));
    }

    private class TSStateListener
    implements StatusMessageListener {
        private int msgCount = 0;

        private TSStateListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStatusMessage(StatusMessage msg) {
            StatusSubsystemData ssdata;
            if (msg.getOriginAgentInfo().getName().equals("ts") && msg instanceof StatusSubsystemData && (ssdata = (StatusSubsystemData)msg).getDataKey().equals("TSState")) {
                Object object = TS8SimpleTest.this.tsstatePublicationLock;
                synchronized (object) {
                    TS8SimpleTest.this.tsstatePublicationLock.notifyAll();
                }
            }
        }
    }
}

