/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.EncryptBase;
import org.jgroups.protocols.EncryptHeader;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.util.AsciiString;
import org.jgroups.util.Digest;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.ResponseCollectorTask;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@MBean(description="Asymmetric encryption protocol. The secret key for encryption and decryption of messages is fetched from a key server (the coordinator) via asymmetric encryption")
public class ASYM_ENCRYPT
extends EncryptBase {
    protected static final short GMS_ID = ClassConfigurator.getProtocolId(GMS.class);
    @Property(description="When a member leaves, change the secret key, preventing old members from eavesdropping")
    protected boolean change_key_on_leave = true;
    @Property(description="If true, a separate KeyExchange protocol (somewhere below in ths stack) is used to fetch the shared secret key. If false, the default (built-in) key exchange protocol will be used.")
    protected boolean use_external_key_exchange;
    @Property(description="Interval (in ms) to send out announcements when the key server changed. Members will then start the key exchange protocol. When all members have acked, the task is cancelled.")
    protected long key_server_interval = 1000L;
    protected volatile Address key_server_addr;
    protected KeyPair key_pair;
    protected Cipher asym_cipher;
    protected final Lock queue_lock = new ReentrantLock();
    @ManagedAttribute(description="whether or not to queue received messages (until the secret key was received)")
    protected boolean queue_up_msgs = true;
    protected final BlockingQueue<Message> up_queue = new ArrayBlockingQueue<Message>(100);
    @Property(description="Min time (in millis) between key requests")
    protected long min_time_between_key_requests = 2000L;
    protected volatile long last_key_request;
    protected ResponseCollectorTask<Boolean> key_requesters;

    public KeyPair keyPair() {
        return this.key_pair;
    }

    public Cipher asymCipher() {
        return this.asym_cipher;
    }

    public Address keyServerAddr() {
        return this.key_server_addr;
    }

    public ASYM_ENCRYPT keyServerAddr(Address key_srv) {
        this.key_server_addr = key_srv;
        return this;
    }

    public long minTimeBetweenKeyRequests() {
        return this.min_time_between_key_requests;
    }

    public ASYM_ENCRYPT minTimeBetweenKeyRequests(long t) {
        this.min_time_between_key_requests = t;
        return this;
    }

    @Override
    public List<Integer> providedDownServices() {
        return Arrays.asList(111, 112);
    }

    @ManagedAttribute(description="Number of received messages currently queued")
    public int queueSize() {
        return this.up_queue.size();
    }

    @ManagedAttribute(description="The current key server")
    public String getKeyServerAddress() {
        return this.key_server_addr != null ? this.key_server_addr.toString() : "null";
    }

    @ManagedOperation(description="Triggers a request for the secret key to the current keyserver")
    public void sendKeyRequest() {
        if (this.key_server_addr == null) {
            this.log.debug("%s: sending secret key request failed as the key server is currently not set", this.local_addr);
            return;
        }
        this.sendKeyRequest(this.key_server_addr);
    }

    @ManagedAttribute(description="True if this member is the current key server, false otherwise")
    public boolean isKeyServer() {
        return Objects.equals(this.key_server_addr, this.local_addr);
    }

    @Override
    public void init() throws Exception {
        List<Integer> provided_up_services;
        this.initKeyPair();
        super.init();
        if (this.use_external_key_exchange && ((provided_up_services = this.getDownServices()) == null || !provided_up_services.contains(110))) {
            throw new IllegalStateException("found no key exchange protocol below servicing event FETCH_SECRET_KEY");
        }
    }

    @Override
    public void stop() {
        if (this.key_requesters != null) {
            this.key_requesters.stop();
        }
        this.stopQueueing();
        super.stop();
    }

    @Override
    public Object down(Event evt) {
        Message msg;
        if (evt.type() == 1 && ASYM_ENCRYPT.skip(msg = (Message)evt.arg())) {
            return this.down_prot.down(evt);
        }
        return super.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.type()) {
            case 1: {
                Message msg = (Message)evt.arg();
                if (!ASYM_ENCRYPT.skip(msg)) break;
                GMS.GmsHeader hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID);
                Address key_server = this.getCoordinator(msg, hdr);
                if (key_server != null) {
                    if (this.key_server_addr == null) {
                        this.key_server_addr = key_server;
                    }
                    this.sendKeyRequest(key_server);
                }
                return this.up_prot.up(evt);
            }
            case 111: {
                return new Tuple<Key, byte[]>(this.secret_key, this.sym_version);
            }
            case 112: {
                Tuple tuple = (Tuple)evt.arg();
                try {
                    this.setKeys((SecretKey)tuple.getVal1(), (byte[])tuple.getVal2());
                }
                catch (Exception ex) {
                    this.log.error("failed setting secret key", ex);
                }
                return null;
            }
        }
        return super.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        for (Message msg : batch) {
            Header hdr;
            if (ASYM_ENCRYPT.skip(msg)) {
                try {
                    this.up_prot.up(new Event(1, msg));
                    batch.remove(msg);
                    hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID);
                    Address key_server = this.getCoordinator(msg, (GMS.GmsHeader)hdr);
                    if (key_server != null) {
                        this.sendKeyRequest(key_server);
                    }
                }
                catch (Throwable t) {
                    this.log.error("failed passing up message from %s: %s, ex=%s", msg.src(), msg.printHeaders(), t);
                }
            }
            if ((hdr = (EncryptHeader)msg.getHeader(this.id)) == null || hdr.type == 1) continue;
            this.handleUpEvent(msg, (EncryptHeader)hdr);
            batch.remove(msg);
        }
        if (!batch.isEmpty()) {
            super.up(batch);
        }
    }

    protected Address getCoordinator(Message msg, GMS.GmsHeader hdr) {
        switch (hdr.getType()) {
            case 2: {
                try {
                    JoinRsp join_rsp = Util.streamableFromBuffer(JoinRsp.class, msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                    View new_view = join_rsp != null ? join_rsp.getView() : null;
                    return new_view != null ? new_view.getCoord() : null;
                }
                catch (Throwable t) {
                    this.log.error("%s: failed getting coordinator (keyserver) from JoinRsp: %s", this.local_addr, t);
                    break;
                }
            }
            case 8: {
                try {
                    Tuple<View, Digest> tuple = GMS._readViewAndDigest(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                    View new_view = tuple != null ? tuple.getVal1() : null;
                    return new_view != null ? new_view.getCoord() : null;
                }
                catch (Throwable t) {
                    this.log.error("%s: failed getting coordinator (keyserver) from INSTALL_MERGE_VIEW: %s", this.local_addr, t);
                }
            }
        }
        return null;
    }

    protected static boolean skip(Message msg) {
        GMS.GmsHeader hdr = (GMS.GmsHeader)msg.getHeader(GMS_ID);
        if (hdr == null) {
            return false;
        }
        switch (hdr.getType()) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Object handleUpEvent(Message msg, EncryptHeader hdr) {
        switch (hdr.type()) {
            case 2: {
                this.handleSecretKeyRequest(msg);
                break;
            }
            case 4: {
                this.handleSecretKeyResponse(msg, hdr.version());
                this.sendNewKeyserverAck(msg.src());
                break;
            }
            case 8: {
                Address sender = msg.src();
                if (!Objects.equals(this.key_server_addr, sender)) {
                    this.key_server_addr = sender;
                }
                if (!Arrays.equals(this.sym_version, hdr.version)) {
                    this.sendKeyRequest(sender);
                    break;
                }
                this.sendNewKeyserverAck(sender);
                break;
            }
            case 16: {
                if (this.key_requesters == null) break;
                this.key_requesters.add(msg.src(), true);
            }
        }
        return null;
    }

    @Override
    protected boolean process(Message msg) {
        if (this.enqueue(msg)) {
            this.log.trace("%s: queuing %s message from %s as secret key hasn't been retrieved from keyserver %s yet, hdrs: %s", this.local_addr, msg.dest() == null ? "mcast" : "unicast", msg.src(), this.key_server_addr, msg.printHeaders());
            this.sendKeyRequest(this.key_server_addr);
            return false;
        }
        return true;
    }

    protected void handleSecretKeyRequest(Message msg) {
        if (!this.inView(msg.src(), "key requester %s is not in current view %s; ignoring key request")) {
            return;
        }
        this.log.debug("%s: received secret key request from %s", this.local_addr, msg.getSrc());
        try {
            PublicKey tmpKey = this.generatePubKey(msg.getBuffer());
            this.sendSecretKey(this.secret_key, tmpKey, msg.getSrc());
        }
        catch (Exception e) {
            this.log.warn("%s: unable to reconstitute peer's public key", this.local_addr);
        }
    }

    protected void handleSecretKeyResponse(Message msg, byte[] key_version) {
        if (!this.inView(msg.src(), "ignoring secret key sent by %s which is not in current view %s")) {
            return;
        }
        if (Arrays.equals(this.sym_version, key_version)) {
            this.log.debug("%s: secret key (version %s) already installed, ignoring key response", this.local_addr, Util.byteArrayToHexString(key_version));
            this.stopQueueing();
            return;
        }
        try {
            SecretKeySpec tmp = this.decodeKey(msg.getBuffer());
            if (tmp == null) {
                this.sendKeyRequest(this.key_server_addr);
            } else {
                this.log.debug("%s: installing secret key received from %s (version: %s)", this.local_addr, msg.getSrc(), Util.byteArrayToHexString(key_version));
                this.setKeys(tmp, key_version);
            }
        }
        catch (Exception e) {
            this.log.warn("%s: unable to process received public key", this.local_addr, e);
        }
    }

    protected SecretKey createSecretKey() throws Exception {
        KeyGenerator keyGen = null;
        keyGen = this.provider != null && !this.provider.trim().isEmpty() ? KeyGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.sym_algorithm), this.provider) : KeyGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.sym_algorithm));
        keyGen.init(this.sym_keylength);
        return keyGen.generateKey();
    }

    protected void initKeyPair() throws Exception {
        KeyPairGenerator KpairGen = null;
        KpairGen = this.provider != null && !this.provider.trim().isEmpty() ? KeyPairGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.asym_algorithm), this.provider) : KeyPairGenerator.getInstance(ASYM_ENCRYPT.getAlgorithm(this.asym_algorithm));
        KpairGen.initialize(this.asym_keylength, new SecureRandom());
        this.key_pair = KpairGen.generateKeyPair();
        this.asym_cipher = this.provider != null && !this.provider.trim().isEmpty() ? Cipher.getInstance(this.asym_algorithm, this.provider) : Cipher.getInstance(this.asym_algorithm);
        this.asym_cipher.init(2, this.key_pair.getPrivate());
    }

    @Override
    protected synchronized void handleView(View v) {
        boolean left_mbrs = this.change_key_on_leave && this.view != null && !v.containsMembers(this.view.getMembersRaw());
        boolean create_new_key = this.secret_key == null || left_mbrs;
        super.handleView(v);
        if (this.key_requesters != null) {
            this.key_requesters.retainAll(v.getMembers());
        }
        Address old_key_server = this.key_server_addr;
        this.key_server_addr = v.getCoord();
        if (Objects.equals(this.key_server_addr, this.local_addr)) {
            if (!Objects.equals(this.key_server_addr, old_key_server)) {
                this.log.debug("%s: I'm the new key server", this.local_addr);
            }
            if (create_new_key) {
                this.createNewKey();
                if (this.key_requesters != null) {
                    this.key_requesters.stop();
                }
                ArrayList<Address> targets = new ArrayList<Address>(v.getMembers());
                targets.remove(this.local_addr);
                if (!targets.isEmpty()) {
                    this.key_requesters = new ResponseCollectorTask<Boolean>(targets).setPeriodicTask(new ResponseCollectorTask.Consumer<ResponseCollectorTask<Boolean>>(){

                        @Override
                        public void accept(ResponseCollectorTask<Boolean> t) {
                            Message msg = new Message(null).setTransientFlag(Message.TransientFlag.DONT_LOOPBACK).putHeader(ASYM_ENCRYPT.this.id, new EncryptHeader(8, ASYM_ENCRYPT.this.sym_version));
                            ASYM_ENCRYPT.this.down_prot.down(new Event(1, msg));
                        }
                    }).start(this.getTransport().getTimer(), 0L, this.key_server_interval);
                }
            }
        } else {
            this.handleNewKeyServer(old_key_server, v instanceof MergeView, left_mbrs);
        }
    }

    protected void createNewKey() {
        try {
            this.secret_key = this.createSecretKey();
            this.initSymCiphers(this.sym_algorithm, this.secret_key);
            this.log.debug("%s: created new secret key (version: %s)", this.local_addr, Util.byteArrayToHexString(this.sym_version));
            this.stopQueueing();
        }
        catch (Exception ex) {
            this.log.error("%s: failed creating secret key and initializing ciphers", this.local_addr, ex);
        }
    }

    protected void handleNewKeyServer(Address old_key_server, boolean merge_view, boolean left_mbrs) {
        if (this.change_key_on_leave && (this.keyServerChanged(old_key_server) || merge_view || left_mbrs)) {
            this.startQueueing();
            this.log.debug("%s: sending request for secret key to the new keyserver %s", this.local_addr, this.key_server_addr);
            this.sendKeyRequest(this.key_server_addr);
        }
    }

    protected boolean keyServerChanged(Address old_keyserver) {
        return !Objects.equals(this.key_server_addr, old_keyserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setKeys(SecretKey key, byte[] version) throws Exception {
        ASYM_ENCRYPT aSYM_ENCRYPT = this;
        synchronized (aSYM_ENCRYPT) {
            Cipher decoding_cipher;
            if (Arrays.equals(this.sym_version, version)) {
                this.stopQueueing();
                return;
            }
            Cipher cipher = decoding_cipher = this.secret_key != null ? (Cipher)this.decoding_ciphers.take() : null;
            if (decoding_cipher != null) {
                this.key_map.put(new AsciiString(version), decoding_cipher);
            }
            this.secret_key = key;
            this.initSymCiphers(key.getAlgorithm(), key);
            this.sym_version = version;
        }
        this.stopQueueing();
    }

    protected void sendSecretKey(Key secret_key, PublicKey public_key, Address source) throws Exception {
        byte[] encryptedKey = this.encryptSecretKey(secret_key, public_key);
        Message newMsg = new Message(source, encryptedKey).src(this.local_addr).putHeader(this.id, new EncryptHeader(4, this.symVersion()));
        this.log.debug("%s: sending secret key response to %s (version: %s)", this.local_addr, source, Util.byteArrayToHexString(this.sym_version));
        this.down_prot.down(new Event(1, newMsg));
    }

    protected byte[] encryptSecretKey(Key secret_key, PublicKey public_key) throws Exception {
        Cipher tmp = this.provider != null && !this.provider.trim().isEmpty() ? Cipher.getInstance(this.asym_algorithm, this.provider) : Cipher.getInstance(this.asym_algorithm);
        tmp.init(1, public_key);
        return tmp.doFinal(secret_key.getEncoded());
    }

    protected void sendKeyRequest(Address key_server) {
        if (key_server == null) {
            return;
        }
        if (this.last_key_request != 0L && System.currentTimeMillis() - this.last_key_request <= this.min_time_between_key_requests) {
            return;
        }
        this.last_key_request = System.currentTimeMillis();
        if (this.use_external_key_exchange) {
            this.log.debug("%s: asking key exchange protocol to get secret key", this.local_addr);
            this.down_prot.down(new Event(110, key_server));
            return;
        }
        this.log.debug("%s: asking %s for the secret key (my version: %s)", this.local_addr, key_server, Util.byteArrayToHexString(this.sym_version));
        Message newMsg = new Message(key_server, this.key_pair.getPublic().getEncoded()).src(this.local_addr).putHeader(this.id, new EncryptHeader(2, null));
        this.down_prot.down(new Event(1, newMsg));
    }

    protected void sendNewKeyserverAck(Address dest) {
        Message msg = new Message(dest).putHeader(this.id, new EncryptHeader(16, null));
        this.down_prot.down(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecretKeySpec decodeKey(byte[] encodedKey) throws Exception {
        byte[] keyBytes;
        ASYM_ENCRYPT aSYM_ENCRYPT = this;
        synchronized (aSYM_ENCRYPT) {
            keyBytes = this.asym_cipher.doFinal(encodedKey);
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, ASYM_ENCRYPT.getAlgorithm(this.sym_algorithm));
            Cipher temp = this.provider != null && !this.provider.trim().isEmpty() ? Cipher.getInstance(this.sym_algorithm, this.provider) : Cipher.getInstance(this.sym_algorithm);
            temp.init(3, keySpec);
            return keySpec;
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailedDecodingKey"), e);
            return null;
        }
    }

    protected void startQueueing() {
        this.queue_lock.lock();
        try {
            this.queue_up_msgs = true;
        }
        finally {
            this.queue_lock.unlock();
        }
    }

    protected boolean enqueue(Message msg) {
        this.queue_lock.lock();
        try {
            boolean bl = this.queue_up_msgs && this.up_queue.offer(msg);
            return bl;
        }
        finally {
            this.queue_lock.unlock();
        }
    }

    protected void stopQueueing() {
        ArrayList sink = new ArrayList(this.up_queue.size());
        this.queue_lock.lock();
        try {
            this.queue_up_msgs = false;
            this.up_queue.drainTo(sink);
        }
        finally {
            this.queue_lock.unlock();
        }
        for (Message queued_msg : sink) {
            try {
                Message decrypted_msg = this.decryptMessage(null, queued_msg.copy());
                if (decrypted_msg == null) continue;
                this.up_prot.up(new Event(1, decrypted_msg));
            }
            catch (Exception ex) {
                this.log.error("failed decrypting message from %s: %s", queued_msg.src(), ex);
            }
        }
    }

    @Override
    protected void handleUnknownVersion(byte[] version) {
        if (!this.isKeyServer()) {
            this.log.debug("%s: received msg encrypted with version %s (my version: %s), getting new secret key from %s", this.local_addr, Util.byteArrayToHexString(version), Util.byteArrayToHexString(this.sym_version), this.key_server_addr);
            this.sendKeyRequest(this.key_server_addr);
        }
    }

    protected PublicKey generatePubKey(byte[] encodedKey) {
        PublicKey pubKey = null;
        try {
            KeyFactory KeyFac = KeyFactory.getInstance(ASYM_ENCRYPT.getAlgorithm(this.asym_algorithm));
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encodedKey);
            pubKey = KeyFac.generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pubKey;
    }
}

