/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.awt.Point;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.drivers.reb.ImageMetadata;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.image.ReadOutParameters;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.visualization.client.DataMessage;
import org.lsst.ccs.visualization.client.EndMessage;
import org.lsst.ccs.visualization.client.IngestClient;
import org.lsst.ccs.visualization.client.Message;
import org.lsst.ccs.visualization.client.StartMessage;

public class GlobalVisualizationClient
implements HasLifecycle {
    private int clientPort;
    private String clientHost;
    private IngestClient ingestClient;
    private final ReentrantLock sendDataLock = new ReentrantLock();
    private Map<String, Integer> startedImages = new ConcurrentHashMap<String, Integer>();
    private String currentImageName;
    private static final Logger LOG = Logger.getLogger((String)GlobalVisualizationClient.class.getName());
    private boolean isConnected = false;

    public void postInit() {
        try {
            this.ingestClient = new IngestClient(this.clientHost, this.clientPort);
            this.isConnected = true;
        }
        catch (IOException ioe) {
            LOG.severe((Object)("Failed to initialize the Visualization client " + this.clientHost + ":" + this.clientPort), (Throwable)ioe);
        }
    }

    public void shutdown() {
        try {
            if (this.ingestClient != null) {
                this.ingestClient.close();
            }
            this.isConnected = false;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to close the Visualization client " + this.clientHost + ":" + this.clientPort, ioe);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendImageData(ImageMetadata imageMetadata, ByteBuffer data, CCD ccd, ReadOutParameters readOutParameters) {
        LOG.debug((Object)("Sending image data for " + ccd.getUniqueId() + " " + imageMetadata.getName()));
        this.sendDataLock.lock();
        try {
            String imageName = ccd.getUniqueId();
            int height = readOutParameters.getSerialReadPixels() * 3;
            int width = readOutParameters.getParallelReadPixels() * 3;
            if (this.startedImages.isEmpty()) {
                Geometry reb = ccd.getParent();
                Raft raft = null;
                if (reb != null) {
                    raft = (Raft)reb.getParent();
                }
                if (raft != null) {
                    height = raft.getHeight();
                    width = raft.getWidth();
                }
                LOG.debug((Object)("Sending start message " + width + "x" + height));
                this.currentImageName = imageName;
                this.ingestClient.send((Message)new StartMessage(this.currentImageName, width, height, 0, 9));
                this.startedImages.put(imageName, 0);
            }
            Point absoluteOrigin = ccd.getGeometryAbsolutePosition();
            int offset = absoluteOrigin.getLocation().y * width + absoluteOrigin.getLocation().x;
            int stepLength = readOutParameters.getTotalParallelSize();
            int stepOffset = width - stepLength;
            this.ingestClient.send((Message)new DataMessage(this.currentImageName, offset, stepLength, stepOffset, data));
            this.ingestClient.send((Message)new EndMessage(this.currentImageName));
            this.startedImages.put(imageName, 1);
            if (this.startedImages.size() == 9) {
                LOG.debug((Object)("**** Done with image " + this.currentImageName));
                this.startedImages.clear();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            this.sendDataLock.unlock();
        }
    }
}

