/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image.patterns;

import java.util.Map;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;
import org.lsst.ccs.utilities.image.patterns.PatternGenerator;

public class RipplesPatternGenerator
extends PatternGenerator {
    RipplesPatternGenerator() {
        super("ripples");
    }

    @Override
    public GeneratedImage generateImage(int width, int height, Map<String, String> parameters) {
        double xCenter = this.getDoubleParameter("ripples_xCenter", parameters, (double)width / 3.0);
        double yCenter = this.getDoubleParameter("ripples_yCenter", parameters, (double)height / 7.0);
        double amplitude = this.getDoubleParameter("ripples_amplitude", parameters, 200.0);
        double mean = this.getDoubleParameter("ripples_mean", parameters, 1000.0);
        double frequency = this.getDoubleParameter("ripples_frequency", parameters, 30.0);
        int[][] data = new int[width][height];
        for (int i = 0; i < width; ++i) {
            double dx = (double)i - xCenter;
            for (int j = 0; j < height; ++j) {
                double dy = (double)j - yCenter;
                double r = Math.sqrt(Math.pow(dy, 2.0) + Math.pow(dx, 2.0));
                data[i][j] = (int)(mean + amplitude * Math.sin(r / frequency));
            }
        }
        return new GeneratedImage(data, mean + amplitude);
    }
}

