/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.limits;

import java.util.List;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.LimitsInterface;

class DeltaLimitAlgorithm
extends LimitAlgorithm {
    private double initialDeltaAlarmLow;
    private double initialDeltaWarnLow;
    private double initialDeltaAlarmHigh;
    private double initialDeltaWarnHigh;
    private double targetDeltaAlarmLow;
    private double targetDeltaWarnLow;
    private double targetDeltaAlarmHigh;
    private double targetDeltaWarnHigh;

    DeltaLimitAlgorithm() {
    }

    @Override
    public void init(List<Double> parameters, double initialValue, LimitsInterface limits, double targetValue, LimitsInterface targetLimits) {
        super.init(parameters, initialValue, limits, targetValue, targetLimits);
        this.targetDeltaAlarmLow = -Math.abs(targetValue - targetLimits.getAlarmLow());
        this.targetDeltaWarnLow = -Math.abs(targetValue - targetLimits.getWarnLow());
        this.targetDeltaWarnHigh = Math.abs(targetLimits.getWarnHigh() - targetValue);
        this.targetDeltaAlarmHigh = Math.abs(targetLimits.getAlarmHigh() - targetValue);
        this.initialDeltaAlarmLow = -Math.abs(this.getInitialValue() - limits.getAlarmLow());
        this.initialDeltaWarnLow = -Math.abs(this.getInitialValue() - limits.getWarnLow());
        this.initialDeltaWarnHigh = Math.abs(limits.getWarnHigh() - this.getInitialValue());
        this.initialDeltaAlarmHigh = Math.abs(limits.getAlarmHigh() - this.getInitialValue());
        if (this.initialDeltaAlarmLow > this.initialDeltaWarnLow || this.initialDeltaWarnLow >= 0.0 || this.initialDeltaWarnHigh <= 0.0 || this.initialDeltaAlarmHigh < this.initialDeltaWarnHigh) {
            throw new IllegalArgumentException("Delta limit algorith parameters are invalid");
        }
    }

    @Override
    public void adjust(double currentValue, LimitsInterface limits) {
        double alpha = Math.abs((currentValue - this.getTargetValue()) / (this.getInitialValue() - this.getTargetValue()));
        double deltaAlarmLow = alpha * this.initialDeltaAlarmLow + (1.0 - alpha) * this.targetDeltaAlarmLow;
        double deltaWarnLow = alpha * this.initialDeltaWarnLow + (1.0 - alpha) * this.targetDeltaWarnLow;
        double deltaWarnHigh = alpha * this.initialDeltaWarnHigh + (1.0 - alpha) * this.targetDeltaWarnHigh;
        double deltaAlarmHigh = alpha * this.initialDeltaAlarmHigh + (1.0 - alpha) * this.targetDeltaAlarmHigh;
        limits.setLimits(currentValue + deltaAlarmLow, currentValue + deltaWarnLow, currentValue + deltaWarnHigh, currentValue + deltaAlarmHigh);
    }
}

