package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
/**
 *
 * @author The LSST CCS Team
 */
public class TSConfigurable {

    private final Map<String, Integer> currentParms = new HashMap<>();
    private int min;
    private int max;
//    private TSConfig tsc = null;
    private double cryotol;

    @ConfigurationParameter(name = "bias", category = "TSConfig")
    private double biasVAcq;           // Bias volts during acquisition
    @ConfigurationParameter(name = "cryo", category = "TSConfig")
    private double cryoTAcq;           // cryo temp during acquisition
    @ConfigurationParameter(name = "vac", category = "TSConfig")
    private double vacPAcq;            // pressure during acquisition
    @ConfigurationParameter(name = "lambda", category = "TSConfig")
    private double lambdaAcq;          // wavelength during acquisition
    @ConfigurationParameter(name = "minlmppwr", category = "TSConfig")
    private double minLmpPwr;         // min. lamp power for acquisition
    @ConfigurationParameter(name = "cryotol", category = "TSConfig")
    private double cryoTAcqTol;        // tolerance on the CCD temp

    final double MIN_BIAS = -70.,
            MAX_BIAS = 0.,
            MAX_CRYO = 30.;

    public TSConfigurable(String name, double lambda, double minlmppwr, double cryotol,
            double bias, double vac, double cryo) {

//        System.out.println("TSConfigurable name = "+this.toString());
        assert (bias > MIN_BIAS);
        assert (bias < MAX_BIAS);
        assert (cryo < MAX_CRYO);

        this.biasVAcq = bias;
        this.cryoTAcq = cryo;
        this.vacPAcq = vac;
        this.lambdaAcq = lambda;
        this.minLmpPwr = minlmppwr;
        this.cryoTAcqTol = cryotol;

//        int istate = TSConfig.operating_states.valueOf(name).ordinal();
//        tsc.update(istate, biasVAcq, cryoTAcq, cryoTAcqTol, vacPAcq, lambdaAcq);
    }

    @ConfigurationParameterChanger(propertyName = "bias")
    public void setBiasVAcq(Object Vacq) {
        double bias = (double) Vacq;
        assert (bias > MIN_BIAS);
        assert (bias < MAX_BIAS);
        System.out.println("configuring bias setpoint to "+bias);
        this.biasVAcq = (double) bias;
    }

    @ConfigurationParameterChanger(propertyName = "cryo")
    public void setCryoTAcq(Object temp) {
        double cryo = (double) temp;
        assert (cryo < MAX_CRYO);
        System.out.println("configuring cryo temperature setpoint to "+cryo);
        this.cryoTAcq = (double) temp;
    }

    @ConfigurationParameterChanger(propertyName = "cryotol")
    public void setCryoTAcqTol(Object tempTol) {
        this.cryoTAcqTol = (double) tempTol;
    }

    @ConfigurationParameterChanger(propertyName = "vac")
    public void setVacPAcq(Object torr) {
        this.vacPAcq = (double) torr;
    }

    @ConfigurationParameterChanger(propertyName = "minlmppwr")
    public void setLmpPwr(Object LmpPwr) {
        this.minLmpPwr = (double) LmpPwr;
    }

    @ConfigurationParameterChanger
    public void setCurrentParms(Object currentParms) {
        Map<String, Integer> map = (Map<String, Integer>) currentParms;
        this.currentParms.putAll(map);
    }

}
