package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;

/**
 *
 * Device class for the MicroIon driver
 *
 * @author homer
 */
public class MicroIonSimDevice extends MicroIonDevice implements VacuumGaugeDevice {

    private final static Map<String, Integer> typeMap = new HashMap<>();

    static {
        typeMap.put("TEMP", Channel.TYPE_TEMP);
        typeMap.put("VOLTS", Channel.TYPE_VOLTS);
        typeMap.put("CURR", Channel.TYPE_POWER);
        typeMap.put("PRESSURE", Channel.TYPE_UNKNOWN);
        typeMap.put("WAVELENGTH", Channel.TYPE_SWITCH);
        typeMap.put("PA", Channel.TYPE_UNKNOWN);
    }


    TSConfig cfg = new TSConfig();

    private double[] runVac = new double[cfg.MAXSTATES]; // desired pressure for acquisitions

    public MicroIonSimDevice(int itype, String host, int port, int addr) throws DriverException {
        /*
         try {
         microDev = new MicroIon();
         microDev.openSerial(host, port, addr);
         } catch (DriverException e) {
         System.out.println("Failed to open connection to MicroIon device!");
         }
         */
    }

    /**
     ***************************************************************************
     **
     ** isVacuumGaugeOn - Is the MicroIon Device on? *
     * **************************************************************************
     */
    @Command(name = "isgaugeon", description = "returns whether the MicroIon device is active")
    public boolean isVacuumGaugeOn() {
        boolean state = true;
        /*
         try {
         state = microDev.getState() == MicroIon.onOff.ON;
         }
         catch (DriverException e) {
         log.error("MicroIon device failed to close!!!");
         }
         */
        return (state);
    }

    /**
     ***************************************************************************
     **
     ** returns the pressure read from the MicroIon device *
     * **************************************************************************
     */
    @Command(name = "readpressure", description = "returns the pressure read from the MicroIon device")
    public double readPressure() {
        double pressure = 0.0;
        /*
         try {
         pressure = microDev.getPressure();
         }
         catch (DriverException e) {
         log.error("MicroIon device failed to return pressure reading!!!");
         }
         */
        pressure = this.getRunVac(1) + Math.random() * 1.e-8;
        return (pressure);
    }


    /**
     ***************************************************************************
     **
     ** Initializes the connection. *
     * **************************************************************************
     */
    @Override
    protected void initialize() {
        setOnline(true);
        /*
         try {
         log.error("MicroIon device initialized.");
         log.error("State of of the MicroIon device is"
         + ( microDev.getState()==MicroIon.onOff.ON ? "ON" : "OFF" ));
         setOnline(true);
         }
         catch (DriverException e) {
         log.error("MicroIon device failed to initialize!!!");
         }
         */
    }

}
