/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.newportlamp.NewportLamp;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.teststand.LampDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;

public class NewportLampDevice
extends Device
implements LampDevice {
    private NewportLamp lampDev = new NewportLamp();
    private String lampType = "undef";
    TSConfig cfg = new TSConfig();
    private double[] runlampcurr = new double[TSConfig.MAXSTATES];
    private DriverConstants.ConnType connType = DriverConstants.ConnType.SERIAL;
    private int baud;
    private String devcName;
    boolean isConnected = false;
    boolean failedToInitialize = false;

    public NewportLampDevice(String host, int port) throws DriverException {
        this(DriverConstants.ConnType.SERIAL, host, port);
    }

    public NewportLampDevice(DriverConstants.ConnType itype, String devcName, int baud) throws DriverException {
        this.connType = itype;
        this.devcName = devcName;
        this.baud = baud;
    }

    @Override
    @Command(name="isLampPowerOn", description="returns whether the NewportLamp device is active")
    public boolean isLampPowerOn() {
        boolean state = false;
        try {
            state = this.lampDev.getState();
        }
        catch (DriverException e) {
            this.log.error((Object)"NewportLamp device failed to close!!!");
        }
        return state;
    }

    @Override
    @Command(name="setLampPowerEnable", description="enables/disables the power to the lamp from the NewportLamp device")
    public void setLampPowerEnable(@Argument(name="enable", description="enables/disables lamp power") boolean on) {
        try {
            this.log.debug((Object)("Setting lamp power state to " + on));
            this.lampDev.setState(on);
        }
        catch (DriverException e) {
            throw new RuntimeException("NewportLamp device failed to set lamp power enable/disable!!!", e);
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getLampCurrent", description="returns the #amps read from the NewportLamp device")
    public double getLampCurrent() {
        double current = 0.0;
        try {
            if (this.isConnected) {
                current = this.lampDev.getAmps();
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"NewportLamp device failed to return current reading!!!");
        }
        return current;
    }

    @Override
    @Command(name="setLampCurrent", description="(not implemented) sets the current for the NewportLamp device")
    public void setLampCurrent(double current) {
        this.log.error((Object)"Purposely not implemented");
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getLampPower", description="returns the #amps read from the NewportLamp device")
    public double getLampPower() {
        double pwr = 0.0;
        try {
            if (this.isConnected) {
                pwr = this.lampDev.getWatts();
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"NewportLamp device failed to return power reading!!!");
        }
        return pwr;
    }

    @Command(name="setLampPower", description="(not implimented) sets the power for the NewportLamp device")
    public void setLampPower(double current) {
        this.log.error((Object)"Purposely not implemented!!!");
    }

    @Override
    @Command(name="setType", description="define lamp type")
    public void setType(String type) {
        this.lampType = type;
    }

    @Override
    @Command(name="getType", description="returns the lamp type")
    public String getType() {
        return this.lampType;
    }

    @Override
    @Command(name="getLampIdent", description="returns the identity read from the NewportLamp device")
    public String getLampIdent() {
        String ident = "";
        try {
            ident = this.lampDev.getIdent();
        }
        catch (DriverException e) {
            this.log.error((Object)"NewportLamp device failed to return identity!!!");
        }
        return ident;
    }

    protected void close() {
        try {
            this.lampDev.close();
        }
        catch (DriverException e) {
            this.log.error((Object)"NewportLamp device failed to close!!!");
        }
    }

    protected void initialize() {
        if (this.lampDev != null) {
            try {
                this.lampDev.open(this.connType, this.devcName, this.baud);
                this.log.info((Object)("State of the NewportLamp device is" + (this.lampDev.getState() ? "ON" : "OFF")));
                this.log.info((Object)"NewportLamp device initialized.");
                this.isConnected = true;
                this.setOnline(true);
            }
            catch (DriverException e) {
                if (!this.failedToInitialize) {
                    this.log.error((Object)"NewportLamp device failed to initialize!!!");
                }
                this.failedToInitialize = true;
            }
        }
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        this.log.debug((Object)("NewportLampDevice readChannel called! chan=" + chan + " type=" + type));
        try {
            value = chan == 1 ? this.getLampCurrent() : this.getLampPower();
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading channel type " + type + " channel " + chan), (Throwable)e);
        }
        return value;
    }

    public void setRunlampcurr(double runlampcurr, int iwstate) {
        this.runlampcurr[iwstate] = runlampcurr;
    }

    public double getRunlampcurr(int iwstate) {
        return this.runlampcurr[iwstate];
    }

    @Command(name="setPowerPreset", description="Set the power preset", type=Command.CommandType.ACTION)
    public void setPowerPreset(@Argument(name="powerPreset", description="desired power") int powerPreset) throws DriverException {
        this.lampDev.setPowerPreset(powerPreset);
    }

    @Command(name="getStatus", description="Read Status", type=Command.CommandType.QUERY)
    public String getStatus() throws DriverException {
        return this.lampDev.getStatus();
    }

    @Command(name="getPowerPreset", description="Read Power Preset", type=Command.CommandType.QUERY)
    public int getPowerPreset() throws DriverException {
        return this.lampDev.getPowerPreset();
    }

    @Command(name="getVolts", description="Read Volts", type=Command.CommandType.QUERY)
    public double getVolts() throws DriverException {
        return this.lampDev.getVolts();
    }

    @Command(name="getLampHrs", description="Read Lamp Hrs", type=Command.CommandType.QUERY)
    public String getLampHrs() throws DriverException {
        return this.lampDev.readNewportLamp("LAMP HRS?");
    }

    @Command(name="genericRead", description="Generic read", type=Command.CommandType.QUERY)
    public String genericRead(@Argument(name="command", description="generic read command") String command) throws DriverException {
        return this.lampDev.readNewportLamp(command);
    }
}

