import static org.lsst.gruth.jutils.MapArgs.*;
import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.teststand.TSSubSys;
import org.lsst.ccs.subsystem.teststand.KeithleyDevice;
import org.lsst.ccs.subsystem.teststand.CryoCon24cDevice;
import org.lsst.ccs.subsystem.teststand.MicroIonDevice;
import org.lsst.ccs.subsystem.teststand.NewportLampDevice;
import org.lsst.ccs.subsystem.teststand.Cornerstone260Device;
import org.lsst.ccs.subsystem.teststand.NetBotzDevice;
import org.lsst.ccs.subsystem.teststand.XEDDevice;

import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.monitor.Line;
import org.lsst.ccs.monitor.Channel;


CCSBuilder builder = ["ts"]

builder.
    main (TSSubSys, argMap("main", 10000, "lpnhe")) {

    Bias  (KeithleyDevice, argMap("A603EPZY",19200))

    Cryo   (CryoCon24cDevice, argMap(1,"A603EPZZ",19200))
  
    VacuumGauge (MicroIonDevice, argMap(1, "ZM", 19200, 2))
    
    Enviro (NetBotzDevice)

    Lamp (NewportLampDevice, argMap(1, "?", 9600))
    
    Monochromator (Cornerstone260Device, argMap(1, "?", 19200))
    
//    AlarmHDW  (TSSubSys, argMap("OV", 0))
    AlarmHDW  (Alarm, argMap(null, 0))



    /*
    CmpCCDBias  (MonChannel,
        argMap("CCD Bias Voltage", "V",
                           "alarm", 0.0), 0.0,
                           "alarm", 0.0), 0.0,
                           "Bias", 0, "VOLT", "B", 0, 0.0, 1.0))
      */      
     /*
         Its name, used to identify it in databases, plots, etc.
    Its longer, more descriptive, name.
    The units the value is expressed in, e.g. "Volts".
    The device used for obtaining its value.
    The hardware channel number on the device.
    The channel type, e.g. temperature, pressure, etc, which is needed by some devices.
    The subtype, which supplies hardware configuration information.
    The offset and scale values needed for converting a raw hardware value to a physical one.
    Parameters used for checking the value against a limit.  There is one set for the low limit and one for the high one:
        The checking option: NONE, FLAG or ALARM
        The limit value.
        The alarm to be activated upon status transitions when ALARM is specified.
        The deadband value which delays a potential alarm action during a transition back to good status.
    Its id, which is its index in the list of all channels.

The limit values are maintained by the configuration system and can be changed while running.  Any such change causes a status message to be broadcast, which can be used to update the trending database or to update any console displays.
*/
        ccdtemperature  (Channel,
                    argMap("Cryogenics temperature", "C",
                           "Cryo", 0, "TEMP", "T", 0.0, 1.0,
                           "flag", -110.0, 0.0, null,
                           "alarm", 28.0, 0.0, "AlarmHDW"))

        ccdtempsetpoint  (Channel,
                    argMap("CCD temp setpoint", "C",
                           "Cryo", -1, "TEMP", "T", 0.0, 1.0,
                           "flag", -110.0, 0.0, null,
                           "flag", 28.0, 0.0, null))

        ccdbiasvoltage  (Channel,
                    argMap("CCD bias supply voltage", "V",
                           "Bias", 0, "VOLTS", "V", 0.0, 1.0,
                           "alarm", -71.5, 0.0, "AlarmHDW",
                           "alarm", 4.0, 0.0, "AlarmHDW"))

        photodiodecurrent  (Channel,
                    argMap("CCD bias supply current", "I",
                           "Bias", 0, "CURR", "I", 0.0, 1.0,
                           "flag", 0.0, 0.0, null,
                           "flag", 1.0, 0.0, null))

        dewarpressure  (Channel,
                    argMap("Dewar Vacuum Reading", "T",
                           "VacuumGauge", 0, "PRESSURE", "T", 0.0, 1.0,
                           "flag", 0.0, 0.0, null,
                           "flag", 800.0, 0.0, null))


        lamppower  (Channel,
                    argMap("Xenon Lamp Current", "A",
                           "Lamp", 0, "AMPS", "A", 0.0, 1.0,
                           "flag", 0.0, 0.0, null,
                           "flag", 800.0, 0.0, null))

        monochromatordefaultwavelength  (Channel,
                    argMap("Wavelength", "A",
                           "Monochromator", -1, "UNKNOWN", "A", 0.0, 1.0,
                           "flag", 0.0, 0.0, null,
                           "flag", 800.0, 0.0, null))

        monochromatorwavelength  (Channel,
                    argMap("Wavelength", "A",
                           "Monochromator", 0, "UNKNOWN", "A", 0.0, 1.0,
                           "flag", 0.0, 0.0, null,
                           "flag", 800.0, 0.0, null))

        shutteropen  (Channel,
                    argMap("Shutter Open/Closed", "S",
                           "Monochromator", 1, "UNKNOWN", "S", 0.0, 1.0,
                           "flag", 0.0, 0.0, null,
                           "flag", 2.0, 0.0, null))

        filter1position  (Channel,
                    argMap("Filter Position", "F",
                           "Monochromator", 2, "UNKNOWN", "F", 0.0, 1.0,
                           "flag", 0.0, 0.0, null,
                           "flag", 7.0, 0.0, null))

        cleanroomhumidity  (Channel,
                    argMap("Humidity", "P",
                           "Enviro", 0, "UNKNOWN", "P", 0.0, 1.0,
                           "flag", 0.0, 0.0, null,
                           "flag", 1.0, 0.0, null))

        roomtemperature  (Channel,
                    argMap("Temperature", "C",
                           "Enviro", 1, "UNKNOWN", "C", 0.0, 1.0,
                           "flag", 0.0, 0.0, null,
                           "flag", 30.0, 0.0, null))

        dewpoint  (Channel,
                    argMap("Dew Point", "D",
                           "Enviro", 2, "UNKNOWN", "C", 0.0, 1.0,
                           "flag", 0.0, 0.0, null,
                           "flag", 1.0, 0.0, null))

        partcounter  (Channel,
                    argMap("Particle Count", "1",
                           "Enviro", 3, "UNKNOWN", "1", 0.0, 1.0,
                           "flag", 0.0, 0.0, null,
                           "flag", 1000.0, 0.0, null))
/*

MONOTYPE Source
SRCMODL         query or config file - Manufacturer\u2019s Model number for monochromator
FILTER          Filter Desc. ts-config file that has a key table - Optical Filter used
PD_MODEL        config file - Monitor Photodiode model number
PD_SER          config file - Monitor Photodiode serial number
SRCTYPE         Type of light source used (Check with Peter)

MONOMODL        query or config - Monochromator model number
MONOPOS         Check with Peter - Monochromator grating turret position
MONOGRAT        Check with Peter - Monochromator grating in use

<done> MONOWL   Monochromator WL setting
<done> SRCPWR   Light source power
<done> ND_FILT  ND Filter after lamp (if any)

<done> TEMP_SET Temperature set point
<done> CCDTEMP  Measured temperature

<done> ROOMTEMP Room Temperature
DWRTEMP         External Dewar Temperature
<done> DWRPRESS Dewar internal pressure level

MONDIODE        Current in the monitoring diode

*/

}
