/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.cryocon;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.cryocon.M24C;
import org.lsst.ccs.drivers.scpi.TestScpi;

public class TestM24C
extends TestScpi {
    private static final DriverConstants.ConnType DEFAULT_TYPE = DriverConstants.ConnType.NET;
    private static final String BNL_DEFAULT_IP = "192.168.2.198";
    private final M24C m24c;

    public TestM24C() {
        super(new M24C());
        this.m24c = (M24C)this.scpi;
    }

    @Command(name="open", description="Open network connection to Model 24C")
    public void open(@Argument(name="host", description="Host name") String host) throws DriverException {
        this.m24c.open(DEFAULT_TYPE, host, 0);
    }

    @Command(name="open", description="Open connection to Model 24C")
    public void open(@Argument(name="type", description="Communications type") DriverConstants.ConnType type, @Argument(name="identity", description="Device identifier") String ident) throws DriverException {
        this.m24c.open(type, ident, 0);
    }

    @Command(name="openDefault", description="Open connection to BNL default Model 24C")
    public void openBNLDefault() throws DriverException {
        this.m24c.open(DEFAULT_TYPE, BNL_DEFAULT_IP, 0);
    }

    @Command(name="getMaxSetPoint", description="Retrieve MaxSetPoint for loop")
    public double getMaxSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getMaxSetPoint(loop);
    }

    @Command(name="setMaxSetPoint", description="setMaxSetPoint for loop")
    public void setMaxSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="temp", description="temperature") double temp) throws DriverException {
        this.m24c.setMaxSetPoint(loop, temp);
    }

    @Command(name="getSetPoint", description="Retrieve setPoint for loop")
    public double getSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getSetPoint(loop);
    }

    @Command(name="setSetPoint", description="setSetPoint for loop")
    public void setSetPoint(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="temp", description="temperature") double temp) throws DriverException {
        this.m24c.setSetPoint(loop, temp);
    }

    @Command(name="getLoopSource", description="Retrieve source channel for loop")
    public char getLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getSource(loop);
    }

    @Command(name="setLoopSource", description="Set source channel for loop")
    public void setLoopSource(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="channel", description="channel [A-D]") String channel) throws DriverException {
        this.m24c.setSource(loop, TestM24C.stringToChar(channel));
    }

    @Command(name="getHeaterRange", description="Retrieve heater range for loop")
    public String getHeaterRange(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHeaterRange(loop);
    }

    @Command(name="setHeaterRange", description="Set heater range for loop")
    public void setHeaterRange(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="range", description="range (lo, mid or hi)") String range) throws DriverException {
        this.m24c.setHeaterRange(loop, range);
    }

    @Command(name="getHeaterMax", description="Retrieve maximum heater power for loop")
    public double getHeaterMax(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getHeaterMax(loop);
    }

    @Command(name="setHeaterMax", description="Set maximum heater power for loop")
    public void setHeaterMax(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="power", description="maximum power (%)") double power) throws DriverException {
        this.m24c.setHeaterMax(loop, power);
    }

    @Command(name="getControlType", description="Retrieve control type for loop")
    public String getControlType(@Argument(name="loop", description="loop number [1-4]") int loop) throws DriverException {
        return this.m24c.getControlType(loop);
    }

    @Command(name="setControlType", description="Set control type for loop")
    public void setControlType(@Argument(name="loop", description="loop number [1-4]") int loop, @Argument(name="type", description="control type string") String type) throws DriverException {
        this.m24c.setControlType(loop, type);
    }

    @Command(name="getTemp", description="Retrieve temperature")
    public double getTemp(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        return this.m24c.getTemp(TestM24C.stringToChar(channel));
    }

    @Command(name="getUnit", description="Retrieve temperature units")
    public char getUnit(@Argument(name="channel", description="Temp Channel to read") String channel) throws DriverException {
        return this.m24c.getUnit(TestM24C.stringToChar(channel));
    }

    @Command(name="setUnit", description="Set temperature units")
    public void setUnit(@Argument(name="channel", description="Temp Channel to set") String channel, @Argument(name="units", description="Units in [K|C|F|S]") String unit) throws DriverException {
        this.m24c.setUnit(TestM24C.stringToChar(channel), TestM24C.stringToChar(unit));
    }

    @Command(name="getType", description="Get sensor type")
    public String getType(@Argument(name="channel", description="Channel ID") String channel) throws DriverException {
        return this.m24c.getType(TestM24C.stringToChar(channel));
    }

    @Command(name="setType", description="Set sensor type")
    public void setType(@Argument(name="channel", description="Channel ID") String channel, @Argument(name="type", description="Sensor type") String type) throws DriverException {
        this.m24c.setType(TestM24C.stringToChar(channel), type);
    }

    @Command(name="isOtdEnabled", description="Get whether OTD system enabled")
    public boolean isOtdEnabled() throws DriverException {
        return this.m24c.isOtdEnabled();
    }

    @Command(name="enableOtd", description="Set OTD system enabled state")
    public void enableOtd(@Argument(name="enab", description="Whether to enable OTD system") boolean enab) throws DriverException {
        this.m24c.enableOtd(enab);
    }

    @Command(name="getOtdSource", description="Get source channel for the OTD system")
    public char getOtdSource() throws DriverException {
        return this.m24c.getOtdSource();
    }

    @Command(name="setOtdSource", description="Set source channel for the OTD system")
    public void setOtdSource(@Argument(name="channel", description="channel [A-D]") String channel) throws DriverException {
        this.m24c.setOtdSource(TestM24C.stringToChar(channel));
    }

    @Command(name="getOtdTemp", description="Get temperature limit for the OTD system")
    public double getOtdTemp() throws DriverException {
        return this.m24c.getOtdTemp();
    }

    @Command(name="setOtdTemp", description="Set temperature limit for the OTD system")
    public void setOtdTemp(@Argument(name="temp", description="Temperature") double temp) throws DriverException {
        this.m24c.setOtdTemp(temp);
    }

    @Command(name="isInControl", description="Get whether control is on")
    public boolean isInControl() throws DriverException {
        return this.m24c.isInControl();
    }

    @Command(name="getControl", description="Get control state")
    public String getControl() throws DriverException {
        return this.m24c.getControl();
    }

    @Command(name="setToControl", description="Set control on")
    public void setToControl() throws DriverException {
        this.m24c.setToControl();
    }

    @Command(name="stopControl", description="Set control off")
    public void stopControl() throws DriverException {
        this.m24c.stopControl();
    }

    private static char stringToChar(String str) throws DriverException {
        if (str.length() != 1) {
            throw new DriverException("String must be of length 1");
        }
        return str.charAt(0);
    }
}

