/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.IManagedObject;
import hep.aida.util.XMLUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.keithley.N2502;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.BiasDevice;
import org.lsst.ccs.subsystem.teststand.PhotoDiodeDevice;
import org.lsst.ccs.subsystem.teststand.data.PDState;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class Keithley2502Device
extends Device
implements BiasDevice,
PhotoDiodeDevice {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private String host;
    private int port;
    private static final int EVENT_ID_BIAS = 0;
    private N2502 n25;
    private boolean isconnected = false;
    private double nplc = 0.0;
    private int nreads = 1;
    TSConfig cfg = null;
    private double[] runBias = new double[TSConfig.MAXSTATES];
    TSState.pwrstates kstate = TSState.pwrstates.NOTCONFIGURED;
    boolean failedToInitialize = false;
    IDataPointSetFactory dpsf = null;
    private double last_curr;
    private double last_volt;
    private int plotidx = 0;
    private boolean doPDPlot = false;

    public Keithley2502Device(String host, int port) throws DriverException {
        this.host = host;
        this.port = port;
        this.isconnected = true;
        this.n25 = new N2502();
        try {
            if (this.n25 != null) {
                this.n25.openftdi(host, port);
            }
        }
        catch (DriverException f) {
            System.out.println("Failed to open connection to Keithley device!");
            this.isconnected = false;
        }
        if (this.isconnected) {
            this.kstate = this.n25.getOutput() ? TSState.pwrstates.ON : TSState.pwrstates.OFF;
        }
    }

    public Keithley2502Device() {
    }

    @Override
    public void setCfg(TSConfig cfg) {
        this.cfg = cfg;
    }

    protected void initDevice() {
        this.fullName = "Keithley module";
    }

    @Command(name="open", description="Open connection to device using defaults")
    public void open() throws DriverException {
        if (this.n25 != null) {
            this.n25.open();
        }
        this.kstate = TSState.pwrstates.OK;
    }

    protected void close() {
        try {
            if (this.n25 != null) {
                this.n25.close();
            }
            this.kstate = TSState.pwrstates.NOTCONFIGURED;
        }
        catch (DriverException e) {
            this.log.error((Object)"Keithley device failed to close!!!");
        }
    }

    @Command(name="init", description="(re) initialize connection")
    protected void initialize() {
        this.n25.setOKTOTALK(true);
        if (this.isconnected) {
            this.log.debug((Object)"Keithley device is already initialized and connected to:");
            try {
                this.log.debug((Object)this.n25.printdevid());
            }
            catch (Exception e) {
                try {
                    this.log.info((Object)("Trying to reconnect to Keithley device at address " + this.host));
                    this.n25.close();
                    this.n25.openftdi(this.host, this.port);
                    this.log.debug((Object)this.n25.printdevid());
                }
                catch (DriverException ex) {
                    if (!this.failedToInitialize) {
                        this.log.error((Object)"Keithley device failed to respond to ident request! The initialization has FAILED.");
                        this.failedToInitialize = true;
                    }
                    this.isconnected = false;
                }
            }
            this.log.debug((Object)"Setting device online.");
            this.setOnline(true);
            this.kstate = TSState.pwrstates.OK;
        } else if (!this.failedToInitialize) {
            this.log.error((Object)"Tried to initialize unconnected bias device!");
            this.failedToInitialize = true;
        }
    }

    @Override
    public void setDPSF(IDataPointSetFactory dpsf) {
        if (this.isconnected) {
            this.dpsf = dpsf;
        }
    }

    @Command(name="open", description="Open connection to device")
    public String open(@Argument(name="host", description="Host name") String host) throws DriverException {
        this.n25.open(host);
        this.kstate = TSState.pwrstates.OK;
        return this.n25.printdevid();
    }

    @Command(name="open", description="Open connection to device")
    public String open(@Argument(name="host", description="Host name") String host, @Argument(name="port", description="Port number") int port) throws DriverException {
        this.n25.open(host, port);
        this.kstate = TSState.pwrstates.OK;
        return this.n25.printdevid();
    }

    @Command(name="openftdi", description="Open FTDI connection to device")
    public String openftdi(@Argument(name="serialname", description="Serial device name") String host, @Argument(name="baud", description="baud rate") int port) throws DriverException {
        this.n25.openftdi(host, port);
        this.kstate = TSState.pwrstates.OK;
        return this.n25.printdevid();
    }

    @Command(name="setarmcount", description="Set the ARM count")
    public void setArmCount(@Argument(name="count", description="ARM count") int count) {
        if (this.isconnected) {
            try {
                this.n25.setArmCount(count);
            }
            catch (DriverException e) {
                this.log.error((Object)("Failed to set Arm Count:" + (Object)((Object)e)));
            }
        }
    }

    @Command(name="settrigcount", description="Set the trigger count")
    public void setTrigCount(@Argument(name="value", description="trigger count") int value) throws DriverException {
        if (this.isconnected) {
            this.n25.setTrigCount(value);
        }
    }

    @Override
    @Command(name="setdisplay", description="Set the display")
    public void setDisplay(@Argument(name="OnOff", description="true(ON)/false(OFF)") boolean dstate) {
        if (this.isconnected) {
            try {
                this.n25.setDisplay(dstate);
            }
            catch (DriverException e) {
                this.log.error((Object)("Failed to set display to state " + dstate + " : " + (Object)((Object)e)));
            }
        }
    }

    @Command(name="clrbuff", description="Clears the Keithley read buffer")
    public void clearBuffer() throws DriverException {
        if (this.isconnected) {
            this.n25.clrBuff();
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="accumBuffer", description="start the buffer accumulation")
    public double accumBuffer(@Argument(name="nreads", description="#reads (armcount)") int nreads, @Argument(name="nplc", description="#Pulse Line Counts btwn reads (0.01->60.)") double nplc) {
        this.accumBuffer(nreads, nplc, true);
        this.log.info((Object)"publish that accumBuffer is done");
        PDState pdState = new PDState(2, (int)System.currentTimeMillis());
        return nplc / 60.0 * (double)nreads;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="accumBuffer", description="start the buffer accumulation")
    public double accumBuffer(@Argument(name="nreads", description="#reads (armcount)") int nreads, @Argument(name="nplc", description="#Pulse Line Counts btwn reads (0.01->60.)") double nplc, @Argument(name="wait", description="to wait (true) or not to (false)") boolean wait) {
        if (this.isconnected) {
            try {
                this.nreads = nreads;
                this.nplc = nplc;
                this.cfg.setPDcnt(nreads);
                this.cfg.setPDnplc(nplc);
                this.n25.accumBuffer(nreads, nplc, wait);
            }
            catch (DriverException e) {
                this.log.error((Object)("Failed to prep device for doing accumulations." + (Object)((Object)e)));
            }
        }
        return nplc / 60.0 * (double)nreads;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, description="Wait for data accumulation to complete")
    public void waitAccum(@Argument(description="Timeout (secs)") double timeout) {
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="readBuffer", description="read the buffer")
    public double[][] readBuffer() {
        double[][] buff = null;
        try {
            buff = this.n25.readBuffer();
        }
        catch (DriverException e) {
            this.log.error((Object)("Failed to read buffer!" + (Object)((Object)e)));
        }
        try {
            this.n25.clrBuff();
        }
        catch (DriverException e) {
            this.log.error((Object)("Failed to reset the device after buffer read!" + (Object)((Object)e)));
        }
        if (this.isDoPDPlot()) {
            this.log.error((Object)"doing new aidaplots");
            KeyValueDataList plots = new KeyValueDataList();
            this.log.debug((Object)"declaring pdthst");
            this.plotidx = this.plotidx % 3 + 1;
            IDataPointSet pdthst = this.dpsf.create("CurrentHist" + this.plotidx, "Current Reading vs. time(s) - Date:" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date(System.currentTimeMillis())), 2);
            this.log.debug((Object)"filling pdthst");
            for (int i = 0; i < this.nreads && i < buff[0].length; ++i) {
                pdthst.addPoint();
                pdthst.point(i).coordinate(0).setValue(buff[1][i]);
                pdthst.point(i).coordinate(0).setErrorPlus(0.0);
                pdthst.point(i).coordinate(1).setValue(buff[0][i]);
                pdthst.point(i).coordinate(1).setErrorPlus(0.0);
                pdthst.point(i).coordinate(1).setErrorMinus(0.0);
            }
            try {
                this.log.debug((Object)"doing new addplots");
                plots.addData("dataPointSet", (Serializable)((Object)XMLUtils.createXMLString((IManagedObject)pdthst)));
            }
            catch (IOException ex) {
                this.log.error((Object)"Unable to create XML rep of AidPlot object!", (Throwable)ex);
            }
            this.log.info((Object)"publishing plot");
            KeyValueDataList kvd = new KeyValueDataList();
            kvd.addData("PDtimeHist", (Serializable)plots);
            this.s.publishSubsystemDataOnStatusBus((KeyValueData)kvd);
        }
        return buff;
    }

    @Command(type=Command.CommandType.QUERY, name="readBuffer", description="read the buffer and dump to file")
    public double[][] readBuffer(@Argument(name="filename", description="output filename for the Keithley buffered values") String filename) {
        double[][] buff = this.readBuffer();
        FileWriter fstream = null;
        File pdFl = new File(filename);
        try {
            if (pdFl.exists()) {
                pdFl.delete();
            }
            pdFl.createNewFile();
        }
        catch (Exception e) {
            this.log.error((Object)("Unable to create file (" + filename + ") for reason " + e));
        }
        try {
            fstream = new FileWriter(pdFl);
        }
        catch (IOException e) {
            this.log.error((Object)("Failed to open writer stream for file (" + filename + ") for reason " + e));
        }
        try {
            if (fstream != null) {
                this.log.error((Object)"writing file of buffered values from either Bias or PhotoDiode device");
                BufferedWriter out = new BufferedWriter(fstream);
                String line = null;
                for (int i = 0; i < buff[0].length; ++i) {
                    line = buff[1][i] + " " + buff[0][i];
                    try {
                        out.write(line);
                        out.newLine();
                        out.flush();
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.log.error((Object)"Failed to close file!");
                }
            }
        }
        catch (Exception ee) {
            this.log.error((Object)"Failed to remove and create a new file.!");
        }
        return buff;
    }

    @Command(name="readBufferStr", description="read the buffer and returns as a string")
    public String readBufferStr() throws DriverException {
        double[][] data = this.n25.readBuffer();
        return "Data = " + this.getString(data[0]) + "\n Times = " + this.getString(data[1]) + "\n";
    }

    @Override
    @Command(name="setBuffSize", description="Set the buffer size.")
    public void setBuffSize(@Argument(name="value", description="buffer size") int value) {
        if (this.isconnected) {
            try {
                this.n25.setBuffSize(value);
            }
            catch (DriverException ex) {
                this.log.error((Object)("Failed to set Keithley buffer size!" + (Object)((Object)ex)));
            }
        }
    }

    @Override
    @Command(name="setVoltageRange", description="Set the voltage range. Can be 10V, 50V or 500V")
    public void setVoltageRange(@Argument(name="value", description="Voltage Range to set") double value) {
        try {
            if (this.isconnected) {
                this.n25.setVoltageRange(value);
            }
        }
        catch (DriverException e) {
            this.log.error((Object)("Failed to set voltage range on Bias" + (Object)((Object)e)));
        }
    }

    @Override
    @Command(name="setVoltage", description="Set the voltage")
    public void setVoltage(@Argument(name="value", description="Voltage to set") double value) {
        try {
            if (this.kstate.equals((Object)TSState.pwrstates.OK) || this.kstate.equals((Object)TSState.pwrstates.OFF)) {
                if (this.isconnected) {
                    this.n25.setVoltage(value);
                }
            } else {
                this.log.error((Object)("Unable to set output because state = " + this.kstate.toString()));
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Failed to set the Keithley voltage!");
        }
    }

    @Override
    @Command(name="setChannel", description="Select the channel")
    public void setChannel(@Argument(name="value", description="Channel to select") int value) {
        if (this.isconnected) {
            this.n25.setChannel(value);
        }
    }

    @Override
    @Command(name="setVoltageAcq", description="Set the voltage to the acquisition set point")
    public void setVoltageAcq(int cfgstate) {
        double value = this.getRunBias(cfgstate);
        this.rampVolts(5.0, value);
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="rampVolts", description="ramp the voltage")
    public void rampVolts(@Argument(name="duration", description="number of seconds to ramp from current voltage to desired voltage") double duration, @Argument(name="value", description="Voltage to ramp to") double value) {
        try {
            if (this.isconnected) {
                this.n25.rampVolts(duration, value);
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Keithley driver failed to ramp volts!");
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="rampVolts", description="ramp the voltage")
    public void rampVolts(@Argument(name="duration", description="number of seconds to ramp from current voltage to desired voltage") double duration, @Argument(name="value", description="Voltage to ramp to") double value, @Argument(name="nsteps", description="number of steps") int nsteps) {
        try {
            if (this.isconnected) {
                this.n25.rampVolts(duration, value, nsteps);
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Keithley driver failed to ramp volts!");
        }
    }

    @Override
    @Command(description="return last current measurement")
    public double getLastCurrent() {
        return this.last_curr;
    }

    @Override
    @Command(description="return last voltage measurement")
    public double getLastVoltage() {
        return this.last_volt;
    }

    @Command(name="getVoltage", description="Show the set voltage")
    public double getVoltage() throws DriverException {
        return this.n25.getVoltage();
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="readVoltage", description="Read the actual voltage")
    public double readVoltage() {
        double volt = 0.0;
        try {
            if (this.n25.isOKTOTALK()) {
                this.last_volt = volt = this.n25.readVoltage();
            } else {
                System.out.print("x");
                volt = this.last_volt;
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"Keithley driver failed to read voltage!");
        }
        return volt;
    }

    @Command(name="setVoltageLimit", description="Set the soft voltage limit")
    public void setVoltageLimit(@Argument(name="value", description="Voltage limit to set") double value) throws DriverException {
        if (this.isconnected) {
            this.n25.setVoltageLimit(value);
        }
    }

    @Command(name="getVoltageLimit", description="Show the soft voltage limit")
    public String getVoltageLimit() throws DriverException {
        return "Voltage limit = " + this.n25.getVoltageLimit();
    }

    @Override
    @Command(name="setCurrentRange", description="Set the current range")
    public void setCurrentRange(@Argument(name="value", description="Current Range to set") double value) {
        if (this.isconnected) {
            try {
                this.n25.setCurrentRange(value);
            }
            catch (DriverException ex) {
                this.log.error((Object)("Failed to set the current range: " + (Object)((Object)ex)));
            }
        }
    }

    @Command(name="setCurrent", description="Set the current")
    public void setCurrent(@Argument(name="value", description="Current to set") double value) {
        try {
            if (this.isconnected) {
                this.n25.setCurrent(value);
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Keithley driver failed to set current!");
        }
    }

    @Command(name="zeroCorrectCurrent", description="Zero correct the current")
    public void zeroCorrectCurrent() throws DriverException {
        if (this.isconnected) {
            this.n25.zeroCorrectCurrent();
        }
    }

    @Command(type=Command.CommandType.QUERY, name="getCurrent", description="Show the set current")
    public double getCurrent() {
        double curr = 0.0;
        try {
            curr = this.n25.getCurrent();
        }
        catch (DriverException e) {
            this.log.error((Object)"Keithley driver failed to get the current!!");
        }
        return curr;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="readCurrent", description="Read the actual current")
    public double readCurrent() {
        this.log.debug((Object)"KeithleyDevice executing readcurrent operation:");
        double curr = 0.0;
        if (this.isconnected) {
            try {
                if (this.n25.isOKTOTALK()) {
                    this.last_curr = curr = this.n25.readCurrent();
                } else {
                    System.out.print("x");
                    curr = this.last_curr;
                }
            }
            catch (DriverException e) {
                this.log.error((Object)"Keithley driver failed to retrieve the current measurement!");
            }
        }
        return curr;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="isAccumInProgress", description="Are the current readings being accumulated")
    public boolean isAccumInProgress() {
        this.log.debug((Object)"checking is accumulation in progress");
        boolean inProgress = false;
        if (this.isconnected) {
            inProgress = !this.n25.isOKTOTALK();
        }
        return inProgress;
    }

    @Override
    @Command(name="setCurrentLimit", description="Set the soft current limit")
    public void setCurrentLimit(@Argument(name="value", description="Current limit to set") double value) {
        if (this.isconnected) {
            try {
                this.n25.setCurrentLimit(value);
            }
            catch (DriverException ex) {
                this.log.error((Object)("Keithley driver failed to set the current limit! " + (Object)((Object)ex)));
            }
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="showcurrlim", description="Show the soft current limit")
    public String getCurrentLimit() {
        double cur_lim = 0.0;
        try {
            cur_lim = this.n25.getCurrentLimit();
        }
        catch (DriverException ex) {
            this.log.error((Object)("Keithley driver failed to get the current limit! " + (Object)((Object)ex)));
        }
        return "Current limit = " + cur_lim;
    }

    @Override
    @Command(name="setRate", description="sets the read rate in plc")
    public void setRate(@Argument(name="rate", description="number of PLC") double rate) {
        try {
            if (this.isconnected) {
                this.n25.setRate(rate);
            }
        }
        catch (DriverException e) {
            this.log.error((Object)("Keithley driver failed to set the read rate!" + (Object)((Object)e)));
        }
    }

    @Override
    @Command(name="setOutput", description="Turn output on or off. 1 ==> ON")
    public void setOutput(@Argument(name="state", description="Output state: on or off") int state) {
        try {
            if (this.kstate.equals((Object)TSState.pwrstates.OK) || this.kstate.equals((Object)TSState.pwrstates.OFF)) {
                if (this.isconnected) {
                    this.n25.setOutput(state == 1);
                }
            } else {
                this.log.error((Object)("Unable to set output because state = " + this.kstate.toString()));
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"Keithley driver failed to set the output state!");
        }
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="showoutput", description="Show the output state")
    public boolean showOutput() {
        boolean state = false;
        try {
            state = this.n25.getOutput();
        }
        catch (DriverException e) {
            this.log.error((Object)"Keithley driver failed to read output state!");
        }
        return state;
    }

    public StringBuilder getString(double[] values) {
        StringBuilder text = new StringBuilder();
        text.append(values[0]);
        for (int j = 1; j < values.length; ++j) {
            text.append(", ").append(values[j]);
        }
        return text;
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    @Override
    @Command(name="setTimeout", description="set timeout for Keithley SCPI communication")
    public void setTimeout(@Argument(name="nsec", description="length of timeout in seconds") double nsec) {
        try {
            this.n25.setTimeout(nsec);
        }
        catch (DriverException ex) {
            this.log.error((Object)("Failed to set keithley scpi timeout:" + (Object)((Object)ex)));
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        } else if (iType != 1 && iType != 2) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"Wrong channel type specified! type = ", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
        try {
            if (type == 1) {
                this.log.debug((Object)("setting channel online - chan=" + chan));
                this.setOnline(true);
            }
            if (type == 2) {
                this.log.debug((Object)("setting channel online - chan=" + chan));
                this.setOnline(true);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error configuring channel type " + type + ": " + e));
        }
    }

    @Override
    @Command(name="reset", description="reset trips etc...")
    public void reset() {
        if (!this.kstate.equals((Object)TSState.pwrstates.TRIPPED)) {
            if (this.isconnected) {
                try {
                    this.n25.reset();
                    this.log.info((Object)"Keithley reset performed.");
                    this.n25.setTrip(false);
                    this.log.info((Object)"reset trip, if there was one");
                }
                catch (Exception ex) {
                    this.log.error((Object)("failed attemp to reset device:" + ex));
                }
            }
        } else {
            this.log.error((Object)("Unable to set output because state = " + this.kstate.toString() + "MUST USE SUBSYSTEM resetTrip COMMAND TO RECOVER"));
        }
        this.kstate = TSState.pwrstates.OFF;
    }

    @Override
    @Command(name="softReset", description="soft reset etc...")
    public void softReset() {
        if (!this.kstate.equals((Object)TSState.pwrstates.TRIPPED)) {
            if (this.isconnected) {
                try {
                    this.n25.softReset();
                    this.log.info((Object)"Keithley soft reset performed.");
                    this.n25.setTrip(false);
                }
                catch (Exception ex) {
                    this.log.error((Object)("failed attemp to reset device:" + ex));
                }
            }
        } else {
            this.log.error((Object)("Unable to set output because state = " + this.kstate.toString() + "MUST USE SUBSYSTEM resetTrip COMMAND TO RECOVER"));
        }
        this.kstate = TSState.pwrstates.OFF;
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        this.log.debug((Object)("KeithleyDevice readChannel called! chan=" + chan + " type=" + type));
        try {
            if (type == 1) {
                value = this.readVoltage();
            }
            if (type == 2) {
                value = this.readCurrent();
            }
            if (value < -998.0 || value > 9.8E36) {
                value = Double.NaN;
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Error reading channel type " + type + ": " + e));
        }
        return value;
    }

    @Override
    @Command(name="setrunbias", description="Sets the bias value for acquisition")
    public void setRunBias(double runBias, int cfgstate) {
        this.runBias[cfgstate] = runBias;
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getRunBias", description="Returns the bias value for acquisition")
    public double getRunBias(int cfgstate) {
        return this.runBias[cfgstate];
    }

    @Override
    @Command(name="abort", description="abort or clear abort for any long operation")
    public void setAbort(boolean state) {
        this.n25.setAbort(state);
    }

    @Override
    @Command(name="setstate", description="set keithley device status")
    public void setState(int istate) {
        if (istate == TSState.pwrstates.TRIPPED.ordinal()) {
            this.n25.setTrip(true);
        }
        this.kstate = TSState.pwrstates.values()[istate];
    }

    @Override
    @Command(type=Command.CommandType.QUERY, name="getState", description="get keithley device status")
    public int getState() {
        return this.kstate.ordinal();
    }

    public boolean isDoPDPlot() {
        return this.doPDPlot;
    }

    @Override
    @Command(description="set whether PD plots are produced")
    public void setDoPDPlot(@Argument(description="true for do plots") boolean doPDPlot) {
        this.doPDPlot = doPDPlot;
    }

    @Override
    @Command(name="send", description="write a string to the device")
    public void send(String str) {
        try {
            System.out.println("Sending command: " + str);
            this.n25.writeKthly(str);
        }
        catch (DriverException e) {
            this.log.error((Object)e);
        }
    }

    @Override
    @Command(name="send", description="write a string to the device")
    public void send(String str1, String str2) {
        try {
            String line = str1 + " " + str2;
            System.out.println("Sending command: " + line);
            this.n25.writeKthly(line);
        }
        catch (DriverException e) {
            this.log.error((Object)e);
        }
    }

    @Override
    @Command(name="query", description="write a command and read response")
    public String query(String str) {
        String rtstr = "";
        try {
            System.out.println("Sending command: " + str);
            rtstr = this.n25.readStringKthly(str);
        }
        catch (DriverException e) {
            this.log.error((Object)e);
        }
        return rtstr;
    }

    @Override
    @Command(name="query", description="write a command and read response")
    public String query(String str1, String str2) {
        String rtstr = "";
        try {
            String line = str1 + " " + str2;
            System.out.println("Sending command: " + line);
            rtstr = this.n25.readStringKthly(line);
        }
        catch (DriverException e) {
            this.log.error((Object)e);
        }
        return rtstr;
    }

    static {
        typeMap.put("TEMP", 0);
        typeMap.put("VOLTS", 1);
        typeMap.put("CURR", 2);
        typeMap.put("PRESSURE", -1);
        typeMap.put("WAVELENGTH", 3);
        typeMap.put("PA", -1);
    }
}

