/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.dataforth;

import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.drivers.dataforth.Maq20Analog;

public class Maq20AnalogOut
extends Maq20Analog {
    public Maq20AnalogOut(Maq20 maq, int modId) throws DriverException {
        super(maq, modId);
        if (this.module.opType != 1) {
            throw new DriverException("Invalid module type (" + (Object)((Object)this.module.type) + ") for analog output operations");
        }
    }

    public void writeValue(int chan, int count, double[] data) throws DriverException {
        int nChan = count >= 0 ? count : this.module.numOutChan - chan;
        this.checkChannel(chan, nChan);
        if (nChan == 0) {
            return;
        }
        short[] raw = new short[nChan];
        int j = 0;
        while (j < nChan) {
            int range = this.module.range[chan];
            raw[j] = (short)((data[j] + this.module.offset[range]) / this.module.scale[range]);
            ++j;
            ++chan;
        }
        this.maq.writeRegisters((short)(this.module.baseAddr + 1000 + chan), raw);
    }

    public void writeValue(int chan, double data) throws DriverException {
        this.writeValue(chan, 1, new double[]{data});
    }

    public void writeValue(double[] data) throws DriverException {
        this.writeValue(0, -1, data);
    }

    private void checkChannel(int chan, int count) throws DriverException {
        int numChan = this.module.numOutChan;
        if (chan < 0 || chan >= numChan) {
            throw new DriverException("Invalid channel number");
        }
        if (count < 0 || chan + count > numChan) {
            throw new DriverException("Invalid channel count");
        }
    }
}

