package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;

/**
 ******************************************************************************
 **
 ** Implements the test stand EO sensor modular subsystem.
 *
 * @author The LSST CCS Team *
 * *****************************************************************************
 */
public class TS8Bench implements HasLifecycle {

    @LookupField(strategy = LookupField.Strategy.CHILDREN)
    Map<String, PhotoDiodeDevice> photoDiodeMap = new HashMap<>();
    @LookupField(strategy = LookupField.Strategy.CHILDREN)
    MonochromatorDevice monoDevc;

    @LookupField(strategy = LookupField.Strategy.TOP)
    Subsystem subsys;

    @LookupName
    private String name;

    /**
     * Post-initialization
     */
    @Override
    public void postInit() {

        /** 
         * By setting TESTSTAND_TYPE_AGENT_PROPERTY we signal to consoles 
         * that this subsystem is compatible with the teststand subsystm GUI
         */
        subsys.setAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY, TS8Bench.class.getCanonicalName());

    }
    
}
