/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.AmbiguousCommandException;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.DefaultDictionaryCompleter;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryCompleter;
import org.lsst.ccs.command.DictionaryUtils;
import org.lsst.ccs.command.annotations.Command;

class MethodBasedCommandDictionary
extends ArrayList<DictionaryCommand>
implements Dictionary {
    private static final long serialVersionUID = 4401762766383746012L;
    private final DefaultDictionaryCompleter completer = new DefaultDictionaryCompleter(this);
    private int level = 99999;
    private Map<Command.CommandType, Boolean> visibilityByType = new HashMap<Command.CommandType, Boolean>();

    MethodBasedCommandDictionary() {
    }

    @Override
    public boolean containsCommand(BasicCommand tc) throws CommandArgumentMatchException {
        return this.findCommand(tc) != null;
    }

    @Override
    public DictionaryCommand findCommand(BasicCommand tc) throws CommandArgumentMatchException {
        String command = tc.getCommand();
        int argumentCount = tc.getArgumentCount();
        ArrayList<DictionaryCommand> matches = new ArrayList<DictionaryCommand>();
        ArrayList<CommandArgumentMatchException> exceptions = new ArrayList<CommandArgumentMatchException>();
        for (DictionaryCommand def : this) {
            try {
                if (!DictionaryUtils.commandMatch(def, tc)) continue;
                matches.add(def);
            }
            catch (CommandArgumentMatchException ex) {
                exceptions.add(ex);
            }
        }
        if (matches.isEmpty()) {
            CommandArgumentMatchException.throwExceptionIfNeeded(exceptions);
            return null;
        }
        if (matches.size() == 1) {
            return (DictionaryCommand)matches.get(0);
        }
        throw new AmbiguousCommandException("Error finding command " + command + " with " + argumentCount + " arguments: " + matches.size() + " matches found in MethodBasedCommandDictionary");
    }

    @Override
    public DictionaryCompleter getDictionaryCompleter() {
        return this.completer;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setVisibilityForTypes(Command.CommandType ... types) {
        if (this.visibilityByType == null) {
            this.visibilityByType = new HashMap<Command.CommandType, Boolean>();
        }
        for (Command.CommandType type : Command.CommandType.values()) {
            this.visibilityByType.put(type, false);
        }
        for (Command.CommandType type : types) {
            this.visibilityByType.put(type, true);
        }
    }

    @Override
    public boolean getVisibilityForType(Command.CommandType type) {
        if (this.visibilityByType == null) {
            this.visibilityByType = new HashMap<Command.CommandType, Boolean>();
        }
        return this.visibilityByType.get((Object)type) == null ? true : this.visibilityByType.get((Object)type);
    }
}

