/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.auxelex;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.auxelex.HeaterPS;
import org.lsst.ccs.drivers.auxelex.TestRebBulkPS;
import org.lsst.ccs.drivers.auxelex.TestSrp;
import org.lsst.ccs.drivers.commons.DriverException;

public class TestHeaterPS
extends TestSrp {
    protected final HeaterPS htr;

    public TestHeaterPS() {
        super(new HeaterPS());
        this.htr = (HeaterPS)this.srp;
    }

    @Command(description="Read the board temperature")
    public double readBoardTemp() throws DriverException {
        return this.htr.readBoardTemperature();
    }

    @Command(description="Set the common switch period")
    public void setSwitchPeriod(@Argument(description="Switch period") int period) throws DriverException {
        this.htr.setSwitchPeriod(period);
    }

    @Command(description="Show the common switch period")
    public int showSwitchPeriod() {
        return this.htr.getSwitchPeriod();
    }

    @Command(description="Set the duty cycle for a channel")
    public void setDutyCycle(@Argument(description="Channel number") int chan, @Argument(description="Duty cycle") double duty) throws DriverException {
        this.htr.setDutyCycle(chan, duty);
    }

    @Command(description="Show the duty cycle for a channel")
    public double showDutyCycle(@Argument(description="Channel number") int chan) throws DriverException {
        return this.htr.getDutyCycle(chan);
    }

    @Command(description="Turn on/off a channel")
    public void setOutput(@Argument(description="Channel number") int chan, @Argument(description="State to set") TestSrp.OnOff state) throws DriverException {
        this.htr.setOutput(chan, state == TestSrp.OnOff.ON);
    }

    @Command(description="Show the state of a channel")
    public String showOutput(@Argument(description="Channel number") int chan) throws DriverException {
        return this.htr.getOutput(chan) ? "on" : "off";
    }

    @Command(description="Read a channel's voltage")
    public double readVoltage(@Argument(description="Channel number") int chan) throws DriverException {
        return this.htr.readVoltage(chan);
    }

    @Command(description="Read a channel's current")
    public double readCurrent(@Argument(description="Channel number") int chan) throws DriverException {
        return this.htr.readCurrent(chan);
    }

    @Command(description="Show the complete power state")
    public String showPower() throws DriverException {
        StringBuilder text = new StringBuilder("Chan  State   Duty  Volts   mAmps");
        for (int chan = 0; chan < 12; ++chan) {
            text.append(String.format("\n %2s    %3s   %5.3f  %5.2f  %6.1f", chan, this.htr.getOutput(chan) ? " on" : "off", this.htr.getDutyCycle(chan), this.htr.readVoltage(chan), 1000.0 * this.htr.readCurrent(chan)));
        }
        return text.toString();
    }

    @Command(description="Show the main model type")
    public int showMainModel() throws DriverException {
        return this.htr.getMainModel();
    }

    @Command(description="Show the main serial number")
    public String showMainSerial() throws DriverException {
        return this.htr.getMainSerialNo();
    }

    @Command(description="Show the main firmware version")
    public String showMainFwVersion() throws DriverException {
        return this.htr.getMainFwVersion();
    }

    @Command(description="Show the main product version")
    public String showMainPrVersion() throws DriverException {
        return this.htr.getMainPrVersion();
    }

    @Command(description="Show the main part number")
    public String showMainPartNo() throws DriverException {
        return this.htr.getMainPartNo();
    }

    @Command(description="Show the main manufacture date")
    public String showMainManuDate() throws DriverException {
        return this.htr.getMainManuDate();
    }

    @Command(description="Show the main manufacture location")
    public String showMainManuLocn() throws DriverException {
        return this.htr.getMainManuLocn();
    }

    @Command(description="Read the main status word")
    public String readMainStatus() throws DriverException {
        int status = this.htr.readMainStatus();
        return String.format("0x%02x %s", status, TestRebBulkPS.genBitNames(status, TestRebBulkPS.statBitsMap));
    }

    @Command(description="Read the main voltage")
    public double readMainVoltage() throws DriverException {
        return this.htr.readMainVoltage();
    }

    @Command(description="Read the main current")
    public double readMainCurrent() throws DriverException {
        return this.htr.readMainCurrent();
    }

    @Command(description="Read the main temperature")
    public double readMainTemp() throws DriverException {
        return this.htr.readMainTemperature();
    }

    @Command(description="Set the main power on or off")
    public void setMainPower(TestSrp.OnOff on) throws DriverException {
        this.htr.setMainPowerOn(on == TestSrp.OnOff.ON);
    }

    @Command(description="Show the main I/O status")
    public String showMainIoStatus() throws DriverException {
        int status = this.htr.getMainIoStatus();
        return String.format("0x%02x %s", status, TestRebBulkPS.genBitNames(status, TestRebBulkPS.ioBitsMap));
    }
}

