package org.lsst.ccs.subsystem.teststand;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;

/**
 *
 * @author The LSST CCS Team
 */
public class TSSetDevTypes {
    
    @ConfigurationParameter(name = "filter1", category = "DevTypes")
    private String filter1;
    @ConfigurationParameter(name = "filter2", category = "DevTypes")
    private String filter2;
    @ConfigurationParameter(name = "filter3", category = "DevTypes")
    private String filter3;
    @ConfigurationParameter(name = "filter4", category = "DevTypes")
    private String filter4;
    @ConfigurationParameter(name = "filter5", category = "DevTypes")
    private String filter5;
    @ConfigurationParameter(name = "filter6", category = "DevTypes")
    private String filter6;
    @ConfigurationParameter(name = "filteredge1", category = "DevTypes")
    private double filteredge1;
    @ConfigurationParameter(name = "filteredge2", category = "DevTypes")
    private double filteredge2;
    @ConfigurationParameter(name = "filteredge3", category = "DevTypes")
    private double filteredge3;
    @ConfigurationParameter(name = "filteredge4", category = "DevTypes")
    private double filteredge4;
    @ConfigurationParameter(name = "filteredge5", category = "DevTypes")
    private double filteredge5;
    @ConfigurationParameter(name = "filteredge6", category = "DevTypes")
    private double filteredge6;
    @ConfigurationParameter(name = "pdtype", category = "DevTypes")
    private String pdtype;
    @ConfigurationParameter(name = "biastype", category = "DevTypes")
    private String biastype;
    @ConfigurationParameter(name = "srctype", category = "DevTypes")
    private String srctype;
    @ConfigurationParameter(name = "monotype", category = "DevTypes")
    private String monotype;
    private String[] filter_names;                 // names of the filters
    private double[] filter_edges = new double[6]; // wl edge at which filter should be selected


    public TSSetDevTypes(
                         String filter1, 
                         String filter2, 
                         String filter3, 
                         String filter4, 
                         String filter5, 
                         String filter6, 
                         double filteredge1,
                         double filteredge2,
                         double filteredge3,
                         double filteredge4,
                         double filteredge5,
                         double filteredge6,
                         String pdtype, String biastype, String srctype, String monotype) {
            this.filter1 = filter1;
            this.filter2 = filter2;
            this.filter3 = filter3;
            this.filter4 = filter4;
            this.filter5 = filter5;
            this.filter6 = filter6;
            this.filteredge1 = filteredge1;
            this.filteredge2 = filteredge2;
            this.filteredge3 = filteredge3;
            this.filteredge4 = filteredge4;
            this.filteredge5 = filteredge5;
            this.filteredge6 = filteredge6;
            this.biastype = biastype;
            this.pdtype   = pdtype;
            this.srctype  = srctype;
            this.monotype = monotype;
    }

    @ConfigurationParameterChanger(propertyName = "biastype")
    public void setBiasType(String biastype) {
        this.biastype = biastype;
    }

}
