/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class RaisedAlertBookkeeper
extends RaisedAlertSummary {
    private static final long serialVersionUID = -96497256576826248L;

    public synchronized RaisedAlertHistory raiseAlert(Alert alert, AlertState severity, long timestamp, String cause) {
        return this.raiseAlert(alert, severity, CCSTimeStamp.currentTimeFromMillis(timestamp), cause, 1);
    }

    public synchronized RaisedAlertHistory raiseAlert(Alert alert, AlertState severity, CCSTimeStamp ccsTimeStamp, String cause) {
        return this.raiseAlert(alert, severity, ccsTimeStamp, cause, 1);
    }

    public synchronized RaisedAlertHistory raiseAlert(Alert alert, AlertState severity, long timestamp, String cause, int count) {
        RaisedAlertHistory raisedAlert = this.getRaisedAlert(alert);
        raisedAlert.addAlertInstance(severity, alert, timestamp, cause, count);
        return raisedAlert;
    }

    public synchronized RaisedAlertHistory raiseAlert(Alert alert, AlertState severity, CCSTimeStamp ccsTimeStamp, String cause, int count) {
        RaisedAlertHistory raisedAlert = this.getRaisedAlert(alert);
        raisedAlert.addAlertInstance(severity, alert, ccsTimeStamp, cause, count);
        return raisedAlert;
    }

    public synchronized void clearAlert(String alertId) {
        RaisedAlertHistory alertToClear = null;
        for (RaisedAlertHistory alert : this.raisedAlerts) {
            if (!alert.getLatestAlert().getAlertId().equals(alertId)) continue;
            alertToClear = alert;
            break;
        }
        if (alertToClear != null) {
            this.raisedAlerts.remove(alertToClear);
        }
    }

    private RaisedAlertHistory getRaisedAlert(Alert alert) {
        for (RaisedAlertHistory raisedAlert : this.raisedAlerts) {
            if (!raisedAlert.getLatestAlert().equals((Object)alert)) continue;
            return raisedAlert;
        }
        RaisedAlertHistory raisedAlert = new RaisedAlertHistory();
        this.raisedAlerts.add(raisedAlert);
        return raisedAlert;
    }
}

