/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.microion;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;

public class MicroIon
extends Ascii {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private String terminator = "\n";
    private String saddr = "2";

    public void open(String serialname, int port, int addr) throws DriverException {
        this.open(2, serialname, port);
        Integer iaddr = addr;
        this.saddr = iaddr.toString();
        this.init();
    }

    public void openftdi(String serialname, int port, int addr) throws DriverException {
        System.out.println("opening connection to the MicroIon Vacuum Gauge");
        this.open(1, serialname, port);
        Integer iaddr = addr;
        this.saddr = iaddr.toString();
        this.init();
    }

    public void init() throws DriverException {
        System.out.println("MicroIon Device response to 8,1,N setting is:" + this.readMicroIon("#0" + this.saddr + "SPN"));
        System.out.println("MicroIon Device response to address setting is:" + this.readMicroIon("#0" + this.saddr + "SA00"));
    }

    public onOff getState() throws DriverException {
        String srm = this.readMicroIon("#0" + this.saddr + "IGS");
        String[] response = srm.split(" ");
        return response[3] == "ON" ? onOff.ON : onOff.OFF;
    }

    public void setState(int state) throws DriverException {
        this.writeMicroIon("#0" + this.saddr + "IG" + state);
    }

    public double getPressure() throws DriverException {
        String srm = this.readMicroIon("#0" + this.saddr + "RD");
        String[] response = srm.split(" ");
        return Double.valueOf(response[1]);
    }

    public synchronized void writeMicroIon(String command) throws DriverException {
        this.write(command + this.terminator);
    }

    public synchronized String readMicroIon() throws DriverException {
        return this.read();
    }

    public synchronized String readMicroIon(String command) throws DriverException {
        this.writeMicroIon(command);
        return this.readMicroIon();
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

