/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.freehep.application.Application;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.ExtensionClassLoader;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginDir;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.PluginMap;
import org.freehep.application.studio.Studio;
import org.freehep.application.studio.pluginmanager.PluginDownload;
import org.freehep.application.studio.pluginmanager.PluginListHandler;
import org.freehep.application.studio.pluginmanager.PluginManagerDialog;
import org.freehep.util.VersionComparator;
import org.xml.sax.SAXException;

public class PluginManager
extends Plugin
implements Runnable {
    private boolean checkForPluginsAtStart;
    private URL checkURL;
    private boolean removeJavaIncompatible;
    private boolean removeAppIncompatible;
    protected PluginListHandler pluginListHandler;
    protected Thread pluginListReaderThread;
    protected volatile boolean pluginListIsReady;
    protected List<PluginInfo> availablePlugins;
    protected ArrayList<PluginInfo> installablePlugins;
    protected ArrayList<PluginInfo> updatablePlugins;
    protected Map<PluginInfo, PluginInfo> updateMap;
    protected PluginMap masterMap;
    protected boolean dialogVisible = false;
    private EventListenerList listeners = new EventListenerList();
    static final Logger logger = Logger.getLogger(PluginManager.class.getName());

    @Override
    protected void init() throws SAXException, IOException {
        Studio app = this.getApplication();
        Properties user = app.getUserProperties();
        String pluginURL = user.getProperty("PluginManager.URL");
        this.checkURL = pluginURL == null ? null : new URL(pluginURL);
        this.checkForPluginsAtStart = PropertyUtilities.getBoolean(user, "checkForPluginsAtStart", false);
        this.pluginListIsReady = false;
    }

    @Override
    protected void applicationVisible() {
        this.masterMap = this.getApplication().getPluginMap();
        if (this.checkForPluginsAtStart && this.checkURL != null) {
            this.startPluginListDownload();
        }
    }

    protected boolean isPluginListIsReady() {
        return this.pluginListIsReady;
    }

    protected PluginMap getPluginMap() {
        return this.masterMap;
    }

    protected List<PluginInfo> getAvailablePlugins() {
        return this.pluginListIsReady ? this.availablePlugins : null;
    }

    Map<PluginInfo, PluginInfo> getUpdateMap() {
        if (!this.pluginListIsReady) {
            return null;
        }
        if (this.updateMap == null) {
            this.processAvailablePlugins();
        }
        return this.updateMap;
    }

    protected List<PluginInfo> getPlugins() {
        return new ArrayList<PluginInfo>(this.masterMap.getActivePlugins().values());
    }

    List<PluginInfo> getInstallablePlugins() {
        if (!this.pluginListIsReady) {
            return null;
        }
        if (this.installablePlugins == null) {
            this.processAvailablePlugins();
        }
        return this.installablePlugins;
    }

    List<PluginInfo> getUpdatablePlugins() {
        if (!this.pluginListIsReady) {
            return null;
        }
        if (this.updatablePlugins == null) {
            this.processAvailablePlugins();
        }
        return this.updatablePlugins;
    }

    public boolean isCheckAtStart() {
        return this.checkForPluginsAtStart;
    }

    public URL getCheckURL() {
        return this.checkURL;
    }

    public boolean isRemoveJavaIncompatible() {
        return this.removeJavaIncompatible;
    }

    public boolean isRemoveAppIncompatible() {
        return this.removeAppIncompatible;
    }

    public void setCheckAtStart(boolean checkAtStart) {
        this.checkForPluginsAtStart = checkAtStart;
        PropertyUtilities.setBoolean(this.getApplication().getUserProperties(), "checkForPluginsAtStart", checkAtStart);
    }

    public void setCheckURL(URL checkURL) {
        this.checkURL = checkURL;
        this.getApplication().getUserProperties().setProperty("PluginManager.URL", checkURL.toExternalForm());
    }

    public void setRemoveJavaIncompatible(boolean removeJavaIncompatible) {
        this.removeJavaIncompatible = removeJavaIncompatible;
    }

    public void setRemoveAppIncompatible(boolean removeAppIncompatible) {
        this.removeAppIncompatible = removeAppIncompatible;
    }

    public void setPluginListHandler(PluginListHandler pluginListHandler) {
        this.pluginListHandler = pluginListHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPluginManager() {
        if (!this.pluginListIsReady && this.pluginListReaderThread == null) {
            this.startPluginListDownload();
        }
        JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.getApplication());
        PluginManagerDialog dlg = new PluginManagerDialog(frame, this);
        dlg.setModal(true);
        dlg.setTitle("Plugin Manager");
        dlg.pack();
        dlg.setLocationRelativeTo(this.getApplication());
        try {
            this.dialogVisible = true;
            dlg.setVisible(true);
        }
        finally {
            this.dialogVisible = false;
            this.cleanup();
        }
    }

    public void offerUpdate() {
        Box message = Box.createVerticalBox();
        JLabel label = new JLabel("Updated plugins available");
        label.setAlignmentX(1.0f);
        message.add(label);
        JCheckBox ask = new JCheckBox("Don't show me this again");
        message.add(ask);
        Object[] options = new String[]{"Install now", "Plugin Manager...", "Cancel"};
        int rc = JOptionPane.showOptionDialog(this.getApplication(), message, "Updates available", 1, 1, null, options, options[0]);
        if (ask.isSelected()) {
            this.getApplication().getUserProperties().setProperty("notifyPluginUpdates", "false");
        }
        if (rc == 0) {
            this.updateInstalledPlugins(this.getApplication());
        } else if (rc == 1) {
            this.showPluginManager();
        }
    }

    protected void startPluginListDownload() {
        this.pluginListReaderThread = new Thread(this);
        this.pluginListReaderThread.setDaemon(true);
        this.pluginListReaderThread.setPriority(5);
        this.pluginListReaderThread.start();
    }

    @Override
    public void run() {
        PluginListHandler handler = this.pluginListHandler == null ? new PluginListHandler() : this.pluginListHandler;
        this.availablePlugins = handler.getAvailablePlugins(this.checkURL, logger, this.getApplication());
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PluginManager.this.processAvailablePlugins();
                boolean notify = PropertyUtilities.getBoolean(PluginManager.this.getApplication().getUserProperties(), "notifyPluginUpdates", true);
                if (!PluginManager.this.updatablePlugins.isEmpty() && !PluginManager.this.dialogVisible && notify) {
                    PluginManager.this.offerUpdate();
                }
                PluginManager.this.cleanup();
                PluginManager.this.pluginListReaderThread = null;
                PluginManager.this.pluginListIsReady = true;
                PluginManager.this.fireStateChanged();
            }
        };
        SwingUtilities.invokeLater(r);
    }

    protected void processAvailablePlugins() {
        this.installablePlugins = new ArrayList(this.availablePlugins.size());
        this.updatablePlugins = new ArrayList(this.availablePlugins.size());
        this.updateMap = new HashMap<PluginInfo, PluginInfo>();
        Map<String, PluginInfo> activePlugins = this.masterMap.getActivePlugins();
        for (PluginInfo info : this.availablePlugins) {
            PluginInfo old = activePlugins.get(info.getName());
            if (old != null) {
                this.updateMap.put(old, info);
                if (VersionComparator.compareVersion((String)info.getVersion(), (String)old.getVersion()) <= 0) continue;
                this.updatablePlugins.add(old);
                continue;
            }
            this.installablePlugins.add(info);
        }
    }

    public boolean updateInstalledPlugins(Component parent) {
        return this.install(parent, this.updatablePlugins);
    }

    public boolean install(Component parent, Collection<PluginInfo> plugins) {
        ArrayList<PluginInfo> verified = new ArrayList<PluginInfo>(plugins.size());
        try {
            for (PluginDir dir : PluginDir.sgu()) {
                HashMap<String, PluginInfo> required = new HashMap<String, PluginInfo>();
                HashSet<String> already = new HashSet<String>();
                for (PluginInfo plugin : plugins) {
                    if (plugin.getDirectory() != dir) continue;
                    this.addNameWithDependencies(dir, plugin.getName(), required, already);
                }
                HashMap<String, PluginInfo> after = new HashMap<String, PluginInfo>(this.masterMap.getPlugins(dir));
                after.putAll(required);
                HashMap<String, String[]> n2range = new HashMap<String, String[]>();
                for (PluginInfo plugin : after.values()) {
                    for (String name : plugin.getRequiredPluginNames()) {
                        String min = plugin.getRequiredPluginMinVersion(name);
                        String max = plugin.getRequiredPluginMaxVersion(name);
                        if (min == null && max == null) continue;
                        String[] range = (String[])n2range.get(name);
                        if (range == null) {
                            range = new String[2];
                            n2range.put(name, range);
                        }
                        if (min != null && (range[0] == null || VersionComparator.compareVersion((String)min, (String)range[0]) > 0)) {
                            range[0] = min;
                        }
                        if (max == null || range[1] != null && VersionComparator.compareVersion((String)max, (String)range[1]) >= 0) continue;
                        range[1] = max;
                    }
                }
                for (PluginInfo plugin : after.values()) {
                    String version = plugin.getVersion();
                    String[] range = (String[])n2range.get(plugin.getName());
                    if (range == null) continue;
                    if (range[0] != null && VersionComparator.compareVersion((String)version, (String)range[0]) < 0) {
                        throw new IllegalStateException(plugin.getName());
                    }
                    if (range[1] == null || VersionComparator.compareVersion((String)version, (String)range[1]) <= 0) continue;
                    throw new IllegalStateException(plugin.getName());
                }
                verified.addAll(required.values());
            }
        }
        catch (IllegalStateException x) {
            String message = "Installation cancelled: missing or incompatible dependencies";
            if (parent == null) {
                throw new IllegalArgumentException(message);
            }
            JOptionPane.showMessageDialog(parent, message, "Installation error", 0);
            return false;
        }
        PluginMap update = this.masterMap.add(verified);
        Map<File, String> downloads = update.getDownloads();
        PluginDownload download = new PluginDownload(downloads);
        Thread t = new Thread(download);
        t.start();
        JOptionPane.showMessageDialog(parent, download, "Downloading...", -1);
        Throwable status = download.getStatus();
        if (status != null) {
            download.cleanUp();
            String message = "Download failed: " + status;
            if (parent == null) {
                throw new IllegalArgumentException(message);
            }
            JOptionPane.showMessageDialog(parent, message, "Download error", 0);
            return false;
        }
        download.commit();
        boolean restart = this.masterMap.commit(update);
        if (!restart) {
            ExtensionClassLoader loader = this.getApplication().getExtensionLoader();
            for (URL url : update.getExtensionClasspath()) {
                loader.addURL(url);
            }
            boolean failure = this.getApplication().loadPlugins(update.getPlugins(), loader);
            if (failure) {
                String message = "At least one plugin failed to load, see Plugin Manager for details";
                if (parent == null) {
                    throw new IllegalArgumentException(message);
                }
                Application.error(parent, message);
            }
        }
        this.installablePlugins.removeAll(plugins);
        this.fireStateChanged();
        return restart;
    }

    public boolean uninstall(Component parent, Collection<PluginInfo> plugins) {
        ArrayList<PluginInfo> verified = new ArrayList<PluginInfo>(plugins.size());
        for (PluginDir dir : PluginDir.sgu()) {
            HashSet<PluginInfo> verDir = new HashSet<PluginInfo>();
            for (PluginInfo plugin : plugins) {
                PluginInfo installed;
                if (plugin.getDirectory() != dir || (installed = this.masterMap.getPlugin(plugin.getName(), dir)) == null) continue;
                verDir.add(installed);
                verDir.addAll(this.masterMap.getDependentPlugins(installed));
            }
            verified.addAll(verDir);
        }
        this.masterMap.remove(verified);
        boolean restart = false;
        for (PluginInfo plugin : verified) {
            try {
                PluginInfo loadedPlugin = this.getApplication().getPlugin(plugin.getName());
                if (loadedPlugin != null && loadedPlugin.getDirectory() == plugin.getDirectory()) {
                    this.getApplication().stopPlugin(plugin);
                    restart = true;
                }
            }
            catch (IllegalArgumentException x) {
                restart = true;
            }
            this.updatablePlugins.remove(plugin);
        }
        this.fireStateChanged();
        return restart;
    }

    public boolean update(Component parent, Collection<PluginInfo> plugins) {
        HashMap<String, PluginInfo> available = new HashMap<String, PluginInfo>();
        for (PluginInfo plugin : this.availablePlugins) {
            available.put(plugin.getName(), plugin);
        }
        Map<String, PluginInfo> active = this.masterMap.getActivePlugins();
        ArrayList<PluginInfo> updates = new ArrayList<PluginInfo>(plugins.size());
        for (PluginInfo plugin : plugins) {
            PluginInfo availablePlugin = (PluginInfo)available.get(plugin.getName());
            PluginInfo installedPlugin = active.get(plugin.getName());
            if (availablePlugin == null || installedPlugin == null || VersionComparator.compareVersion((String)availablePlugin.getVersion(), (String)installedPlugin.getVersion()) <= 0) continue;
            PluginInfo update = new PluginInfo(availablePlugin);
            update.setDirectory(installedPlugin.getDirectory());
            updates.add(update);
        }
        return this.install(parent, updates);
    }

    protected void cleanup() {
        this.installablePlugins = null;
        this.updatablePlugins = null;
        this.updateMap = null;
    }

    private void addNameWithDependencies(PluginDir dir, String name, Map<String, PluginInfo> required, Set<String> already) {
        if (required.containsKey(name) || already.contains(name)) {
            return;
        }
        PluginInfo installed = this.masterMap.getPlugin(name, dir);
        PluginInfo available = null;
        for (PluginInfo p : this.availablePlugins) {
            if (!p.getName().equals(name)) continue;
            available = new PluginInfo(p);
            available.setDirectory(dir);
            break;
        }
        PluginInfo effective = null;
        if (installed == null) {
            if (available != null) {
                required.put(name, available);
                effective = available;
            }
        } else if (available != null && VersionComparator.compareVersion((String)available.getVersion(), (String)installed.getVersion()) > 0) {
            required.put(name, available);
            effective = available;
        } else {
            effective = installed;
            already.add(name);
        }
        if (effective == null) {
            throw new IllegalStateException(name);
        }
        for (String req : effective.getRequiredPluginNames()) {
            this.addNameWithDependencies(dir, req, required, already);
        }
    }

    void addChangeListener(ChangeListener l) {
        this.listeners.add(ChangeListener.class, l);
    }

    void removeChangeListener(ChangeListener l) {
        this.listeners.remove(ChangeListener.class, l);
    }

    private void fireStateChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
            listener.stateChanged(event);
        }
    }
}

