/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.Objects;
import java.util.Properties;

public final class AgentInfo
implements Serializable {
    private static final long serialVersionUID = 716901596341446997L;
    private final String name;
    private final AgentType type;
    private final Properties agentProps;
    public static final String AGENT_NAME_PROP = "agentName";
    public static final String AGENT_TYPE_PROP = "agentType";
    public static final String AGENT_JXM_PORT_PROP = "org.lsst.ccs.agent.jmxport";

    public AgentInfo(String name, AgentType type) {
        this(name, type, new Properties());
    }

    public AgentInfo(String name, AgentType type, Properties agentProps) {
        this.agentProps = agentProps;
        this.name = name;
        this.type = type;
        this.agentProps.setProperty(AGENT_NAME_PROP, name);
        this.agentProps.setProperty(AGENT_TYPE_PROP, type.name());
    }

    public String getName() {
        return this.name;
    }

    public AgentType getType() {
        return this.type;
    }

    public String getAgentProperty(String property) {
        return this.getAgentProperty(property, null);
    }

    public String getAgentProperty(String property, String def) {
        return this.agentProps != null ? this.agentProps.getProperty(property, def) : def;
    }

    public boolean hasAgentProperty(String property) {
        return this.getAgentProperty(property) != null;
    }

    public boolean isAgentWorkerOrService() {
        return this.type.compareTo(AgentType.WORKER) >= 0;
    }

    public String toString() {
        return this.name + ":" + (Object)((Object)this.type);
    }

    public boolean equals(Object a) {
        if (!(a instanceof AgentInfo)) {
            return false;
        }
        AgentInfo agent = (AgentInfo)a;
        return this.getName().equals(agent.getName()) && this.getType().equals((Object)agent.getType());
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.name);
        hash = 89 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    public static enum AgentType {
        LISTENER("Listener"),
        CONSOLE("Console"),
        WORKER("Worker"),
        SERVICE("Service"),
        MCM("MCM"),
        OCS_BRIDGE("OCS bridge"),
        LOCK_MANAGER("Lock manager");

        private final String displayName;

        private AgentType(String displayName) {
            this.displayName = displayName;
        }

        public String displayName() {
            return this.displayName;
        }
    }
}

