package org.lsst.ccs.subsystem.teststand.limits;

import java.util.List;

/**
 * An interface to be implemented by all transition algorithms
 * @author tonyj
 */
public interface TransitionAlgorithm {

    void init(List<Double> parameters, LimitAlgorithm limitsAlgorithm, double initialValue, LimitsInterface limits, long startTime);

    boolean isAtTarget(double value, long time);

    void adjustLimits(double currentValue, long time);
    
    void completeTransition(long time);
    
    LimitsInterface getLimits();
}