/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.TreeWalkerUtils;

public interface SignalHandler {
    default public TreeWalkerDiag signal(Signal sig) {
        return TreeWalkerDiag.GO;
    }

    @Command(description="will propagate signal to Module and its children ", type=Command.CommandType.SIGNAL)
    default public void sendSignal(String signalString) {
        this.sendSignalWithTimeLimit(signalString, -1L);
    }

    @Command(description="will propagate signal to Module and its children with  an expected maximum delay", type=Command.CommandType.SIGNAL)
    default public void sendSignalWithTimeLimit(String signalString, long expectedMaxDelay) {
        SignalLevel signalLevel = SignalLevel.valueOf(signalString);
        Signal signal = new Signal(signalLevel, expectedMaxDelay);
        ComponentLookup lookup = Subsystem.getSubsystemForObject(this).getComponentLookup();
        TreeWalkerUtils.treeWalk(lookup, lookup.getComponentNodeForObject((Object)this), SignalHandler.class, sh -> sh.signal(signal), null);
    }
}

