/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.cornerstone;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverLockedException;
import org.lsst.ccs.drivers.commons.MonochromatorDriver;
import org.lsst.ccs.utilities.logging.Logger;

public class C260
extends Ascii
implements MonochromatorDriver {
    private ArrayList<storedError> errorCol = new ArrayList();
    private final int maxErrorCapacity = 5;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private final int defaultBaud = 9600;
    private String terminator = "\n";
    private double timeout = 60.0;
    private static Logger log = Logger.getLogger((String)"lsst.drivers.cornerstone");
    private boolean handshakeOn = false;
    private boolean globalWaitForLock = false;
    private static final ReentrantLock C260Lock = new ReentrantLock();

    public C260() throws DriverException {
    }

    public C260(int waitForLock) throws DriverException {
        this.globalWaitForLock = waitForLock == 1;
    }

    public C260(String serialName) throws DriverException {
        this();
        this.initBeforeOpen();
        this.open(serialName, 9600);
        int status = this.getStatus();
        if (status != 0) {
            int err = this.readError();
            this.addError("UNKNOWN", err);
            throw new DriverException("Cornerstone ErrorCode: " + err);
        }
        this.initAfterOpen();
    }

    public C260(String serialName, int baud) throws DriverException {
        this();
        this.initBeforeOpen();
        this.open(serialName, baud);
        int status = this.getStatus();
        if (status != 0) {
            int err = this.readError();
            this.addError("UNKNOWN", err);
            throw new DriverException("Cornerstone ErrorCode: " + err);
        }
        this.initAfterOpen();
    }

    @Command(name="open", description="create serial connection", type=Command.CommandType.ACTION)
    public final void open(String serialname, int port) throws DriverException {
        this.initBeforeOpen();
        this.open(2, serialname, port);
        int status = this.getStatus();
        if (status != 0) {
            int err = this.readError();
            this.addError("UNKNOWN", err);
            throw new DriverException("Cornerstone ErrorCode: " + err);
        }
        this.initAfterOpen();
    }

    @Command(name="openftdi", description="create connection via FTDI", type=Command.CommandType.ACTION)
    public void openftdi(String serialname, int baud) throws DriverException {
        System.out.println("opening connection to the monochromator");
        this.initBeforeOpen();
        try {
            System.out.println("trying to open FTDI connection to C260");
            this.open(1, serialname, baud);
        }
        catch (Exception g) {
            System.out.println("Unable to open connection to C260 monochromator!");
        }
        System.out.println("proceeding to post init C260 handshake step");
        int status = this.getStatus();
        if (status != 0) {
            int err = this.readError();
            this.addError("UNKNOWN", err);
            throw new DriverException("Cornerstone ErrorCode: " + err);
        }
        this.initAfterOpen();
        System.out.println("exiting C260 openftdi");
    }

    @Command(name="open", description="create serial connection", type=Command.CommandType.ACTION)
    public void open(String serialname) throws DriverException {
        this.initBeforeOpen();
        this.open(serialname, 9600);
        this.initAfterOpen();
    }

    private final void initBeforeOpen() throws DriverException {
        this.setTerminator(this.terminator);
        this.setTimeout(this.timeout);
    }

    private void initAfterOpen() throws DriverException {
        System.out.println("entered initAfterOpen");
        this.setHandshakeOff();
        System.out.println("exiting initAfterOpen");
    }

    private boolean checkHandshakeErr() throws DriverException {
        boolean noErr = false;
        boolean errCond = true;
        if (this.handshakeOn) {
            String status = this.readMono();
            if (Integer.parseInt(status) != 0) {
                return errCond;
            }
            return noErr;
        }
        return noErr;
    }

    @Command(name="abort", description="Stop motion immediately", type=Command.CommandType.ACTION)
    public void abort() throws DriverException {
        try {
            C260Lock.lock();
            this.writeMono("abort");
            this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError("ABORT", err);
                throw new DriverException("Abort ErrorCode: " + err);
            }
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="getBandpass", description="Query bandpass", type=Command.CommandType.QUERY)
    public double getBandpass() throws DriverException {
        return this.getBandpass(this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getBandpass", description="Query bandpass", type=Command.CommandType.QUERY)
    public double getBandpass(@Argument(name="waitIfLocked", description="waiting for lock") boolean waitIfLocked) throws DriverException {
        String resp = "";
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            this.writeMono("bandpass?");
            this.readMono();
            resp = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError("BANDPASS?", err);
                throw new DriverException("Cornerstone C260 bandpass Command ErrorCode: " + err);
            }
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
        return Double.parseDouble(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="setBandpass", description="set bandpass", type=Command.CommandType.ACTION)
    public void setBandpass(double bandpass) throws DriverException {
        try {
            C260Lock.lock();
            DecimalFormat df = new DecimalFormat("###.##");
            this.writeMono("bandpass " + df.format(bandpass));
            this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError("BANDPASS" + df.format(bandpass), err);
                throw new DriverException("Cornerstone C260 bandpass Command ErrorCode: " + err);
            }
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="setCalibrate", description="defines current position as wavelength in parameter", type=Command.CommandType.ACTION)
    public void setCalibrate(double val) throws DriverException {
        try {
            C260Lock.lock();
            DecimalFormat df = new DecimalFormat("###.###");
            String str = "calibrate " + df.format(val);
            this.writeMono(str);
            this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError(str, err);
                throw new DriverException("Cornerstone C260 calibrate Command ErrorCode: " + err);
            }
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    private int readError() throws DriverException {
        this.writeMono("error?");
        this.readMono();
        String err = this.readMono();
        if (this.checkHandshakeErr()) {
            throw new DriverException("Cornerstone C260 error Command Error");
        }
        return Integer.parseInt(err);
    }

    @Command(name="getFullError", description="returns last known error code", type=Command.CommandType.QUERY)
    public int getFullError(storedError err) throws DriverException {
        if (this.errorCol.size() > 0) {
            storedError curErr = this.getLastError();
            err.setCommand(curErr.getCommand());
            err.setErrorCode(curErr.getErrorCode());
            return err.getErrorCode();
        }
        return -1;
    }

    @Command(name="getError", description="returns last known error code", type=Command.CommandType.QUERY)
    public int getError() throws DriverException {
        storedError err = new storedError();
        return this.getFullError(err);
    }

    @Command(name="clearErrors", description="Clearing Error list", type=Command.CommandType.ACTION)
    public void clearErrors() throws DriverException {
        this.errorCol.clear();
    }

    @Command(name="getNumberofErrors", description="returns number of reported errors", type=Command.CommandType.QUERY)
    public int getNumberOfErrors() throws DriverException {
        return this.errorCol.size();
    }

    @Command(name="queryErrorStatus", description="manually check status and error bytes, only to be used when not in handshaking mode", type=Command.CommandType.QUERY)
    public boolean queryErrorStatus() throws DriverException {
        return this.queryErrorStatus(this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="queryErrorStatus", description="manually check status and error bytes, only to be used when not in handshaking mode", type=Command.CommandType.QUERY)
    public boolean queryErrorStatus(@Argument(name="waitIfLocked", description="flag denoting whether to wait for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            boolean noError = false;
            boolean error = true;
            if (this.getStatus() != 0) {
                int err = this.readError();
                this.addError("UNKNOWN", err);
                boolean bl = error;
                return bl;
            }
            boolean bl = noError;
            return bl;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="getFilter", description="Queries filter?", type=Command.CommandType.QUERY)
    public int getFilter() throws DriverException {
        return this.getFilter(this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getFilter", description="Queries filter?", type=Command.CommandType.QUERY)
    public int getFilter(@Argument(name="waitIfLocked", description="flag denoting that will wait for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            this.writeMono("filter?");
            this.readMono();
            String resp = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError("FILTER?", err);
                throw new DriverException("Cornerstone C260 filter Command ErrorCode: " + err);
            }
            int n = Integer.parseInt(resp);
            return n;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="setFilter", description="set filter [1-6]", type=Command.CommandType.ACTION)
    public void setFilter(int pos) throws DriverException {
        try {
            C260Lock.lock();
            if (pos < 1 || pos > 6) {
                throw new IllegalArgumentException("Filter position request is invalid: " + pos);
            }
            this.writeMono("filter " + Integer.toString(pos));
            this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError("FILTER " + Integer.toString(pos), err);
                throw new DriverException("Cornerstone C260 filter Command ErrorCode: " + err);
            }
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="getFilterLabel", description="get filter [1-6] label", type=Command.CommandType.QUERY)
    public String getFilterLabel(@Argument(name="filter", description="filter number 1-6") int filter) throws DriverException {
        return this.getFilterLabel(filter, this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getFilterLabel", description="get filter [1-6] label", type=Command.CommandType.QUERY)
    public String getFilterLabel(@Argument(name="filter", description="filter number 1-6") int filter, @Argument(name="waitIfLocked", description="flag denoting waiting for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            if (filter < 1 || filter > 6) {
                throw new IllegalArgumentException("filter setting invalid: " + filter);
            }
            String str = "filter" + Integer.toString(filter) + "label?";
            this.writeMono(str);
            this.readMono();
            String resp = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError(str, err);
                throw new DriverException("Cornerstone C260 filter label Command ErrorCode: " + err);
            }
            String string = resp;
            return string;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="setFilterLabel", description="set filter [1-6] label", type=Command.CommandType.ACTION)
    public void setFilterLabel(int filter, String label) throws DriverException {
        if (filter < 1 || filter > 6) {
            throw new IllegalArgumentException("Invalid filter setting: " + filter);
        }
        if (label.length() > 8) {
            throw new IllegalArgumentException("Invalid filter label, over 8 char");
        }
        String str = "filter" + Integer.toString(filter) + "label " + label;
        this.writeMono(str);
        this.readMono();
        if (this.checkHandshakeErr()) {
            int err = this.readError();
            this.addError(str, err);
            throw new DriverException("Cornerstone C260 filter label Command ErrorCode: " + err);
        }
    }

    @Command(name="getGrating", description="query current grating", type=Command.CommandType.QUERY)
    public String getGrating() throws DriverException {
        return this.getGrating(this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getGrating", description="query current grating", type=Command.CommandType.QUERY)
    public String getGrating(@Argument(name="waitIfLocked", description="flag denoting waiting for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            this.writeMono("grat?");
            this.readMono();
            String resp = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError("GRAT?", err);
                throw new DriverException("Cornerstone C260 grating Command ErrorCode: " + err);
            }
            String string = resp;
            return string;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="setGrating", description="Set the Grating", type=Command.CommandType.ACTION)
    public void setGrating(int param) throws DriverException {
        try {
            C260Lock.lock();
            if (param < 1 || param > 3) {
                throw new IllegalArgumentException("Invalid grating setting: " + param);
            }
            this.writeMono("grat " + param);
            this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError("GRAT " + param, err);
                throw new DriverException("Cornerstone C260 grating Command ErrorCode: " + err);
            }
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="getGratingLabel", description="Query Grating [1-2] Label", type=Command.CommandType.QUERY)
    public String getGratingLabel(@Argument(name="grat", description="grating number 1-2") int grat) throws DriverException {
        return this.getGratingLabel(grat, this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getGratingLabel", description="Query Grating [1-2] Label", type=Command.CommandType.QUERY)
    public String getGratingLabel(@Argument(name="grat", description="grating number 1-2") int grat, @Argument(name="waitIfLocked", description="flag denoting wating for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            if (grat != 1 && grat != 2) {
                throw new IllegalArgumentException("grating setting invalid: " + grat);
            }
            String str = "grat" + Integer.toString(grat) + "label?";
            this.writeMono(str);
            this.readMono();
            String resp = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError(str, err);
                throw new DriverException("Cornerstone C260 grating label Command ErrorCode: " + err);
            }
            String string = resp;
            return string;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="setGratingLabel", description="Set Grating [1-2] Label", type=Command.CommandType.ACTION)
    public void setGratingLabel(int param, String label) throws DriverException {
        if (param != 1 && param != 2) {
            throw new IllegalArgumentException("Invalid grating setting: " + param);
        }
        if (label.length() > 8) {
            throw new IllegalArgumentException("Invalid grating label, over 8 char");
        }
        String str = "grat" + Integer.toString(param) + "label " + label;
        this.writeMono(str);
        this.readMono();
        if (this.checkHandshakeErr()) {
            int err = this.readError();
            this.addError(str, err);
            throw new DriverException("Cornerstone C260 grating label Command ErrorCode: " + err);
        }
    }

    @Command(name="getGratingLines", description="Get Grating [1-2] Lines", type=Command.CommandType.QUERY)
    public int getGratingLines(@Argument(name="grat", description="grating number 1-2") int grat) throws DriverException {
        return this.getGratingLines(grat, this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getGratingLines", description="Get Grating [1-2] Lines", type=Command.CommandType.QUERY)
    public int getGratingLines(@Argument(name="grat", description="grating number 1-2") int grat, @Argument(name="waitIfLocked", description="flag denoting waiting for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            if (grat != 1 && grat != 2) {
                throw new IllegalArgumentException("grating setting invalid: " + grat);
            }
            String str = "grat" + Integer.toString(grat) + "lines?";
            this.writeMono(str);
            this.readMono();
            String resp = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError(str, err);
                throw new DriverException("Cornerstone C260 grating lines Command ErrorCode: " + err);
            }
            int n = Integer.parseInt(resp);
            return n;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="setGratingLines", description="set Grating [1-2] Lines", type=Command.CommandType.ACTION)
    public void setGratingLines(@Argument(name="grat", description="grating 1-2") int grat, @Argument(name="param", description="") int param) throws DriverException {
        if (grat != 1 && grat != 2) {
            throw new IllegalArgumentException("Invalid grating setting: " + grat);
        }
        if (param < 0 || param > 9999) {
            throw new IllegalArgumentException("Invalid grating setting: " + grat);
        }
        String str = "grat" + Integer.toString(grat) + "lines " + Integer.toString(param);
        this.writeMono(str);
        this.readMono();
        if (this.checkHandshakeErr()) {
            int err = this.readError();
            this.addError(str, err);
            throw new DriverException("Cornerstone C260 grating lines Command ErrorCode: " + err);
        }
    }

    @Command(name="getGratingFactor", description="get Grating [1-2] Factor", type=Command.CommandType.QUERY)
    public double getGratingFactor(@Argument(name="grat", description="grating number 1-2") int grat) throws DriverException {
        return this.getGratingFactor(grat, this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getGratingFactor", description="get Grating [1-2] Factor", type=Command.CommandType.QUERY)
    public double getGratingFactor(@Argument(name="grat", description="grating number 1-2") int grat, @Argument(name="waitIfLocked", description="flag denoting waiting for locks") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            if (grat != 1 && grat != 2) {
                throw new IllegalArgumentException("grating setting invalid: " + grat);
            }
            String str = "grat" + Integer.toString(grat) + "factor?";
            this.writeMono(str);
            this.readMono();
            String resp = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError(str, err);
                throw new DriverException("Cornerstone C260 grating factor Command ErrorCode: " + err);
            }
            double d = Double.parseDouble(resp);
            return d;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="setGratingFactor", description="set Grating [1-2] Factor", type=Command.CommandType.ACTION)
    public void setGratingFactor(@Argument(name="grat", description="grating 1-2") int grat, @Argument(name="param", description="") double param) throws DriverException {
        if (grat != 1 && grat != 2) {
            throw new IllegalArgumentException("Invalid grating setting: " + grat);
        }
        DecimalFormat df = new DecimalFormat("###.###");
        String str = "grat" + Integer.toString(grat) + "factor " + df.format(param);
        this.writeMono(str);
        this.readMono();
        if (this.checkHandshakeErr()) {
            int err = this.readError();
            this.addError(str, err);
            throw new DriverException("Cornerstone C260 grating factor Command ErrorCode: " + err);
        }
    }

    @Command(name="getGratingOffset", description="get Grating [1-2] Offset", type=Command.CommandType.QUERY)
    public double getGratingOffset(@Argument(name="grat", description="grating number 1-2") int grat) throws DriverException {
        return this.getGratingOffset(grat, this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getGratingOffset", description="get Grating [1-2] Offset", type=Command.CommandType.QUERY)
    public double getGratingOffset(@Argument(name="grat", description="grating 1-2") int grat, @Argument(name="waitIfLocked", description="flad denoting waiting for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            if (grat != 1 && grat != 2) {
                throw new IllegalArgumentException("grating setting invalid: " + grat);
            }
            String str = "grat" + Integer.toString(grat) + "offset?";
            this.writeMono(str);
            this.readMono();
            String resp = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError(str, err);
                throw new DriverException("Cornerstone C260 grating offset Command ErrorCode: " + err);
            }
            double d = Double.parseDouble(resp);
            return d;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="setGratingOffset", description="set Grating [1-2] Offset", type=Command.CommandType.ACTION)
    public void setGratingOffset(@Argument(name="grat", description="grating 1-2") int grat, @Argument(name="param", description="") double param) throws DriverException {
        if (grat != 1 && grat != 2) {
            throw new IllegalArgumentException("Invalid grating setting: " + grat);
        }
        DecimalFormat df = new DecimalFormat("###.###");
        String str = "grat" + Integer.toString(grat) + "offset " + df.format(param);
        this.writeMono(str);
        this.readMono();
        if (this.checkHandshakeErr()) {
            int err = this.readError();
            this.addError(str, err);
            throw new DriverException("Cornerstone C260 grating offset Command ErrorCode: " + err);
        }
    }

    @Command(name="getHandshake", description="Query HANDSHAKE?", type=Command.CommandType.QUERY)
    public boolean getHandshake() throws DriverException {
        return this.getHandshake(this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getHandshake", description="Query HANDSHAKE?", type=Command.CommandType.QUERY)
    public boolean getHandshake(@Argument(name="waitIfLocked", description="flag denoting waiting for lock") boolean waitIfLocked) throws DriverException {
        try {
            String status;
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            System.out.println("C260 handshaking");
            this.writeMono("handshake?");
            this.readMono();
            System.out.println("checking handshake response");
            String resp = this.readMono();
            int i = Integer.parseInt(resp);
            boolean bl = this.handshakeOn = i != 0;
            if (this.handshakeOn && Integer.parseInt(status = this.readMono()) != 0) {
                int err = this.readError();
                this.addError("HANDSHAKE?", err);
                throw new DriverException("handshake? ErrorCode: " + err);
            }
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
        return this.handshakeOn;
    }

    @Command(name="setHandshake", description="set HANDSHAKE", type=Command.CommandType.ACTION)
    public void setHandshake(@Argument(name="flag", description="true/false") int flag) throws DriverException {
        if (flag != 0 && flag != 1) {
            throw new IllegalArgumentException("Handshake setting must be 0 or 1");
        }
        String str = "handshake " + Integer.toString(flag);
        this.writeMono(str);
        this.readMono();
        this.handshakeOn = flag == 1;
        if (flag == 1 && this.checkHandshakeErr()) {
            int err = this.readError();
            this.addError(str, err);
            throw new DriverException("Setting Handshake ErrorCode: " + err);
        }
    }

    @Command(name="setHandshakeOn", description="set HANDSHAKE ON", type=Command.CommandType.ACTION)
    public void setHandshakeOn() throws DriverException {
        this.setHandshake(1);
    }

    @Command(name="setHandshakeOff", description="set HANDSHAKE OFF", type=Command.CommandType.ACTION)
    public void setHandshakeOff() throws DriverException {
        this.setHandshake(0);
    }

    @Command(name="getInfo", description="return device id", type=Command.CommandType.QUERY)
    public String getInfo() throws DriverException {
        return this.getInfo(this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getInfo", description="return device id", type=Command.CommandType.QUERY)
    public String getInfo(@Argument(name="waitIfLocked", description="flag denoting waiting for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            this.writeMono("info?");
            this.readMono();
            String info = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError("INFO?", err);
                throw new DriverException("Reading Info ErrorCode: " + err);
            }
            String string = info;
            return string;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="setOutport", description="set outport 1 (AXIAL) or 2 (LATERAL)", type=Command.CommandType.ACTION)
    public void setOutport(int num) throws DriverException {
        if (num != 1 && num != 2) {
            throw new IllegalArgumentException("Port request is invalid: " + num);
        }
        String str = "outport " + Integer.toString(num);
        this.writeMono(str);
        this.readMono();
        if (this.checkHandshakeErr()) {
            int err = this.readError();
            this.addError(str, err);
            throw new DriverException("Setting outport ErrorCode: " + err);
        }
    }

    @Command(name="getShutter", description="query shutter for Open or Closed", type=Command.CommandType.QUERY)
    public String getShutter() throws DriverException {
        return this.getShutter(this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getShutter", description="query shutter for Open or Closed", type=Command.CommandType.QUERY)
    public String getShutter(@Argument(name="waitIfLocked", description="flag denoting waiting for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            this.writeMono("shutter?");
            this.readMono();
            String info = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError("SHUTTER?", err);
                throw new DriverException("Checking shutter ErrorCode: " + err);
            }
            String string = info;
            return string;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="openShutter", description="open shutter", type=Command.CommandType.ACTION)
    public void openShutter() throws DriverException {
        this.setShutter("O");
    }

    @Command(name="closeShutter", description="close shutter", type=Command.CommandType.ACTION)
    public void closeShutter() throws DriverException {
        this.setShutter("C");
    }

    @Command(name="isShutterOpen", description="query shutter", type=Command.CommandType.QUERY)
    public boolean isShutterOpen() throws DriverException {
        return this.getShutter().matches("O");
    }

    @Command(name="setShutter", description="open (O) or close (C) shutter", type=Command.CommandType.ACTION)
    public void setShutter(String param) throws DriverException {
        if (!param.equals("C") && !param.equals("O")) {
            throw new IllegalArgumentException("Invalid Shutter setting: " + param);
        }
        String str = "shutter " + param;
        this.writeMono(str);
        this.readMono();
        if (this.checkHandshakeErr()) {
            int err = this.readError();
            this.addError(str, err);
            throw new DriverException("Setting shutter ErrorCode: " + err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="setSlitSize", description="set slit [1-3] size in microns", type=Command.CommandType.ACTION)
    public void setSlitSize(int slit, int microns) throws DriverException {
        try {
            C260Lock.lock();
            if (slit != 1 && slit != 2 && slit != 3) {
                throw new IllegalArgumentException("slit setting invalid: " + slit);
            }
            if (microns < 6 || microns > 2000) {
                throw new IllegalArgumentException("grating micron setting is invalid: " + microns);
            }
            String str = "slit" + Integer.toString(slit) + "microns " + Integer.toString(microns);
            this.writeMono(str);
            this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError(str, err);
                throw new DriverException("Setting slit size ErrorCode: " + err);
            }
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="getSlitSize", description="get slit [1-3] size in microns", type=Command.CommandType.QUERY)
    public int getSlitSize(@Argument(name="slit", description="slit number 1-3") int slit) throws DriverException {
        return this.getSlitSize(slit, this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getSlitSize", description="get slit [1-3] size in microns", type=Command.CommandType.QUERY)
    public int getSlitSize(@Argument(name="slit", description="slit number 1-3") int slit, @Argument(name="waitIfLocked", description="flag denoting waiting for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            if (slit != 1 && slit != 2 && slit != 3) {
                throw new IllegalArgumentException("grating setting invalid: " + slit);
            }
            String str = "slit" + Integer.toString(slit) + "microns?";
            this.writeMono(str);
            this.readMono();
            String resp = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError(str, err);
                throw new DriverException("Getting slit size ErrorCode: " + err);
            }
            int n = Integer.parseInt(resp);
            return n;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="getStatus", description="get status byte", type=Command.CommandType.QUERY)
    public int getStatus() throws DriverException {
        return this.getStatus(this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getStatus", description="get status byte", type=Command.CommandType.QUERY)
    public int getStatus(@Argument(name="waitIfLocked", description="flag denoting waiting for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            this.writeMono("stb?");
            this.readMono();
            String stb = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError("STB?", err);
                throw new DriverException("Error when checking stb? ErrorCode: " + err);
            }
            int n = Integer.parseInt(stb);
            return n;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="getStep", description="get status byte", type=Command.CommandType.QUERY)
    public int getStep() throws DriverException {
        return this.getStep(this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getStep", description="get status byte", type=Command.CommandType.QUERY)
    public int getStep(@Argument(name="waitIfLocked", description="flag denoting waiting for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            this.writeMono("step?");
            this.readMono();
            String resp = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError("STEP?", err);
                throw new DriverException("get step ErrorCode: " + err);
            }
            int n = Integer.parseInt(resp);
            return n;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="advanceSteps", description="move wavelength drive by number of steps", type=Command.CommandType.ACTION)
    public void advanceSteps(int param) throws DriverException {
        try {
            C260Lock.lock();
            String str = "step " + param;
            this.writeMono(str);
            this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError(str, err);
                throw new DriverException("advanceSteps ErrorCode: " + err);
            }
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="getUnits", description="query units", type=Command.CommandType.QUERY)
    public String getUnits() throws DriverException {
        return this.getUnits(this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getUnits", description="query units", type=Command.CommandType.QUERY)
    public String getUnits(@Argument(name="waitIfLocked", description="flag denoting waiting for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            this.writeMono("units?");
            this.readMono();
            String resp = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError("UNITS?", err);
                throw new DriverException("getUnits ErrorCode: " + err);
            }
            String string = resp;
            return string;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="setUnits", description="set units NM, UM, WN", type=Command.CommandType.ACTION)
    public void setUnits(String param) throws DriverException {
        String str = "units " + param;
        this.writeMono(str);
        this.readMono();
        if (this.checkHandshakeErr()) {
            int err = this.readError();
            this.addError(str, err);
            throw new DriverException("setUnits ErrorCode: " + err);
        }
    }

    @Command(name="getWave", description="get current wavelength", type=Command.CommandType.QUERY)
    public double getWave() throws DriverException {
        return this.getWave(this.globalWaitForLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="getWave", description="get current wavelength", type=Command.CommandType.QUERY)
    public double getWave(@Argument(name="waitIfLocked", description="flad denoting waiting for lock") boolean waitIfLocked) throws DriverException {
        try {
            if (waitIfLocked) {
                C260Lock.lock();
            } else if (!C260Lock.tryLock()) {
                throw new DriverLockedException();
            }
            this.writeMono("wave?");
            this.readMono();
            String resp = this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError("WAVE?", err);
                throw new DriverException("getWave ErrorCode: " + err);
            }
            double d = Double.parseDouble(resp);
            return d;
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    @Command(name="testThreads", description="test routine", type=Command.CommandType.ACTION)
    public void testThreads(double w) throws DriverException {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(1000L);
                    Double wave = C260.this.getWave();
                    System.out.println("wave= " + Double.toString(wave));
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        };
        t.start();
        this.setWave(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="setWave", description="Set the Wavelength", type=Command.CommandType.ACTION)
    public void setWave(@Argument(name="wavelength", description="wavelength in nm < 1400") double param) throws DriverException {
        try {
            String cmd;
            C260Lock.lock();
            DecimalFormat df = new DecimalFormat("###.###");
            try {
                if (!(param < 1400.0)) {
                    throw new IllegalArgumentException("input parameter out of bounds");
                }
                cmd = "gowave " + df.format(param);
            }
            catch (Exception e) {
                throw new DriverException("input parameter out of bounds: " + e);
            }
            this.writeMono(cmd);
            this.readMono();
            if (this.checkHandshakeErr()) {
                int err = this.readError();
                this.addError(cmd, err);
                throw new DriverException("setWave ErrorCode: " + err);
            }
        }
        finally {
            if (C260Lock.isHeldByCurrentThread()) {
                C260Lock.unlock();
            }
        }
    }

    public void writeMono(String command) throws DriverException {
        this.write(command);
    }

    public String readMono() throws DriverException {
        return this.read();
    }

    public String readMono(String command) throws DriverException {
        this.writeMono(command);
        return this.readMono();
    }

    private storedError getLastError() {
        if (this.errorCol.size() > 0) {
            return this.errorCol.get(this.errorCol.size() - 1);
        }
        return null;
    }

    private void addError(String cmd, int errCode) {
        if (this.errorCol.size() >= 5) {
            this.errorCol.remove(0);
        }
        this.errorCol.add(new storedError(cmd, errCode));
    }

    public static enum onOff {
        OFF,
        ON;

    }

    public class storedError {
        private String cmd;
        private int errCode;

        public storedError() {
            this.cmd = "";
            this.errCode = -1;
        }

        public storedError(String c, int e) {
            this.cmd = c;
            this.errCode = e;
        }

        public String getCommand() {
            return this.cmd;
        }

        public int getErrorCode() {
            return this.errCode;
        }

        public void setCommand(String c) {
            this.cmd = c;
        }

        public void setErrorCode(int e) {
            this.errCode = e;
        }

        public String getStr() {
            return this.cmd + " " + Integer.toString(this.errCode);
        }
    }
}

