/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.newportlamp;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.newportlamp.NewportLamp;

public class TestN69911 {
    protected NewportLamp mydev;

    @Command(name="open", description="Open a device for use")
    public void open(@Argument(name="connType", description="type of connection NETWORK(0), FTDI(1), SERIAL(2)") int itype, @Argument(name="devId", description="The device ID of the device to open") String MyDevId) throws DriverException {
        this.mydev = new NewportLamp();
        this.mydev.open(itype, MyDevId, 9600);
    }

    @Command(name="openftdi", description="Open FTDI connection to device")
    public String openftdi(@Argument(name="serialname", description="FTDI id") String host, @Argument(name="baud", description="baud") int baud) throws DriverException {
        this.mydev = new NewportLamp();
        this.mydev.openftdi(host, baud);
        return this.mydev.getIdent();
    }

    @Command(name="close", description="Close the device")
    public void close() throws Exception {
        this.mydev.close();
    }

    @Command(name="getState", description="Return On(true) or Off(false)")
    public boolean getState() throws Exception {
        return this.mydev.getState();
    }

    @Command(name="readamps", description="Read amps ")
    public double readamps() throws Exception {
        return this.mydev.getAmps();
    }

    @Command(name="readwatts", description="Read watts ")
    public double readwatts() throws Exception {
        return this.mydev.getWatts();
    }

    @Command(name="readcurrentpreset", description="Read Current Preset ")
    public double readcurrentpreset() throws Exception {
        return this.mydev.getCurrentPreset();
    }

    @Command(name="setcurrentpreset", description="set Current Preset ")
    public void setcurrentpreset(@Argument(name="current", description="current preset value") double a) throws Exception {
        this.mydev.setCurrentPreset(a);
    }

    @Command(name="readcurrentlimit", description="Read Current Limit ")
    public double readcurrentlimit() throws Exception {
        return this.mydev.getCurrentLim();
    }

    @Command(name="setcurrentlimit", description="set Current Limit ")
    public void setcurrentlimit(@Argument(name="current", description="current limit value") double a) throws Exception {
        this.mydev.setCurrentLim(a);
    }

    @Command(name="readpowerpreset", description="Read Power Preset ")
    public int readpowerpreset() throws Exception {
        return this.mydev.getPowerPreset();
    }

    @Command(name="setpowerpreset", description="set Power Preset ")
    public void setpowerpreset(@Argument(name="power", description="power preset value") int p) throws Exception {
        this.mydev.setPowerPreset(p);
    }

    @Command(name="readpowerlimit", description="Read Power Limit ")
    public int readpowerlim() throws Exception {
        return this.mydev.getPowerLim();
    }

    @Command(name="setpowerlimit", description="set Power Limit ")
    public void setpowerlimit(@Argument(name="power", description="power limit value") int p) throws Exception {
        this.mydev.setPowerLim(p);
    }

    @Command(name="readident", description="Read ident")
    public String readident() throws Exception {
        return this.mydev.getIdent();
    }

    @Command(name="getstatus", description="Read power state of lamp")
    public String getstatus() throws Exception {
        return this.mydev.getStatus();
    }

    @Command(name="getlampon", description="Returns true if lamp on status bit is high")
    public boolean getlampon() throws Exception {
        return this.mydev.statusLampOn();
    }

    @Command(name="getpowermode", description="Returns true if power mode status bit is on")
    public boolean getpowermode() throws Exception {
        return this.mydev.statusPowerMode();
    }

    @Command(name="getcurrentmode", description="Returns true if current mode status bit is on")
    public boolean getcurrentmode() throws Exception {
        return this.mydev.statusCurrentMode();
    }

    @Command(name="geterror", description="Returns full error byte in HEX")
    public String geterror() throws Exception {
        return this.mydev.getError();
    }

    @Command(name="checkerrorcommand", description="Parses error string")
    public boolean checkerrorcommand(String err) throws Exception {
        return this.mydev.parseErrorCommand(err);
    }

    @Command(name="checkerrorcomplete", description="Parses error string")
    public boolean checkerrorcomplete(String err) throws Exception {
        return this.mydev.parseErrorOpComplete(err);
    }

    @Command(name="setstate", description="Set power state of lamp")
    public void setstate(@Argument(name="state", description="boolean state of device; true = ON") boolean on) throws Exception {
        this.mydev.setState(on);
    }
}

