/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.twistorr;

import java.util.Date;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.TestAscii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.twistorr.TwisTorr84;

public class Test84
extends TestAscii {
    private final TwisTorr84 tt84;

    public Test84() {
        super(new TwisTorr84());
        this.tt84 = (TwisTorr84)this.dev;
    }

    @Command(name="timestamp", description="Prints current time")
    public String timestamp() {
        Date now = new Date();
        return now.toString();
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="ident", description="Identification") String ident) throws DriverException {
        this.tt84.open(ident);
    }

    @Command(name="readAll", description="Read all controller settings and data")
    public String readAll() {
        String table = "Read all turbo-pump settings and data\n" + this.timestamp() + "\n";
        TwisTorr84.CmndBool[] cmndB = TwisTorr84.CmndBool.values();
        int nB = cmndB.length;
        for (int i = 0; i < nB; ++i) {
            table = table + String.format("\n   %-22s", new Object[]{cmndB[i]});
            try {
                boolean respB = this.tt84.readBool(cmndB[i]);
                table = table + Boolean.toString(respB);
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        TwisTorr84.CmndNumeric[] cmndN = TwisTorr84.CmndNumeric.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = table + String.format("\n   %-22s", new Object[]{cmndN[i]});
            try {
                int respN = this.tt84.readNumeric(cmndN[i]);
                table = table + Integer.toString(respN);
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        TwisTorr84.CmndAlpha[] cmndA = TwisTorr84.CmndAlpha.values();
        int nA = cmndA.length;
        for (int i = 0; i < nA; ++i) {
            table = table + String.format("\n   %-22s", new Object[]{cmndA[i]});
            try {
                String respA = this.tt84.readAlpha(cmndA[i]);
                table = table + respA;
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        return table;
    }

    @Command(name="readTemp", description="Read pump temperature in degrees C")
    public String readTemp() throws DriverException {
        int temp = this.tt84.readNumeric(TwisTorr84.CmndNumeric.PUMP_TEMP);
        return Integer.toString(temp);
    }

    @Command(name="readActiveStop", description="Read active-stop setting")
    public String readActiveStop() throws DriverException {
        boolean as = this.tt84.readBool(TwisTorr84.CmndBool.ACTIVE_STOP);
        return Boolean.toString(as);
    }

    @Command(name="readStatus", description="Get pump status, including operating modes and failure")
    public String readStatus() throws DriverException {
        int status = this.tt84.readNumeric(TwisTorr84.CmndNumeric.STATUS);
        return TwisTorr84.PumpStatus.decode(status);
    }

    @Command(name="readErrorCode", description="Read pump error code")
    public String readErrorCode() throws DriverException {
        int errcode = this.tt84.readNumeric(TwisTorr84.CmndNumeric.ERRCODE);
        return Integer.toString(errcode, 16) + TwisTorr84.decodeError(errcode);
    }

    @Command(name="testErrorCode", description="Test decoding of error code")
    public String testErrorCode(@Argument(name="testcode", description="code to test, 0 to 0xff") int testcode) {
        return Integer.toString(testcode, 16) + TwisTorr84.decodeError(testcode);
    }

    @Command(name="startPump", description="Start the pump")
    public void startPump() throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.START_STOP, true);
    }

    @Command(name="stopPump", description="Stop the pump")
    public void stopPump() throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.START_STOP, false);
    }

    @Command(name="setLowSpeedMode", description="Low-speed mode on/off")
    public void setLowSpeedMode(@Argument(name="<true|false>", description="Low-speed mode true or false") boolean value) throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.LOW_SPEED, value);
    }

    @Command(name="setSoftStart", description="Soft-start mode on/off")
    public void setSoftStart(@Argument(name="<true|false>", description="Soft-start mode true or false") boolean value) throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.SOFT_START, value);
    }

    @Command(name="setActiveStop", description="Active-stop mode on/off")
    public void setActiveStop(@Argument(name="<true|false>", description="Active-stop mode true or false") boolean value) throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.ACTIVE_STOP, value);
    }

    @Command(name="setRemote", description="Select remote vs. serial mode")
    public void setRemote(@Argument(name="<true|false>", description="Remote I/O mode (true) vs. Serial mode (false)") boolean value) throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.REMOTE, value);
    }

    @Command(name="setWaterCooling", description="Water cooling on/off")
    public void setWaterCooling(@Argument(name="<true|false>", description="Water cooling true or false") boolean value) throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.WATER_COOLING, value);
    }

    @Command(name="setInterlockType", description="Interlock signal continuos vs. impulse")
    public void setInterlockType(@Argument(name="<true|false>", description="Continuous (true, default) or impulse (false)") boolean value) throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.INTERLOCK_TYPE, value);
    }

    @Command(name="enableSpeedRead", description="Enable/disable pump-speed read after Stop")
    public void enableSpeedRead(@Argument(name="<true|false>", description="Enable (true) or disable(false, default)") boolean value) throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.SPEED_READ_ACTIVATE, value);
    }

    @Command(name="setGasType", description="Select gas load type")
    public void setGasType(@Argument(name="<int>", description="false for N2, true for Ar") boolean value) throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.GAS_TYPE_ARGON, value);
    }

    @Command(name="setBaudRate", description="Select baud rate")
    public void setBaudRate(@Argument(name="<int>", description="0 to 4 for 600, 1200, 2400, 4800, 9600 (default)") int value) throws DriverException {
        this.tt84.writeNumeric(TwisTorr84.CmndNumeric.BAUD_RATE, value);
    }

    @Command(name="setRotFreq", description="Set rotational frequency")
    public void setRotFreq(@Argument(name="<int>", description="1100 to 1350 (default) Hz") int value) throws DriverException {
        this.tt84.writeNumeric(TwisTorr84.CmndNumeric.ROTFREQ_SET, value);
    }

    @Command(name="setLowFreq", description="Set low-speed rotational freq.")
    public void setLowFreq(@Argument(name="<int>", description="1100 Hz (default) to normal freq.") int value) throws DriverException {
        this.tt84.writeNumeric(TwisTorr84.CmndNumeric.ROTFREQ_LOW, value);
    }

    @Command(name="setVentOperation", description="Vent valve operation")
    public void setVentOperation(@Argument(name="<true|false>", description="On-command (true) vs. Automatic (false, default)") boolean value) throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.VENTVALVE_BY_CMND, value);
    }

    @Command(name="openVentValve", description="Open vent valve")
    public void openVentValve() throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.VENTVALVE_OPEN, true);
    }

    @Command(name="closeVentValve", description="Close vent valve")
    public void closeVentValve() throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.VENTVALVE_OPEN, false);
    }

    @Command(name="setVentDelay", description="Vent valve-open delay")
    public void setVentDelay(@Argument(name="<int>", description="Opening delay after stop in auto mode, unit 0.2 s") int value) throws DriverException {
        this.tt84.writeNumeric(TwisTorr84.CmndNumeric.VENT_DELAY, value);
    }

    @Command(name="setVentOpenTime", description="Vent valve-open time")
    public void setVentOpenTime(@Argument(name="<int>", description="Open-time in automatic mode, unit 0.2 s, 0 for infinity") int value) throws DriverException {
        this.tt84.writeNumeric(TwisTorr84.CmndNumeric.VENT_OPENTIME, value);
    }

    @Command(name="setpointType", description="Quantity for setpoint")
    public void setpointType(@Argument(name="<int>", description="setpoint on frequency (0, default), power (1), time (2), normal (3), pressure (4)") int value) throws DriverException {
        this.tt84.writeNumeric(TwisTorr84.CmndNumeric.SETPOINT_TYPE, value);
    }

    @Command(name="setpointValue", description="setpoint value")
    public void setpointValue(@Argument(name="<int>", description="setpoint value in Hz, W or s (default = 867)") int value) throws DriverException {
        this.tt84.writeNumeric(TwisTorr84.CmndNumeric.SETPOINT_VALUE, value);
    }

    @Command(name="setpointLevel", description="setpoint active level")
    public void setpointLevel(@Argument(name="<true|false>", description="Active on low-level (true, default) vs. high-level (false)") boolean value) throws DriverException {
        this.tt84.writeBool(TwisTorr84.CmndBool.SETPOINT_LEVEL, value);
    }

    @Command(name="setpointDelay", description="setpoint-check delay")
    public void setpointDelay(@Argument(name="<int>", description="Seconds after pump start (default 0)") int value) throws DriverException {
        this.tt84.writeNumeric(TwisTorr84.CmndNumeric.SETPOINT_DELAY, value);
    }

    @Command(name="setpointHyst", description="setpoint hysteresis")
    public void setpointHyst(@Argument(name="<int>", description="Hysteresis in % of value (default = 2)") int value) throws DriverException {
        this.tt84.writeNumeric(TwisTorr84.CmndNumeric.SETPOINT_HYST, value);
    }

    @Command(name="selectAnalog", description="select analog output")
    public void selectAnalog(@Argument(name="<int>", description="Select analog output (0 to 3, default = 0, frequency)") int value) throws DriverException {
        this.tt84.writeNumeric(TwisTorr84.CmndNumeric.ANALOG_OUTPUT, value);
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }
}

