/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lakeshore;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;

public class LS330
extends Ascii {
    public static final int MODE_LOCAL = 0;
    public static final int MODE_REMOTE = 1;
    public static final int MODE_REMOTEWITHLOCKOUT = 2;
    private static final byte CR = 13;
    private static final byte LF = 10;
    private final String terminator = "\r\n";
    private final int wordLen = 7;
    private final int stopBits = 1;
    private final int parity = 1;
    private Boolean verbose = true;
    private Boolean tracedebug = false;
    private Boolean fakeout = false;
    private double setPoint = -95.0;
    private String controlUnits = "C";
    private String sampleUnits = "C";
    private String controlChannel = "A";
    private String sampleChannel = "A";
    private double maxAllowedTempC = 30.0;
    private double minAllowedTempC = -120.0;
    private double maxAllowedTempK = this.maxAllowedTempC + 273.15;
    private double minAllowedTempK = this.minAllowedTempC + 273.15;

    public void open(String serialname, int baud) throws DriverException {
        int asciiParam = LS330.makeDataCharacteristics((Ascii.DataBits)Ascii.DataBits.SEVEN, (Ascii.StopBits)Ascii.StopBits.ONE, (Ascii.Parity)Ascii.Parity.ODD, (Ascii.FlowCtrl)Ascii.FlowCtrl.NONE);
        this.open(2, serialname, baud, asciiParam);
        this.init();
    }

    public void openftdi(String serialname, int baud) throws DriverException {
        System.out.println("opening connection to the LakeShore 330 temperature controller");
        int asciiParam = LS330.makeDataCharacteristics((Ascii.DataBits)Ascii.DataBits.SEVEN, (Ascii.StopBits)Ascii.StopBits.ONE, (Ascii.Parity)Ascii.Parity.ODD, (Ascii.FlowCtrl)Ascii.FlowCtrl.NONE);
        this.open(1, serialname, baud, asciiParam);
        this.init();
        if (this.tracedebug.booleanValue()) {
            System.out.println("Done opening Lakeshore 330");
        }
    }

    public void init() throws DriverException {
        if (this.verbose.booleanValue()) {
            System.out.println("init of Lakeshore 330");
        }
        this.setTerminator("\r\n");
        this.setMode(Modes.REMOTE);
        this.setControlUnits("C");
        this.setControlChannel("A");
        this.setSampleUnits("C");
        this.setSampleChannel("A");
        this.setSetpoint(-95.0);
        this.setHeaterRange(HeaterRange.HIGH.getValue());
        if (this.tracedebug.booleanValue()) {
            System.out.println("Done with init of Lakeshore 330");
        }
    }

    public void close() throws DriverException {
    }

    public void setVerbose(Boolean flag) throws DriverException {
        this.verbose = flag;
    }

    public void setTracedebug(Boolean flag) throws DriverException {
        this.tracedebug = flag;
    }

    public void setFakeout(Boolean flag) throws DriverException {
        this.fakeout = flag;
    }

    public String getIdent() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getIdent");
        }
        try {
            String idstr = this.fakeout == true ? "Fake Lakeshore 330" : this.readLS330("*IDN?");
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 getIdent: ID = " + idstr);
            }
            return idstr;
        }
        catch (DriverException e) {
            String errstr = "ls330 getIdent: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void reset() throws DriverException {
        try {
            this.writeLS330("*RST");
        }
        catch (DriverException e) {
            String errstr = "ls330 reset: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public String getMode() throws DriverException {
        try {
            String mode = this.readLS330("MODE?");
            return mode;
        }
        catch (DriverException e) {
            String errstr = "ls330 getMode: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void setMode(Modes mode) throws DriverException {
        try {
            if (mode.getValue() < Modes.LOCAL.getValue() && mode.getValue() > Modes.REMOTEWITHLOCALLOCKOUT.getValue()) {
                throw new DriverException("mode out of bounds [0,2], " + mode.getValue());
            }
            this.writeLS330("MODE " + mode.getValue());
        }
        catch (DriverException e) {
            String errstr = "ls330 setMode: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public double getSetpoint() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getSetpoint");
        }
        try {
            double setp = this.fakeout == true ? this.setPoint : Double.valueOf(this.readLS330("SETP?"));
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 getSetpoint: Set Point = " + setp);
            }
            this.setPoint = setp;
            return setp;
        }
        catch (DriverException e) {
            String errstr = "ls330 getSetpoint: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void setSetpoint(double setp) throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 setSetpoint: " + setp);
        }
        if ("C".equals(this.controlUnits) && setp < this.minAllowedTempC || setp > this.maxAllowedTempC) {
            String errstr = "ls330 setSetpoint: Invalid set point: " + setp;
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        if ("K".equals(this.controlUnits) && setp < this.minAllowedTempK || setp > this.maxAllowedTempK) {
            String errstr = "ls330 setSetpoint: Invalid set point: " + setp;
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        try {
            this.writeLS330("SETP " + setp);
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 setSetpoint: Set Point = " + setp);
            }
            this.setPoint = setp;
        }
        catch (DriverException e) {
            String errstr = "ls330 setSetpoint: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public String getControlChannel() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getControlChannel");
        }
        try {
            String chan = this.fakeout == true ? this.controlChannel : this.readLS330("CCHN?");
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 getControlChannel: channel = " + chan);
            }
            this.controlChannel = chan;
            return chan;
        }
        catch (DriverException e) {
            String errstr = "ls330 getControlChannel: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void setControlChannel(String chan) throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 setControlChannel: " + chan);
        }
        if (!"A".equals(chan) && !"B".equals(chan)) {
            String errstr = "ls330 setControlChannel: Invalid channel: " + chan;
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        try {
            if (!this.fakeout.booleanValue()) {
                this.writeLS330("CCHN " + chan);
            }
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 setControlChannel: units = " + chan);
            }
            this.controlChannel = chan;
        }
        catch (DriverException e) {
            String errstr = "ls330 setControlChannel: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public String getControlUnits() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getControlUnits");
        }
        try {
            String unitstr = this.fakeout == true ? this.controlUnits : this.readLS330("CUNI?");
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 getControlUnits: units = " + unitstr);
            }
            this.controlUnits = unitstr;
            return unitstr;
        }
        catch (DriverException e) {
            String errstr = "ls330 getControlUnits: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void setControlUnits(String unitstr) throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 setControlUnits: " + unitstr);
        }
        if (!"C".equals(unitstr) && !"K".equals(unitstr)) {
            String errstr = "ls330 setControlUnits: Invalid units: " + unitstr;
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        try {
            if (!this.fakeout.booleanValue()) {
                this.writeLS330("CUNI " + unitstr);
            }
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 setControlUnits: units = " + unitstr);
            }
            this.controlUnits = unitstr;
        }
        catch (DriverException e) {
            String errstr = "ls330 setControlUnits: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public Double getControlData() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getControlData");
        }
        try {
            Double data = this.fakeout == true ? Double.valueOf(-95.0) : Double.valueOf(this.readLS330("CDAT?"));
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 getControlData: data = " + data);
            }
            return data;
        }
        catch (DriverException e) {
            String errstr = "ls330 getControlData: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public String getSampleChannel() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getSampleChannel");
        }
        try {
            String chan = this.fakeout == true ? this.sampleChannel : this.readLS330("SCHN?");
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 getSampleChannel: channel = " + chan);
            }
            this.sampleChannel = chan;
            return chan;
        }
        catch (DriverException e) {
            String errstr = "ls330 getSampleChannel: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void setSampleChannel(String chan) throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 setSampleChannel: " + chan);
        }
        if (!"A".equals(chan) && !"B".equals(chan)) {
            String errstr = "ls330 setSampleChannel: Invalid channel: " + chan;
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        try {
            if (!this.fakeout.booleanValue()) {
                this.writeLS330("SCHN " + chan);
            }
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 setSampleChannel: units = " + chan);
            }
            this.sampleChannel = chan;
        }
        catch (DriverException e) {
            String errstr = "ls330 setSampleChannel: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public String getSampleUnits() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getSampleUnits");
        }
        try {
            String unitstr = this.fakeout == true ? this.sampleUnits : this.readLS330("SUNI?");
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 getSampleUnits: units = " + unitstr);
            }
            this.sampleUnits = unitstr;
            return unitstr;
        }
        catch (DriverException e) {
            String errstr = "ls330 getSampleUnits: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void setSampleUnits(String unitstr) throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 setSampleUnits: " + unitstr);
        }
        if (!"C".equals(unitstr) && !"K".equals(unitstr)) {
            String errstr = "ls330 setSampleUnits: Invalid units: " + unitstr;
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
        try {
            if (!this.fakeout.booleanValue()) {
                this.writeLS330("SUNI " + unitstr);
            }
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 setSampleUnits: units = " + unitstr);
            }
            this.sampleUnits = unitstr;
        }
        catch (DriverException e) {
            String errstr = "ls330 setControlUnits: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public Double getSampleData() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 getSampleData");
        }
        try {
            Double data = this.fakeout == true ? Double.valueOf(-95.0) : Double.valueOf(this.readLS330("SDAT?"));
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 getSampleData: data = " + data);
            }
            return data;
        }
        catch (DriverException e) {
            String errstr = "ls330 getSampleData: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public double getHeater() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("ls330 getHeater: Getting heater status");
        }
        try {
            double htrpwr = this.fakeout == true ? 50.0 : Double.valueOf(this.readLS330("HEAT?"));
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 getHeater: HTR = " + htrpwr);
            }
            return htrpwr;
        }
        catch (DriverException e) {
            String errstr = "ls330 getHeater: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public int getHeaterRange() throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("ls330 getHeaterRange");
        }
        try {
            int range = this.fakeout == true ? 0 : Integer.valueOf(this.readLS330("RANG?"));
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 getHeaterRange: RANGE = " + range);
            }
            return range;
        }
        catch (DriverException e) {
            String errstr = "ls330 getHeaterRange: " + (Object)((Object)e);
            System.err.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public boolean isInControl() throws DriverException {
        boolean inControl = false;
        try {
            Integer tune = this.fakeout == true ? Integer.valueOf(3) : Integer.valueOf(this.readLS330("TUNE?"));
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 isInControl = " + tune);
            }
            if (tune != 0) {
                inControl = true;
            }
            return inControl;
        }
        catch (DriverException e) {
            String errstr = "ls330 isInControl: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public void setHeaterRange(int range) throws DriverException {
        if (this.tracedebug.booleanValue()) {
            System.out.println("trace: ls330 setHeaterRange: " + range);
        }
        try {
            if (!this.fakeout.booleanValue()) {
                this.writeLS330("RANG " + range);
            }
            if (this.verbose.booleanValue()) {
                System.out.println("ls330 setHeaterRange: Range = " + range);
            }
        }
        catch (DriverException e) {
            String errstr = "ls330 setHeaterRange: " + (Object)((Object)e);
            System.out.println(errstr);
            throw new DriverException(errstr);
        }
    }

    public synchronized void writeLS330(String command) throws DriverException {
        if (this.fakeout.booleanValue()) {
            System.out.println("Fake LS330 Cmd: " + command);
        } else {
            this.write(command);
        }
    }

    public synchronized String readLS330() throws DriverException {
        return this.read();
    }

    public synchronized String readLS330(String command) throws DriverException {
        this.writeLS330(command);
        return this.readLS330();
    }

    public static enum Modes {
        LOCAL(0),
        REMOTE(1),
        REMOTEWITHLOCALLOCKOUT(2);

        int value;

        private Modes(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum HeaterRange {
        OFF(0),
        LOW(1),
        MEDIUM(2),
        HIGH(3);

        int value;

        private HeaterRange(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

