/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.CompositeCommandSet;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.RoutingCommandSet;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;

public class RouteSelectionCommandSet
extends CompositeCommandSet {
    private String selectedRoute = "";
    private final CompositeCommandSet activeRouteCommandSet = new CompositeCommandSet();
    private final Map<String, RoutingCommandSet> paths = new ConcurrentHashMap<String, RoutingCommandSet>();

    public RouteSelectionCommandSet() {
        CommandSetBuilder builder = new CommandSetBuilder();
        BuiltIns builtIns = new BuiltIns();
        CommandSet builtInCommandSet = builder.buildCommandSet(builtIns);
        this.add(builtInCommandSet);
        this.add(this.activeRouteCommandSet);
    }

    public RouteSelectionCommandSet(CompositeCommandSet parentCommandSet) {
        this();
        this.add(parentCommandSet);
    }

    private void updateActiveRoute() {
        this.activeRouteCommandSet.clear();
        if (!"".equals(this.selectedRoute)) {
            Map<String, RoutingCommandSet> routesMap = RouteSelectionCommandSet.getAvailableRoutesMap(this, false);
            for (Map.Entry<String, RoutingCommandSet> entry : routesMap.entrySet()) {
                String routeName = entry.getKey();
                if (routeName.equals(this.selectedRoute)) {
                    CommandSet c = entry.getValue().getRouteCommandSet();
                    this.activeRouteCommandSet.add(c);
                    continue;
                }
                if (!routeName.startsWith(this.selectedRoute + "/")) continue;
                String newRoute = routeName.replace(this.selectedRoute + "/", "");
                RoutingCommandSet c = new RoutingCommandSet(newRoute, entry.getValue().getPath(), entry.getValue().getRouteCommandSet());
                this.activeRouteCommandSet.add(c);
            }
        }
    }

    void setActiveRoute(String value) {
        if ("".equals(value)) {
            this.selectedRoute = "";
        } else {
            String fullRoute;
            Map<String, RoutingCommandSet> rs = RouteSelectionCommandSet.getAvailableRoutesMap(this, false);
            String string = fullRoute = !rs.containsKey(value) && !"".equals(this.selectedRoute) ? this.selectedRoute + "/" + value : value;
            if (!rs.containsKey(fullRoute)) {
                throw new RuntimeException("Error: could not find target \"" + value + "\".");
            }
            this.selectedRoute = fullRoute;
        }
        this.updateActiveRoute();
    }

    String getActiveRoute() {
        return this.selectedRoute;
    }

    public void setRouteLevel(String route, int level) {
        String fullRoute;
        Map<String, RoutingCommandSet> routes = RouteSelectionCommandSet.getAvailableRoutesMap(this, false);
        String string = fullRoute = !routes.containsKey(route) && !"".equals(this.selectedRoute) ? this.selectedRoute + "/" + route : route;
        if (!routes.containsKey(fullRoute)) {
            throw new RuntimeException("Error: could not find target \"" + route + "\".");
        }
        for (Map.Entry<String, RoutingCommandSet> e : routes.entrySet()) {
            String r = e.getKey();
            if (!fullRoute.equals(r) && !r.startsWith(fullRoute + "/")) continue;
            e.getValue().getCommandDictionary().setLevel(level);
        }
    }

    public int getRouteLevel(String route) {
        String fullRoute;
        Map<String, RoutingCommandSet> routes = RouteSelectionCommandSet.getAvailableRoutesMap(this, false);
        String string = fullRoute = !routes.containsKey(route) && !"".equals(this.selectedRoute) ? this.selectedRoute + "/" + route : route;
        if (!routes.containsKey(fullRoute)) {
            throw new RuntimeException("Error: could not find target \"" + route + "\".");
        }
        return routes.get(fullRoute).getCommandDictionary().getLevel();
    }

    public void setRouteCommandTypeVisibility(String route, Command.CommandType ... types) {
        String fullRoute;
        Map<String, RoutingCommandSet> routes = RouteSelectionCommandSet.getAvailableRoutesMap(this, false);
        String string = fullRoute = !routes.containsKey(route) && !"".equals(this.selectedRoute) ? this.selectedRoute + "/" + route : route;
        if (!routes.containsKey(fullRoute)) {
            throw new RuntimeException("Error: could not find target \"" + route + "\".");
        }
        for (Map.Entry<String, RoutingCommandSet> e : routes.entrySet()) {
            String r = e.getKey();
            if (!fullRoute.equals(r) && !r.startsWith(fullRoute + "/")) continue;
            e.getValue().getCommandDictionary().setVisibilityForTypes(types);
        }
    }

    public void addRoutingCommandSet(String path, CommandSet parent) {
        String route;
        if (!this.paths.containsKey(path)) {
            int first = path.indexOf("/");
            int last = path.lastIndexOf("/");
            route = path;
            if (first != last) {
                route = path.substring(0, first) + path.substring(last);
            }
        } else {
            throw new RuntimeException("Error: Route " + path + " already exists");
        }
        RoutingCommandSet crcs = new RoutingCommandSet(route, path, parent);
        this.add(crcs);
        this.paths.put(path, crcs);
    }

    public void removeRoute(String route) {
        Iterator<Map.Entry<String, RoutingCommandSet>> it = this.paths.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, RoutingCommandSet> e = it.next();
            String routeName = e.getKey();
            if (!routeName.equals(route) && !routeName.startsWith(route + "/")) continue;
            this.remove(e.getValue());
            it.remove();
        }
    }

    public boolean containsPath(String path) {
        return this.paths.containsKey(path);
    }

    public Map<String, RoutingCommandSet> getRoutes() {
        LinkedHashMap<String, RoutingCommandSet> res = new LinkedHashMap<String, RoutingCommandSet>();
        for (Map.Entry<String, RoutingCommandSet> entry : this.paths.entrySet()) {
            res.put(entry.getValue().getRoute(), entry.getValue());
        }
        return res;
    }

    public Map<String, CommandSet> getCommandSetsForRoute(String root) {
        HashMap<String, CommandSet> res = new HashMap<String, CommandSet>();
        for (Map.Entry<String, RoutingCommandSet> entry : this.paths.entrySet()) {
            String path = entry.getKey();
            if (!path.equals(root) && !path.startsWith(root + "/")) continue;
            res.put(path, entry.getValue().getRouteCommandSet());
        }
        return res;
    }

    private static Map<String, RoutingCommandSet> getAvailableRoutesMap(CommandSet cs, boolean filterByLevel) {
        LinkedHashMap<String, RoutingCommandSet> result = new LinkedHashMap<String, RoutingCommandSet>();
        if (cs instanceof RoutingCommandSet) {
            RoutingCommandSet rcs = (RoutingCommandSet)cs;
            String fullRoute = rcs.getRoute();
            int currLevel = rcs.getCommandDictionary().getLevel();
            DictionaryCommand dc = ((RoutingCommandSet.RoutingDictionary)rcs.getCommandDictionary()).getRouteCommand(fullRoute);
            if (!filterByLevel || dc.getLevel() <= currLevel) {
                result.put(fullRoute, (RoutingCommandSet)cs);
            }
        } else if (cs instanceof CompositeCommandSet) {
            for (CommandSet s : ((CompositeCommandSet)cs).getCommandSets()) {
                result.putAll(RouteSelectionCommandSet.getAvailableRoutesMap(s, filterByLevel));
            }
        }
        return result;
    }

    public class BuiltIns {
        @Command(description="Set the default command target", level=0)
        public void set(@Argument(name="item") SetGetTargetCommands what, @Argument(name="value", defaultValue="", allowedValueProvider="getSetAllowedValues") String value) {
            switch (what) {
                case TARGET: {
                    RouteSelectionCommandSet.this.setActiveRoute(value);
                }
            }
        }

        public List<String> getSetAllowedValues() {
            RouteSelectionCommandSet.this.updateActiveRoute();
            Map availableRouteMaps = RouteSelectionCommandSet.getAvailableRoutesMap(RouteSelectionCommandSet.this, true);
            for (CommandSet cs : RouteSelectionCommandSet.this.activeRouteCommandSet.getCommandSets()) {
                if (!(cs instanceof RoutingCommandSet)) continue;
                RoutingCommandSet rcs = (RoutingCommandSet)cs;
                if (!availableRouteMaps.containsKey(RouteSelectionCommandSet.this.selectedRoute + "/" + rcs.getRoute())) continue;
                availableRouteMaps.put(rcs.getRoute(), rcs);
            }
            return new ArrayList<String>(availableRouteMaps.keySet());
        }

        @Command(description="Get various settings", level=0)
        public String get(@Argument(name="item") SetGetTargetCommands what) {
            switch (what) {
                case TARGET: {
                    return RouteSelectionCommandSet.this.getActiveRoute();
                }
            }
            return null;
        }
    }

    public static enum SetGetTargetCommands {
        TARGET;

    }
}

