/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.alerts.InfrastructureAlert;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.CheckAgentStatusServiceMBean;
import org.lsst.ccs.services.MBeanService;
import org.lsst.ccs.utilities.scheduler.PeriodicTask;

public class CheckAgentStatusService
implements CheckAgentStatusServiceMBean,
Runnable,
ClearAlertHandler,
HasLifecycle {
    private final Agent a;
    private final AgentPeriodicTaskService periodicTaskService;
    private final List<String> tasksBehind = new ArrayList<String>();
    private final List<String> tasksWithFaiuresWarning = new ArrayList<String>();
    private final List<String> tasksWithFaiuresAlarm = new ArrayList<String>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private MBeanService mbeanService;

    public CheckAgentStatusService(Agent a) {
        this.a = a;
        this.periodicTaskService = a.getAgentPeriodicTaskService();
        ComponentNode checkAgentStatusServiceNode = new ComponentNode(a.getComponentLookup().getTopComponentNode(), "agentCheckService", (Object)this);
        a.getComponentLookup().addComponentNodeToLookup(a.getComponentLookup().getTopComponentNode(), checkAgentStatusServiceNode);
    }

    @Override
    public void postInit() {
        try {
            if (this.mbeanService != null) {
                this.mbeanService.registerMBean(this, new ObjectName("org.lsst.ccs.mbean:type=CheckStatus"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getStatus(boolean publish) {
        boolean isOk = true;
        for (PeriodicTask task : this.periodicTaskService.getPeriodicTasks()) {
            if (this.isPeriodicTaskOk(task, publish)) continue;
            isOk = false;
        }
        return isOk ? "OK" : "SICK";
    }

    @Override
    public String getStatus() {
        return this.getStatus(false);
    }

    @Override
    public String getStatusDescription() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> tasksFallingBehind = new ArrayList<String>();
        ArrayList<String> tasksWithFailure = new ArrayList<String>();
        for (PeriodicTask task : this.periodicTaskService.getPeriodicTasks()) {
            if (this.isPeriodicTaskBehind(task, false)) {
                tasksFallingBehind.add(task.getTaskName());
            }
            if (!this.isPeriodicTaskFailing(task, false)) continue;
            tasksWithFailure.add(task.getTaskName());
        }
        if (!tasksFallingBehind.isEmpty()) {
            sb.append("Tasks falling behind: ");
            for (String taskName : tasksFallingBehind) {
                sb.append(taskName).append(" ");
            }
            sb.append("\n");
        }
        if (!tasksWithFailure.isEmpty()) {
            sb.append("Tasks with failures: ");
            for (String taskName : tasksWithFailure) {
                sb.append(taskName).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void run() {
        this.getStatus(true);
    }

    private boolean isPeriodicTaskOk(PeriodicTask task, boolean publish) {
        boolean isTaskOk = true;
        if (this.isPeriodicTaskBehind(task, publish)) {
            isTaskOk = false;
        }
        if (this.isPeriodicTaskFailing(task, publish)) {
            isTaskOk = false;
        }
        return isTaskOk;
    }

    private boolean isPeriodicTaskBehind(PeriodicTask task, boolean publish) {
        long delay = task.getDelay(TimeUnit.MILLISECONDS);
        long period = task.getPeriod(TimeUnit.MILLISECONDS);
        String taskName = task.getTaskName();
        if (delay < 0L && Math.abs(delay) > period / 2L) {
            if (publish && !this.tasksBehind.contains(taskName)) {
                this.tasksBehind.add(taskName);
                this.a.getAlertService().raiseAlert(InfrastructureAlert.PERIODIC_TASK_BEHIND.getAlert(), AlertState.ALARM, "The following tasks are falling behind: " + this.tasksBehind + ". " + this.periodicTaskService.getSchedulerState());
            }
            return true;
        }
        if (delay > 0L && publish && this.tasksBehind.remove(taskName) && this.tasksBehind.isEmpty()) {
            this.a.getAlertService().raiseAlert(InfrastructureAlert.PERIODIC_TASK_BEHIND.getAlert(), AlertState.NOMINAL, "All tasks are keeping up. " + this.periodicTaskService.getSchedulerState());
        }
        return false;
    }

    private boolean isPeriodicTaskFailing(PeriodicTask task, boolean publish) {
        int taskFailures = task.getFailures();
        String taskName = task.getTaskName();
        if (taskFailures > 0) {
            int taskMaxFailures = task.getMaxFailures();
            if (taskFailures > taskMaxFailures / 2 && taskFailures < taskMaxFailures) {
                if (publish && !this.tasksWithFaiuresWarning.contains(taskName)) {
                    this.tasksWithFaiuresWarning.add(taskName);
                    this.a.getAlertService().raiseAlert(InfrastructureAlert.PERIODIC_TASK_FAILURE.getAlert(), AlertState.WARNING, "Task " + taskName + " has experienced " + taskFailures + " exceptions. The maximum allowed exceptions is " + taskMaxFailures + " (" + this.tasksWithFaiuresWarning + "). " + this.periodicTaskService.getSchedulerState());
                }
            } else if (taskFailures >= taskMaxFailures) {
                if (publish && !this.tasksWithFaiuresAlarm.contains(taskName)) {
                    this.tasksWithFaiuresAlarm.add(taskName);
                    this.a.getAlertService().raiseAlert(InfrastructureAlert.PERIODIC_TASK_FAILURE.getAlert(), AlertState.ALARM, "Task " + taskName + " has experenced the maximum allowed number of exceptions: " + taskFailures + " (max:" + taskMaxFailures + "). It will stop executing. (" + this.tasksWithFaiuresAlarm + "). " + this.periodicTaskService.getSchedulerState());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        String alertId = alert.getAlertId();
        if (alertId.equals(InfrastructureAlert.PERIODIC_TASK_FAILURE.getAlertId())) {
            for (PeriodicTask task : this.periodicTaskService.getPeriodicTasks()) {
                if (!this.isPeriodicTaskFailing(task, false)) continue;
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        if (alertId.equals(InfrastructureAlert.PERIODIC_TASK_BEHIND.getAlertId())) {
            for (PeriodicTask task : this.periodicTaskService.getPeriodicTasks()) {
                if (!this.isPeriodicTaskBehind(task, false)) continue;
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }
}

