package org.lsst.ccs.subsystem.teststand.ui.jas;

import javax.swing.JComponent;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.services.optpage.OptionalPage;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.plugins.monitor.TabbedView;
import org.lsst.ccs.subsystem.teststand.data.TestStandAgentProperties;

/**
 *
 * @author homer
 */
//@Plugin(name = "TestStand new plugin", description = "Displays monitor tables for test stands")
public class TSMonitorPlugin extends ConsolePlugin {

    private final OptionalPage teststandOptionalPage = new TSMonitorPlugin.TestStandOptionalPage();

    @Override
    public void initialize() {
        Console.getConsole().getOptionalPageService().add(teststandOptionalPage);
    }

    static class TestStandOptionalPage implements OptionalPage {

        @Override
        public boolean isAutoOpen() {
            return false;
        }

        @Override
        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty(TestStandAgentProperties.TESTSTAND_TYPE_AGENT_PROPERTY) != null) {
                return "CCS Subsystems/"+agent.getName()+"/Monitoring";
            }
            return null;
        }

        @Override
        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            TabbedView view = new TabbedView();
            view.setViewFactory(name -> new SectionedTableView());
            TeststandMonitorFilter filter = new TeststandMonitorFilter(agent.getName());
            view.setFilter(filter);
            view.install();
            view.getPanel().setName(agent.getName()+" Monitoring");
            return view.getPanel();
        }

    }
}
