/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.aida;

import hep.aida.ITree;
import jas.hist.DataSource;
import jas.hist.JASHist;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHist2DHistogramStyle;
import jas.hist.JASHistData;
import jas.hist.JASHistStyle;
import jas.hist.XMLHistBuilder;
import java.awt.Color;
import java.awt.Dimension;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import org.freehep.application.studio.Studio;
import org.freehep.jas.extension.aida.AIDATreeDataSourceProvider;
import org.freehep.jas.services.HTMLComponentFactory;
import org.freehep.jas.util.IgnoreCase;
import org.freehep.swing.ColorConverter;
import org.freehep.util.FreeHEPLookup;

public class AIDAHTMLComponentFactory
implements HTMLComponentFactory {
    static final String[] pointStyles = new String[]{"dot", "box", "triangle", "diamond", "star", "vert_line", "horiz_line", "cross", "circle", "square"};
    private Studio app;
    private ITree aidaMasterTree;
    private AIDATreeDataSourceProvider adsp;
    private static final String[] classes = new String[]{"hep.aida.IDataPointSet", "hep.aida.IHistogram1D", "hep.aida.IHistogram2D", "hep.aida.ICloud1D", "hep.aida.ICloud2D", "hep.aida.IProfile1D", "hep.aida.IProfile2D", "hep.aida.IFunction"};

    public int getPointStyleIndex(String style) {
        int index = -1;
        for (int i = 0; i < pointStyles.length; ++i) {
            if (!style.equalsIgnoreCase(pointStyles[i])) continue;
            index = i;
            break;
        }
        return index;
    }

    void init(Studio app) {
        FreeHEPLookup lookup = app.getLookup();
        for (int i = 0; i < classes.length; ++i) {
            lookup.add((Object)this, classes[i]);
        }
        this.app = app;
        this.adsp = new AIDATreeDataSourceProvider();
    }

    public JComponent getComponent(String name, Map attributes) {
        JASHist component = null;
        JASHist plot = null;
        if (this.app == null) {
            this.app = (Studio)Studio.getApplication();
        }
        String path = (String)IgnoreCase.getIgnoreCase((Map)attributes, (String)"DATA");
        try {
            if (IgnoreCase.containsIgnoreCase((Map)attributes, (String)"XMLURL")) {
                String xmlURLString = (String)IgnoreCase.getIgnoreCase((Map)attributes, (String)"XMLURL");
                URL baseURL = (URL)IgnoreCase.getIgnoreCase((Map)attributes, (String)"BASEURL");
                URL xmlURL = new URL(baseURL, xmlURLString);
                InputStream is = xmlURL.openStream();
                InputStreamReader reader = new InputStreamReader(is);
                XMLHistBuilder builder = new XMLHistBuilder((Reader)reader, xmlURLString);
                plot = builder.getSoloPlot();
                plot.setAllowUserInteraction(false);
                component = plot;
                reader.close();
            } else {
                plot = new JASHist();
                DataSource ds = this.adsp.getDataSource(path);
                JASHistData data = plot.addData(ds);
                JASHistStyle style = data.getStyle();
                plot.setForegroundColor(Color.black);
                plot.setBackground(Color.white);
                plot.setDataAreaColor(Color.white);
                data.show(true);
                if (name.indexOf("2D") <= 0) {
                    plot.getYAxis().setAllowSuppressedZero(false);
                    if (style instanceof JASHist1DHistogramStyle) {
                        ((JASHist1DHistogramStyle)style).setHistogramFill(false);
                        ((JASHist1DHistogramStyle)style).setHistogramBarLineWidth(1.0f);
                        ((JASHist1DHistogramStyle)style).setHistogramBarLineColor(Color.black);
                        ((JASHist1DHistogramStyle)style).setShowErrorBars(false);
                        ((JASHist1DHistogramStyle)style).setErrorBarWidth(1.0f);
                        ((JASHist1DHistogramStyle)style).setErrorBarColor(Color.black);
                        ((JASHist1DHistogramStyle)style).setLinesBetweenPointsWidth(1.0f);
                        ((JASHist1DHistogramStyle)style).setLineColor(Color.black);
                    }
                } else {
                    ((JASHist2DHistogramStyle)style).setHistStyle(0);
                    ((JASHist2DHistogramStyle)style).setShapeColor(Color.black);
                }
                if (name.equalsIgnoreCase("hep.aida.IDataPointSet") && style instanceof JASHist1DHistogramStyle) {
                    ((JASHist1DHistogramStyle)style).setShowLinesBetweenPoints(true);
                    ((JASHist1DHistogramStyle)style).setLineColor(Color.blue);
                    ((JASHist1DHistogramStyle)style).setShowDataPoints(true);
                    ((JASHist1DHistogramStyle)style).setDataPointColor(Color.black);
                    ((JASHist1DHistogramStyle)style).setDataPointStyle(0);
                    ((JASHist1DHistogramStyle)style).setDataPointSize(5);
                    ((JASHist1DHistogramStyle)style).setShowErrorBars(false);
                    ((JASHist1DHistogramStyle)style).setShowHistogramBars(false);
                }
                this.configurePlot(plot, attributes, data);
                component = plot;
                plot.setAllowUserInteraction(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Can not create plot for path : " + path, e);
        }
        return component;
    }

    private void configurePlot(JASHist plot, Map attributes, JASHistData data) {
        JASHistStyle style = data.getStyle();
        Iterator it = attributes.keySet().iterator();
        while (it.hasNext()) {
            try {
                Object objKey = it.next();
                Object objVal = attributes.get(objKey);
                String key = objKey.toString();
                String value = objVal.toString();
                this.configurePlotProperties(plot, key, value);
                if (style instanceof JASHist1DHistogramStyle) {
                    this.configurePlotStyle((JASHist1DHistogramStyle)style, key, value);
                    continue;
                }
                if (!(style instanceof JASHist2DHistogramStyle)) continue;
                this.configurePlotStyle((JASHist2DHistogramStyle)style, key, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void configurePlotProperties(JASHist plot, String key, String value) throws Exception {
        boolean b = this.toBoolean(value);
        if (key.equalsIgnoreCase("xMin")) {
            double d = Double.parseDouble(value);
            plot.getXAxis().setMin(d);
        } else if (key.equalsIgnoreCase("xMax")) {
            double d = Double.parseDouble(value);
            plot.getXAxis().setMax(d);
        } else if (key.equalsIgnoreCase("yMin")) {
            double d = Double.parseDouble(value);
            plot.getYAxis().setMin(d);
        } else if (key.equalsIgnoreCase("y0Min")) {
            double d = Double.parseDouble(value);
            plot.getYAxis(0).setMin(d);
        } else if (key.equalsIgnoreCase("y1Min")) {
            double d = Double.parseDouble(value);
            plot.getYAxis(1).setMin(d);
        } else if (key.equalsIgnoreCase("yMax")) {
            double d = Double.parseDouble(value);
            plot.getYAxis().setMax(d);
        } else if (key.equalsIgnoreCase("y0Max")) {
            double d = Double.parseDouble(value);
            plot.getYAxis(0).setMax(d);
        } else if (key.equalsIgnoreCase("y1Max")) {
            double d = Double.parseDouble(value);
            plot.getYAxis(1).setMax(d);
        } else if (key.equalsIgnoreCase("plotForegroundColor") || key.equalsIgnoreCase("foregroundColor")) {
            plot.setForegroundColor(this.toColor(value));
        } else if (key.equalsIgnoreCase("plotBackgroundColor") || key.equalsIgnoreCase("backgroundColor")) {
            plot.setBackground(this.toColor(value));
        } else if (key.equalsIgnoreCase("dataAreaColor")) {
            plot.setDataAreaColor(this.toColor(value));
        } else if (key.equalsIgnoreCase("XAxisAllowSuppressedZero")) {
            plot.getXAxis().setAllowSuppressedZero(b);
        } else if (key.equalsIgnoreCase("YAxisAllowSuppressedZero")) {
            plot.getYAxis().setAllowSuppressedZero(b);
        } else if (key.equalsIgnoreCase("Y0AxisAllowSuppressedZero")) {
            plot.getYAxis(0).setAllowSuppressedZero(b);
        } else if (key.equalsIgnoreCase("Y1AxisAllowSuppressedZero")) {
            plot.getYAxis(1).setAllowSuppressedZero(b);
        } else if (key.equalsIgnoreCase("XAxisLogarithmic")) {
            plot.getXAxis().setLogarithmic(b);
        } else if (key.equalsIgnoreCase("YAxisLogarithmic")) {
            plot.getYAxis().setLogarithmic(b);
        } else if (key.equalsIgnoreCase("Y0AxisLogarithmic")) {
            plot.getYAxis(0).setLogarithmic(b);
        } else if (key.equalsIgnoreCase("Y1AxisLogarithmic")) {
            plot.getYAxis(1).setLogarithmic(b);
        } else if (key.equalsIgnoreCase("width") || key.equalsIgnoreCase("plotWidth")) {
            int d = Integer.parseInt(value);
            Dimension dim = plot.getPreferredSize();
            dim.width = d;
            plot.setPreferredSize(dim);
            plot.setMaximumSize(dim);
        } else if (key.equalsIgnoreCase("height") || key.equalsIgnoreCase("plotHeight")) {
            int d = Integer.parseInt(value);
            Dimension dim = plot.getPreferredSize();
            dim.height = d;
            plot.setPreferredSize(dim);
            plot.setMaximumSize(dim);
        }
    }

    private void configurePlotStyle(JASHist1DHistogramStyle style, String key, String value) throws Exception {
        boolean b = this.toBoolean(value);
        if (key.equalsIgnoreCase("histogramBarsFilled") || key.equalsIgnoreCase("histogramFill")) {
            style.setHistogramFill(this.toBoolean(value));
        } else if (key.equalsIgnoreCase("showHistogramBars")) {
            style.setShowHistogramBars(this.toBoolean(value));
        } else if (key.equalsIgnoreCase("showErrorBars")) {
            style.setShowErrorBars(this.toBoolean(value));
        } else if (key.equalsIgnoreCase("showDataPoints")) {
            style.setShowDataPoints(this.toBoolean(value));
        } else if (key.equalsIgnoreCase("showLinesBetweenPoints")) {
            style.setShowLinesBetweenPoints(this.toBoolean(value));
        } else if (key.equalsIgnoreCase("dataPointSize")) {
            int i = Integer.parseInt(value);
            style.setDataPointSize(i);
        } else if (key.equalsIgnoreCase("histogramBarColor")) {
            style.setHistogramBarColor(this.toColor(value));
        } else if (key.equalsIgnoreCase("errorBarColor")) {
            style.setErrorBarColor(this.toColor(value));
        } else if (key.equalsIgnoreCase("dataPointColor")) {
            style.setDataPointColor(this.toColor(value));
        } else if (key.equalsIgnoreCase("lineColor")) {
            style.setLineColor(this.toColor(value));
        } else if (key.equalsIgnoreCase("dataPointStyle")) {
            style.setDataPointStyle(this.getPointStyleIndex(value));
        }
    }

    private void configurePlotStyle(JASHist2DHistogramStyle style, String key, String value) throws Exception {
        if (key.equalsIgnoreCase("startDataColor")) {
            style.setStartDataColor(this.toColor(value));
        } else if (key.equalsIgnoreCase("endDataColor")) {
            style.setEndDataColor(this.toColor(value));
        } else if (key.equalsIgnoreCase("showOverflow")) {
            style.setShowOverflow(this.toBoolean(value));
        } else if (key.equalsIgnoreCase("showPlot")) {
            style.setShowPlot(this.toBoolean(value));
        } else if (key.equalsIgnoreCase("histStyle")) {
            style.setHistStyle(this.toStyle(value));
        } else if (key.equalsIgnoreCase("colorMapScheme")) {
            style.setColorMapScheme(this.toColorMapScheme(value));
        } else if (key.equalsIgnoreCase("shapeColor")) {
            style.setShapeColor(this.toColor(value));
        } else if (key.equalsIgnoreCase("overflowBinColor")) {
            style.setOverflowBinColor(this.toColor(value));
        } else if (key.equalsIgnoreCase("logZ")) {
            style.setLogZ(this.toBoolean(value));
        }
    }

    public Color toColor(String value) throws Exception {
        return ColorConverter.get((String)value);
    }

    private int toStyle(String s) {
        if (s.equalsIgnoreCase("STYLE_BOX")) {
            return 0;
        }
        if (s.equalsIgnoreCase("STYLE_ELLIPSE")) {
            return 1;
        }
        if (s.equalsIgnoreCase("STYLE_COLORMAP")) {
            return 2;
        }
        return 0;
    }

    private int toColorMapScheme(String s) {
        if (s.equalsIgnoreCase("COLORMAP_WARM")) {
            return 0;
        }
        if (s.equalsIgnoreCase("COLORMAP_COOL")) {
            return 1;
        }
        if (s.equalsIgnoreCase("COLORMAP_THERMAL")) {
            return 2;
        }
        if (s.equalsIgnoreCase("COLORMAP_RAINBOW")) {
            return 3;
        }
        if (s.equalsIgnoreCase("COLORMAP_GRAYSCALE")) {
            return 4;
        }
        if (s.equalsIgnoreCase("COLORMAP_USERDEFINED")) {
            return 5;
        }
        return 0;
    }

    private boolean toBoolean(String value) {
        boolean b = false;
        if (value == null || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("")) {
            b = true;
        }
        return b;
    }
}

