package org.lsst.ccs.subsystem.teststand.states;

/**
 *  Position of Thorlabs 102C or 212C filter wheel
 * 
 * @author Al Eisner
 */
public enum ThorlabsFWState {

    POSITION_01( 1),
    POSITION_02( 2),
    POSITION_03( 3),
    POSITION_04( 4),
    POSITION_05( 5),
    POSITION_06( 6),
    POSITION_07( 7),
    POSITION_08( 8),
    POSITION_09( 9),
    POSITION_10(10),
    POSITION_11(11),
    POSITION_12(12), ;

    private int position;

    ThorlabsFWState(int position) {
        this.position = position;
    }

    public static ThorlabsFWState getEnum(int position) {
        String name = "POSITION_" + String.format("%02d", position);
        return valueOf(name);
    }
}
