/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class TSConfig
implements Serializable {
    public static final String[] COMPONENT_NAMES = new String[]{"IDLE", "READY", "TEST", "ACQ1", "WARM"};
    public static int MAXSTATES = operating_states.values().length;
    private int cfgstate = 0;
    private double[] biasVAcq = new double[MAXSTATES];
    private double[] cryoTAcq = new double[MAXSTATES];
    private double[] vacPAcq = new double[MAXSTATES];
    private double[] lambdaAcq = new double[MAXSTATES];
    private String[] filter_names;
    private double[] filter_edges = new double[6];
    private String srctype;
    private String monotype;
    private String pdtype;
    private String biastype;
    private int pdcnt = 0;
    private double pdnplc = 1.0;
    private int biason;
    private double[] minLmpPwr = new double[MAXSTATES];
    private double[] cryoTAcqTol = new double[MAXSTATES];
    private String configFile;

    public TSConfig() {
    }

    public TSConfig(double biasVAcq, double cryoTAcq, double cryoTAcqTol, double vacPAcq, double lambdaAcq, double minLmpPwr) {
        this.update(biasVAcq, cryoTAcq, cryoTAcqTol, vacPAcq, lambdaAcq, minLmpPwr);
    }

    public void update(double biasVAcq, double cryoTAcq, double cryoTAcqTol, double vacPAcq, double lambdaAcq, double minLmpPwr) {
        this.update(this.cfgstate, biasVAcq, cryoTAcq, cryoTAcqTol, vacPAcq, lambdaAcq, minLmpPwr);
    }

    public void update(int istate, double biasVAcq, double cryoTAcq, double cryoTAcqTol, double vacPAcq, double lambdaAcq, double minLmpPwr) {
        this.biasVAcq[istate] = biasVAcq;
        this.cryoTAcq[istate] = cryoTAcq;
        this.cryoTAcqTol[istate] = cryoTAcqTol;
        this.vacPAcq[istate] = vacPAcq;
        this.lambdaAcq[istate] = lambdaAcq;
        this.minLmpPwr[istate] = minLmpPwr;
    }

    public double getBiasVAcq() {
        return this.biasVAcq[this.cfgstate];
    }

    public double getCryoTAcq() {
        return this.cryoTAcq[this.cfgstate];
    }

    public void setCryoTAcq(double cryoTAcq, int istate) {
        this.cryoTAcq[istate] = cryoTAcq;
    }

    public double getVacPAcq() {
        return this.vacPAcq[this.cfgstate];
    }

    public double getLambdaAcq() {
        return this.lambdaAcq[this.cfgstate];
    }

    public String[] getFilters() {
        return this.filter_names;
    }

    public String getSrcType() {
        return this.srctype;
    }

    public String getMonoType() {
        return this.monotype;
    }

    public String getPDType() {
        return this.pdtype;
    }

    public String getBIASType() {
        return this.biastype;
    }

    public int getPDcnt() {
        return this.pdcnt;
    }

    public void setPDcnt(int pdcnt) {
        this.pdcnt = pdcnt;
    }

    public double getPDnplc() {
        return this.pdnplc;
    }

    public void setPDnplc(double pdnplc) {
        this.pdnplc = pdnplc;
    }

    public int getBiason() {
        return this.biason;
    }

    public void setBiason(int biason) {
        this.biason = biason;
    }

    public double getMinLmpPwr() {
        return this.minLmpPwr[this.cfgstate];
    }

    public void setCryoTAcqTol(double cryoTAcqTol) {
        this.cryoTAcqTol[this.cfgstate] = cryoTAcqTol;
    }

    public double getCryoTAcqTol() {
        return this.cryoTAcqTol[this.cfgstate];
    }

    public void setCfgState(int cfgstate) {
        this.cfgstate = cfgstate;
    }

    public int getCfgstate() {
        return this.cfgstate;
    }

    public double[] getFilter_edges() {
        return this.filter_edges;
    }

    public void setFilter_edges(double[] filter_edges) {
        this.filter_edges = filter_edges;
    }

    public void setBiasVAcq(double biasVAcq) {
        this.biasVAcq[this.cfgstate] = biasVAcq;
    }

    public void setBiasVAcq(double biasVAcq, int istate) {
        this.biasVAcq[istate] = biasVAcq;
    }

    public void setCryoTAcq(double cryoTAcq) {
        this.cryoTAcq[this.cfgstate] = cryoTAcq;
    }

    public void setVacPAcq(double vacPAcq) {
        this.vacPAcq[this.cfgstate] = vacPAcq;
    }

    public void setLambdaAcq(double lambdaAcq) {
        this.lambdaAcq[this.cfgstate] = lambdaAcq;
    }

    public void setFilter_names(String[] filter_names) {
        this.filter_names = filter_names;
    }

    public void setSrctype(String srctype) {
        this.srctype = srctype;
    }

    public void setMonotype(String monotype) {
        this.monotype = monotype;
    }

    public void setPdtype(String pdtype) {
        this.pdtype = pdtype;
    }

    public void setBiastype(String biastype) {
        this.biastype = biastype;
    }

    public void setMinLmpPwr(double minLmpPwr) {
        this.minLmpPwr[this.cfgstate] = minLmpPwr;
    }

    public String toString() {
        String line = "";
        for (operating_states stat : operating_states.values()) {
            int icfg = stat.ordinal();
            line = line + "state=" + stat.name() + ", biasVAcq=" + this.biasVAcq[icfg] + ", cryoTAcq=" + this.cryoTAcq[icfg] + ", vacPAcq=" + this.vacPAcq[icfg] + ", lambdaAcq=" + this.lambdaAcq[icfg];
        }
        line = line + ", filter_names=" + this.filter_names + ", srctype=" + this.srctype + ", monotype=" + this.monotype + ", pdtype=" + this.pdtype + ", biastype=" + this.biastype;
        return line;
    }

    public void TSConfigWriter_deprecated(Logger log) {
        block12: {
            log.error((Object)"TSConfigWriter called");
            log.error((Object)("Resource directory path = " + BootstrapResourceUtils.getTopUserResourceDirectory()));
            String fullpath = BootstrapResourceUtils.getTopUserResourceDirectory() + this.configFile;
            log.error((Object)("Full config file path is: " + fullpath));
            FileWriter fstream = null;
            File cfgFl = new File(this.configFile);
            try {
                if (cfgFl.exists()) {
                    cfgFl.delete();
                }
                cfgFl.createNewFile();
                try {
                    fstream = new FileWriter(cfgFl);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (fstream == null) break block12;
                log.error((Object)"writing config file");
                BufferedWriter out = new BufferedWriter(fstream);
                String line = null;
                for (operating_states wstate : operating_states.values()) {
                    int icfg = wstate.ordinal();
                    line = "state " + wstate.name() + "\nbias " + this.biasVAcq[icfg] + "\ncryo " + this.cryoTAcq[icfg] + "\nvac " + this.vacPAcq[icfg] + "\nlambda " + this.lambdaAcq[icfg] + "\nminlmppwr " + this.minLmpPwr[icfg] + "\ncryotol " + this.cryoTAcqTol[icfg] + "\n";
                    try {
                        out.write(line);
                        out.newLine();
                        out.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                line = "filters " + this.filter_names[0] + ":" + this.filter_names[1] + ":" + this.filter_names[2] + ":" + this.filter_names[3] + ":" + this.filter_names[4] + ":" + this.filter_names[5] + "\nsrctype " + this.srctype + "\nmonotype " + this.monotype + "\npdtype " + this.pdtype + "\nbiastype " + this.biastype + "\n";
                try {
                    out.write(line);
                    out.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    out.close();
                }
                catch (IOException e) {
                    log.error((Object)"Failed to close config file!");
                }
            }
            catch (IOException ee) {
                log.error((Object)"Failed to remove and create a new cfg file.!");
            }
        }
    }

    public void TSConfigReader_deprecated(Logger log) {
        log.error((Object)"TSConfigReader called");
        InputStream fstream = BootstrapResourceUtils.getBootstrapResource((String)this.configFile);
        if (fstream != null) {
            String line = null;
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(fstream));
                int istate = 0;
                block34: while (in.ready()) {
                    line = in.readLine();
                    switch (line.split(" ")[0]) {
                        case "state": {
                            istate = operating_states.valueOf(line.split(" ")[1]).ordinal();
                            break;
                        }
                        case "bias": {
                            this.biasVAcq[istate] = Double.valueOf(line.split(" ")[1]);
                            System.out.println("State (" + (Object)((Object)operating_states.values()[istate]) + "): default acquisition bias setting is " + this.biasVAcq[istate]);
                            break;
                        }
                        case "cryo": {
                            this.cryoTAcq[istate] = Double.valueOf(line.split(" ")[1]);
                            System.out.println("State (" + (Object)((Object)operating_states.values()[istate]) + "): default acquisition temperature setting is " + this.cryoTAcq[istate]);
                            break;
                        }
                        case "vac": {
                            this.vacPAcq[istate] = Double.valueOf(line.split(" ")[1]);
                            System.out.println("State (" + (Object)((Object)operating_states.values()[istate]) + "): default acquisition vacuum setting is " + this.vacPAcq[istate]);
                            break;
                        }
                        case "lambda": {
                            this.lambdaAcq[istate] = Double.valueOf(line.split(" ")[1]);
                            System.out.println("State (" + (Object)((Object)operating_states.values()[istate]) + "): default acquisition lambda setting is " + this.lambdaAcq[istate]);
                            break;
                        }
                        case "filters": {
                            this.filter_names = line.substring(line.indexOf(" ")).split(":");
                            break;
                        }
                        case "filteredges": {
                            String[] fedgstr = line.substring(line.indexOf(" ")).split(":");
                            for (int i = 0; i < fedgstr.length; ++i) {
                                this.filter_edges[i] = Double.valueOf(fedgstr[i]);
                            }
                            continue block34;
                        }
                        case "srctype": {
                            this.srctype = line.split(" ")[1];
                            break;
                        }
                        case "monotype": {
                            this.monotype = line.split(" ")[1];
                            break;
                        }
                        case "pdtype": {
                            this.pdtype = line.split(" ")[1];
                            break;
                        }
                        case "biastype": {
                            this.biastype = line.split(" ")[1];
                            break;
                        }
                        case "minlmpcurr": {
                            this.minLmpPwr[istate] = Double.valueOf(line.split(" ")[1]);
                            break;
                        }
                        case "minlmppwr": {
                            this.minLmpPwr[istate] = Double.valueOf(line.split(" ")[1]);
                            break;
                        }
                        case "cryotol": {
                            this.cryoTAcqTol[istate] = Double.valueOf(line.split(" ")[1]);
                            break;
                        }
                        default: {
                            System.out.println("Ignored entry: line = " + line);
                        }
                    }
                }
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum EVENT_ID {
        BIAS,
        CRYO,
        VAC,
        PD,
        LMP;

    }

    public static enum operating_states {
        IDLE,
        READY,
        TEST,
        ACQ1,
        WARM,
        ACQ3,
        ACQ4,
        ACQ5,
        EXPERT;

    }
}

