/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.DummyChannel;
import org.lsst.ccs.subsystem.shutter.statemachine.InSync;
import org.lsst.ccs.subsystem.shutter.statemachine.TopContext;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class InSyncTest {
    @Test
    public void testTransitions() throws InterruptedException {
        Actions mockActions = (Actions)Mockito.mock(Actions.class);
        TopContext mockContext = (TopContext)Mockito.mock(TopContext.class);
        InSync sm = new InSync(mockActions, mockContext);
        Mockito.when((Object)mockContext.getPLCEnabled()).thenReturn((Object)true);
        DummyChannel chan = new DummyChannel();
        sm.init();
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.never())).setPhysicalState((PhysicalState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).publishEnableStatus(true);
        ((TopContext)Mockito.verify((Object)mockContext, (VerificationMode)Mockito.times((int)1))).getPLCEnabled();
        sm.disable(chan);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setSoftwareState(SoftwareState.DISABLED);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).setPhysicalState(PhysicalState.OTHER);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)1))).publishEnableStatus(false);
        Assertions.assertNull((Object)sm.getEnabledState().getState(), (String)"Enabled didn't forget its current state when exited.");
        sm.enable(chan);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.STILL);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)3))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        sm.disable(chan);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setSoftwareState(SoftwareState.DISABLED);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)4))).setSoftwareState((SoftwareState)ArgumentMatchers.any());
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).setPhysicalState(PhysicalState.OTHER);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).publishEnableStatus(true);
        ((Actions)Mockito.verify((Object)mockActions, (VerificationMode)Mockito.times((int)2))).publishEnableStatus(false);
        Assertions.assertNull((Object)sm.getEnabledState().getState(), (String)"Enabled didn't forget its current state when exited.");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockActions});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockContext});
    }
}

