/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.shutter.PLCEventSubmitter;
import org.lsst.ccs.subsystem.shutter.PLCVariableDictionary;
import org.lsst.ccs.subsystem.shutter.plc.Ignored;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisAbsolutePLC;
import org.lsst.ccs.subsystem.shutter.plc.MsgToCCS;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.plc.Reset;

public class PLCVariableDictionaryTest {
    @Test
    public void testAddMsgToPLC() {
        Class<MoveAxisAbsolutePLC> klass = MoveAxisAbsolutePLC.class;
        Function<ByteBuffer, MsgToPLC> ackDecoder = MoveAxisAbsolutePLC::new;
        PLCVariableDictionary instance = new PLCVariableDictionary();
        Assertions.assertThrows(NullPointerException.class, () -> instance.addMsgToPLC(null, ackDecoder));
        Assertions.assertThrows(NullPointerException.class, () -> instance.addMsgToPLC(klass, null));
        Assertions.assertNull((Object)instance.getInVariable(klass));
        Assertions.assertNull((Object)instance.getInVariable("ackMoveAxisAbsolute"));
        instance.addMsgToPLC(klass, ackDecoder);
        PLCVariableDictionary.InVariable var = instance.getInVariable(klass);
        Assertions.assertNotNull((Object)var);
        Assertions.assertEquals(klass, (Object)var.klass);
        Assertions.assertEquals(ackDecoder, (Object)var.ackDecoder);
        Assertions.assertEquals((Object)"inMoveAxisAbsolute", (Object)var.varName);
        Assertions.assertEquals((Object)"ackMoveAxisAbsolute", (Object)var.ackName);
    }

    @Test
    public void testAddMsgFromPLC() {
        Class<Ignored> klass = Ignored.class;
        Function<ByteBuffer, MsgToCCS> decoder = Ignored::new;
        PLCEventSubmitter submitter = (chan, msg) -> {};
        PLCVariableDictionary instance = new PLCVariableDictionary();
        Assertions.assertThrows(NullPointerException.class, () -> instance.addMsgToCCS(null, decoder, submitter));
        Assertions.assertThrows(NullPointerException.class, () -> instance.addMsgToCCS(klass, null, submitter));
        Assertions.assertThrows(NullPointerException.class, () -> instance.addMsgToCCS(klass, decoder, null));
        Assertions.assertNull((Object)instance.getOutVariable("outIgnored"));
        instance.addMsgToCCS(klass, decoder, submitter);
        PLCVariableDictionary.OutVariable var = instance.getOutVariable("outIgnored");
        Assertions.assertNotNull((Object)var);
        Assertions.assertEquals(klass, (Object)var.klass);
        Assertions.assertEquals(decoder, (Object)var.decoder);
        Assertions.assertEquals((Object)"outIgnored", (Object)var.varName);
        Assertions.assertEquals((Object)submitter, (Object)var.submitter);
    }

    @Test
    public void testGetAllInVariables() {
        PLCVariableDictionary instance = new PLCVariableDictionary();
        List result = instance.getAllInVariables();
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)0, (int)result.size());
        Class<Reset> klass = Reset.class;
        Function<ByteBuffer, MsgToPLC> decoder = Reset::new;
        instance.addMsgToPLC(klass, decoder);
        result = instance.getAllInVariables();
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)"inReset", (Object)((PLCVariableDictionary.InVariable)result.get((int)0)).varName);
        Assertions.assertEquals((Object)"ackReset", (Object)((PLCVariableDictionary.InVariable)result.get((int)0)).ackName);
        Assertions.assertEquals(klass, (Object)((PLCVariableDictionary.InVariable)result.get((int)0)).klass);
        Assertions.assertEquals(decoder, (Object)((PLCVariableDictionary.InVariable)result.get((int)0)).ackDecoder);
        Assertions.assertThrows(IllegalArgumentException.class, () -> instance.addMsgToPLC(klass, decoder));
    }

    @Test
    public void testGetAllOutVariables() {
        PLCVariableDictionary instance = new PLCVariableDictionary();
        List result = instance.getAllOutVariables();
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)0, (int)result.size());
        Function<ByteBuffer, MsgToCCS> decoder = Ignored::new;
        PLCEventSubmitter submitter = (chan, msg) -> {};
        instance.addMsgToCCS(Ignored.class, decoder, submitter);
        List vlist = instance.getAllOutVariables();
        Assertions.assertNotNull((Object)vlist);
        Assertions.assertEquals((int)1, (int)vlist.size());
        Assertions.assertEquals(Ignored.class, (Object)((PLCVariableDictionary.OutVariable)vlist.get((int)0)).klass);
        Assertions.assertEquals((Object)"outIgnored", (Object)((PLCVariableDictionary.OutVariable)vlist.get((int)0)).varName);
        Assertions.assertEquals(decoder, (Object)((PLCVariableDictionary.OutVariable)vlist.get((int)0)).decoder);
        Assertions.assertEquals((Object)submitter, (Object)((PLCVariableDictionary.OutVariable)vlist.get((int)0)).submitter);
        Assertions.assertThrows(IllegalArgumentException.class, () -> instance.addMsgToCCS(Ignored.class, decoder, submitter));
    }

    @Test
    public void testGetInVariable_Class() {
        Class klass = null;
        PLCVariableDictionary instance = new PLCVariableDictionary();
        Assertions.assertThrows(NullPointerException.class, () -> instance.getInVariable(klass));
        Assertions.assertNull((Object)instance.getInVariable(Reset.class));
    }

    @Test
    public void testGetInVariable_String() {
        String ackName = null;
        PLCVariableDictionary instance = new PLCVariableDictionary();
        Assertions.assertThrows(NullPointerException.class, () -> instance.getInVariable(ackName));
        Assertions.assertNull((Object)instance.getInVariable("foo"));
    }

    @Test
    public void testGetOutVariable() {
        String varName = null;
        PLCVariableDictionary instance = new PLCVariableDictionary();
        Assertions.assertThrows(NullPointerException.class, () -> instance.getOutVariable(varName));
        Assertions.assertNull((Object)instance.getOutVariable("foo"));
    }
}

