package org.lsst.ccs.subsystem.shutter.statemachine;

/**
 * A message-sending interface between two tasks.
 * @author tether
 */
public interface Channel<T> {

    /**
     * Write a message to the channel, waiting indefinitely for the message to be stored or read.
     * @param msg The message.
     * @throws InterruptedException
     */
    void write(T msg) throws InterruptedException;

    /**
     * Read a message from a channel, waiting indefinitely for a message to become available.
     * @return The message.
     * @throws InterruptedException
     */
    T read() throws InterruptedException;

}
