package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.logEntry;
import static org.lsst.ccs.subsystem.shutter.statemachine.Logging.logEvent;
import static org.lsst.ccs.subsystem.shutter.statemachine.PromptReply.ACCEPTED;

/**
 * The maint-mode state in which the shutter is performing Hall calibrations on its axes. Thread-safe.
 * @author tether
 */
class Calibrating extends SimpleState<Maint> {
    private static final Logger LOG = Logger.getLogger(Calibrating.class.getName());

    /** Saves the context for this state.
     * @param context The context.
     * @throws NullPointerException if the context is null.
     */
    public Calibrating(final Maint context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        logEntry(this);
        getContext().getActions().setSoftwareState(SoftwareState.CALIBRATING);
        getContext().getActions().setPhysicalState(PhysicalState.ENG_MOVING);
    }

    @Override
    public void brakePowerLoss(final Channel<EventReply> chan) throws InterruptedException {
        logEvent(this);
        chan.write(ACCEPTED);
        getContext().getActions().signalAReset();
    }

    @Override
    public void calibDone(final Channel<EventReply> chan, final CalibDone calibResults) throws InterruptedException {
        logEvent(this);
        chan.write(ACCEPTED);
        final Maint ctx = getContext();
        ctx.makeTransition(ctx.getStillState(),
                           () -> {ctx.getActions().setPhysicalState(PhysicalState.OTHER);
                                  ctx.getActions().saveCalib(calibResults);});
    }

}
