package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;

/**
 * The base class for all messages sent from the PLC task to CCS. It supplies a sequence number field
 * that PLC code uses to ensure that ADS notifications get generated when needed.
 * @author tether
 */
public abstract class MsgToCCS extends PLCMsg {

    private final int sequence;

    /**
     * Saves the sequence number.
     * @param sequence The sequence number.
     */
    public MsgToCCS(final int sequence) {this.sequence = sequence;}

    /**
     * Gets the sequence number from a byte buffer.
     * @param data The data buffer.
     */
    public MsgToCCS(final ByteBuffer data) {super(data); this.sequence = data.getInt();}

    /**
     * Puts the sequence number into a data buffer.
     * @param data The buffer.
     */
    @Override
    public void encode(final ByteBuffer data) {super.encode(data); data.putInt(sequence);}

    @Override
    public String toString() {return "MsgToCCS{" + super.toString() + " sequence=" + sequence + "}";}
}
