package org.lsst.ccs.subsystem.shutter.plc;

import org.lsst.ccs.subsystem.shutter.common.Axis;
import java.nio.ByteBuffer;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;

/**
 * Signals the PLC to move one axis to a given coordinate.
 * @author tether
 */
public class MoveAxisAbsolutePLC extends MsgToPLC {
    
    private final MoveAxisAbsolute msg;

    /**
     * Constructs using an instance of the motorplatform message.
     * @param msg Holds the message-specific data.
     */
    public MoveAxisAbsolutePLC(final MoveAxisAbsolute msg) {
        this.msg = msg;
    }

    /**
     * Reads and converts the PLC form of the message.
     * @param data Holds the PLC message data.
     */
    public MoveAxisAbsolutePLC(final ByteBuffer data) {
        super(data);
        final int index = data.getInt();
        final double pos = data.getDouble();
        final double speed = data.getDouble();
        this.msg = new MoveAxisAbsolute(Axis.fromAxisNum(index).getName(), pos, speed);
    }

    @Override
    public void encode(final ByteBuffer data) {
        super.encode(data);
        data.putInt(Axis.fromName(msg.getAxisName()).getPLCAxisNum());
        data.putDouble(msg.getPosition());
        data.putDouble(msg.getSpeed());
    }

    public MoveAxisAbsolute getStatusBusMessage() {return msg;}

    @Override
    public String toString() {
        return "MoveAxisAbsolutePLC{" + super.toString() +
               " axis=" + msg.getAxisName() +
               ", position=" + msg.getPosition() +
               ", speed=" + msg.getSpeed() + '}';
    }

}
