package org.lsst.ccs.subsystem.shutter.plc;

import org.lsst.ccs.subsystem.shutter.common.Axis;
import java.nio.ByteBuffer;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;

/**
 * Signals the PLC to home one of the axes.
 * @author tether
 */
public class HomeAxisPLC extends MsgToPLC {

    private final HomeAxis msg;

    /**
     * Constructs using an instance of the motorplatform message.
     * @param msg Holds the message-specific data.
     */
    public HomeAxisPLC(final HomeAxis msg) {
        this.msg = msg;
    }

    /**
     * Reads and converts the PLC form of the message.
     * @param data Holds the PLC message data.
     */
    public HomeAxisPLC(final ByteBuffer data) {
        super(data);
        final String name = Axis.fromAxisNum(data.getInt()).getName();
        this.msg = new HomeAxis(name);
    }

    @Override
    public void encode(final ByteBuffer data) {
        super.encode(data);
        data.putInt(Axis.fromName(msg.getAxisName()).getPLCAxisNum());
    }

    public final String getAxisName() {return msg.getAxisName();}

    @Override
    public String toString() {
        return "HomeAxisPLC{" + super.toString() + " axis=" + msg.getAxisName() + '}';
    }

}
