package org.lsst.ccs.subsystem.shutter.plc;

import org.lsst.ccs.subsystem.shutter.common.Axis;
import java.nio.ByteBuffer;
import static org.lsst.ccs.subsystem.shutter.plc.Tools.getBoolean;
import static org.lsst.ccs.subsystem.shutter.plc.Tools.putBoolean;

/**
 * Signals the PLC to engage or release a brake.
 * @author tether
 */
public class ChangeBrakeState extends MsgToPLC {
    /** Possible brake states. */
    public static enum State {
        ENGAGED,
        RELEASED;
    }
    
    private final Axis axis;
    private final State state;

    /**
     * Constructs from the field values.
     * @param axis Identifies the axis.
     * @param state The desired brake state.
     */
    public ChangeBrakeState(final Axis axis, final State state) {
        this.axis = axis;
        this.state = state;
    }

    /**
     * Reads and converts the PLC form of the message.
     * @param data The PLC message data buffer.
     */
    public ChangeBrakeState(final ByteBuffer data) {
        super(data);
        this.axis = Axis.fromAxisNum(data.getInt());
        this.state = getBoolean(data) ? State.ENGAGED : State.RELEASED;
    }
    
    @Override
    public void encode(final ByteBuffer data) {
        super.encode(data);
        data.putInt(axis.getPLCAxisNum());
        putBoolean(data, state == State.ENGAGED);
    }
    
    public State getState() {return state;}
    
    public Axis getAxis() {return axis;}

    @Override
    public String toString() {
        return "ChangeBrakeState{" +
               super.toString() +
               " axis=" + axis +
               ", state=" + state + '}';
    }
    
}
