package org.lsst.ccs.subsystem.shutter;

import org.lsst.ccs.subsystem.shutter.plc.MsgToCCS;
import org.lsst.ccs.subsystem.shutter.statemachine.Channel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;

@FunctionalInterface
/**
 * A functional interface for objects that submit a PLC event to the internal state machine.
 * @author tether
 */
public interface PLCEventSubmitter {

    /**
     *
     * @param replyChan The channel from which to receive the state machine's reply. May not be null.
     * @param msg the message from the PLC that is to be used as the argument to the event method called.
     * Null if there was no such message.
     * @throws InterruptedException if the submission or the reading of the reply were interrupted.
     */
    void submit(Channel<EventReply> replyChan, MsgToCCS msg) throws InterruptedException;
}
