/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class Measurement
implements Serializable {
    private static final long serialVersionUID = 489243324353342L;
    private final CCSTimeStamp ccsTimestamp;
    private final double value;

    public Measurement(double value, CCSTimeStamp ccsTimestamp) {
        this.value = value;
        this.ccsTimestamp = ccsTimestamp;
    }

    public Measurement(Measurement measurement) {
        if (measurement == null) {
            this.value = Double.NaN;
            this.ccsTimestamp = null;
        } else {
            this.value = measurement.value;
            this.ccsTimestamp = measurement.ccsTimestamp;
        }
    }

    public CCSTimeStamp getCCSTimestamp() {
        return this.ccsTimestamp;
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return "Value " + this.value + " (" + this.ccsTimestamp + ")";
    }
}

