/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import data.DiscretePlotData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.gui.EncoderPlotData;
import org.lsst.ccs.subsystem.shutter.gui.HallPlotData;
import org.lsst.ccs.subsystem.shutter.gui.PredictionPlotData;
import plotter.Axis;
import plotter.AxisModel;
import plotter.ContinuousAxisModel;
import plotter.DataArea;
import plotter.DataOverlay;
import plotter.DataPointChartOverlay;
import plotter.LineChartOverlay;
import plotter.LinearAxisModel;
import plotter.PlotLayout;

public final class TrajectoryDisplay
extends JPanel {
    private static final int DISPLAY_WIDTH = 500;
    private static final int DISPLAY_HEIGHT = 300;
    private static final double DEFAULT_TIME_PERIOD = 5.0;
    private static final List<Color> plotColors = Arrays.asList(Color.RED, Color.BLUE, Color.GREEN, Color.YELLOW, Color.BLACK, Color.ORANGE, Color.CYAN, Color.MAGENTA, Color.PINK, Color.GRAY);
    private static final List<Integer> predictedQuantities = Arrays.asList(1, 2, 3);
    private static final List<String> predictedKeys = Arrays.asList("Pred acc", "Pred vel", "Pred pos");
    private final LinearAxisModel timeAxisModel;

    TrajectoryDisplay(Map<ShutterSide, PredictionPlotData> predictionData, Map<ShutterSide, HallPlotData> hallData, Map<ShutterSide, EncoderPlotData> encoderData) {
        super(new BorderLayout());
        JPanel plotPanel = new JPanel((LayoutManager)new PlotLayout());
        plotPanel.setPreferredSize(new Dimension(500, 300));
        LinearAxisModel valueAxisModel = new LinearAxisModel(-1.1, 1.1);
        Axis valueAxis = new Axis((AxisModel)valueAxisModel, Axis.AxisPosition.LEFT);
        this.timeAxisModel = new LinearAxisModel(0.0, 5.0);
        Axis timeAxis = new Axis((AxisModel)this.timeAxisModel, Axis.AxisPosition.BOTTOM);
        DataArea da = new DataArea(timeAxis, valueAxis);
        EnumMap<ShutterSide, KeyPanel> legend = new EnumMap<ShutterSide, KeyPanel>(ShutterSide.class);
        legend.put(ShutterSide.MINUSX, new KeyPanel("-X side"));
        legend.put(ShutterSide.PLUSX, new KeyPanel("+X side"));
        Iterator<Color> colorIt = plotColors.iterator();
        for (ShutterSide side : ShutterSide.values()) {
            predictionData.get(side).addPlotDataListener(this::repaint);
            hallData.get(side).addPlotDataListener(this::repaint);
            encoderData.get(side).addPlotDataListener(this::repaint);
            Iterator<String> keyIt = predictedKeys.iterator();
            for (int what : predictedQuantities) {
                LineChartOverlay overlay = new LineChartOverlay(keyIt.next(), (DiscretePlotData)predictionData.get(side), 0, what, (ContinuousAxisModel)this.timeAxisModel, (ContinuousAxisModel)valueAxisModel);
                overlay.setLineColor(colorIt.next());
                da.add((DataOverlay)overlay);
                ((KeyPanel)legend.get(side)).add(overlay);
            }
            DataPointChartOverlay hallSensors = new DataPointChartOverlay("Hall trans", (DiscretePlotData)hallData.get(side), 0, 1, -1, -1, 2, 2, (ContinuousAxisModel)this.timeAxisModel, (ContinuousAxisModel)valueAxisModel);
            hallSensors.setLineColor(colorIt.next());
            da.add((DataOverlay)hallSensors);
            DataPointChartOverlay encoderPos = new DataPointChartOverlay("Enc pos", (DiscretePlotData)encoderData.get(side), 0, 1, -1, -1, 2, 2, (ContinuousAxisModel)this.timeAxisModel, (ContinuousAxisModel)valueAxisModel);
            encoderPos.setLineColor(Color.BLACK);
            da.add((DataOverlay)encoderPos);
        }
        plotPanel.add((Component)valueAxis);
        plotPanel.add((Component)timeAxis);
        plotPanel.add((Component)da);
        JPanel bothLegends = new JPanel(new BorderLayout());
        bothLegends.add("North", (Component)legend.get(ShutterSide.MINUSX));
        bothLegends.add("South", (Component)legend.get(ShutterSide.PLUSX));
        bothLegends.setBorder(BorderFactory.createTitledBorder("Legend"));
        this.add((Component)plotPanel, "Center");
        this.add((Component)bothLegends, "South");
    }

    void setTimePeriod(float maxTime) {
        this.timeAxisModel.setMax((double)maxTime);
        this.repaint();
    }

    private static final class KeyPanel
    extends JPanel {
        KeyPanel(String title) {
            super(new FlowLayout());
            this.add(new JLabel(title));
        }

        private void add(LineChartOverlay overlay) {
            JLabel label = new JLabel(overlay.getTitle());
            label.setIcon(overlay.getKeyIcon());
            this.add(label);
        }

        private void add(DataPointChartOverlay overlay) {
            JLabel label = new JLabel(overlay.getTitle());
            label.setIcon(overlay.getKeyIcon());
            this.add(label);
        }
    }
}

