/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.Transient;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.localdb.configdb.model.BaseDescription;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameter;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;

@Entity
@Immutable
public class Description
implements Serializable {
    private static final long serialVersionUID = 1931407188397328132L;
    private long id;
    private BaseDescription baseDescription;
    private Map<ParameterPath, ConfigurationParameter> finalValues = new HashMap<ParameterPath, ConfigurationParameter>();

    protected Description() {
    }

    public Description(BaseDescription desc) {
        this.baseDescription = desc;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public long getId() {
        return this.id;
    }

    void setId(long id) {
        this.id = id;
    }

    @Transient
    public AgentDesc getAgentDesc() {
        return this.baseDescription.getAgentDesc();
    }

    public void setBaseDescription(BaseDescription desc) {
        this.baseDescription = desc;
    }

    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    public BaseDescription getBaseDescription() {
        return this.baseDescription;
    }

    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.ALL}, fetch=FetchType.EAGER)
    @MapKey(name="parameterPath")
    public Map<ParameterPath, ConfigurationParameter> getFinalValues() {
        return this.finalValues;
    }

    void setFinalValues(Map<ParameterPath, ConfigurationParameter> finalValues) {
        this.finalValues = finalValues;
    }

    public String toString() {
        return "{id=" + this.getId() + ";descriptions=" + this.getFinalValues() + '}';
    }
}

