/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.lsst.ccs.command.AmbiguousCommandException;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandArgumentTypeException;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CompositeCommandDictionary;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryUtils;

public class CompositeCommandSet
implements CommandSet {
    private final Set<CommandSet> commands = new CopyOnWriteArraySet<CommandSet>();
    private final CompositeCommandDictionary dict = new CompositeCommandDictionary();

    public void add(CommandSet set) {
        for (DictionaryCommand newCommand : set.getCommandDictionary()) {
            if (!DictionaryUtils.containsDictionaryCommand(this.dict, newCommand)) continue;
            throw new AmbiguousCommandException(String.format("Ambiguous command with name %s and %d arguments ", newCommand.getCommandName(), newCommand.getArguments().length));
        }
        this.commands.add(set);
        this.dict.add(set.getCommandDictionary());
    }

    public void remove(CommandSet set) {
        this.commands.remove(set);
        this.dict.remove(set.getCommandDictionary());
    }

    void clear() {
        this.commands.clear();
        this.dict.clear();
    }

    public Set<CommandSet> getCommandSets() {
        return Collections.unmodifiableSet(this.commands);
    }

    @Override
    public Dictionary getCommandDictionary() {
        return this.dict;
    }

    @Override
    public Object invoke(BasicCommand command) throws CommandInvocationException, CommandArgumentMatchException, CommandArgumentTypeException {
        ArrayList<CommandArgumentMatchException> exceptions = new ArrayList<CommandArgumentMatchException>();
        for (CommandSet set : this.commands) {
            try {
                if (!set.getCommandDictionary().containsCommand(command)) continue;
                return set.invoke(command);
            }
            catch (CommandArgumentMatchException ex) {
                exceptions.add(ex);
            }
        }
        CommandArgumentMatchException.throwExceptionIfNeeded(exceptions);
        throw new CommandInvocationException("Error: No handler found for command %s with %d arguments", command.getCommand(), command.getArgumentCount());
    }
}

