/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.time.Duration;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.EmbeddedObjectDeserializationException;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public abstract class BusMessage<T extends Serializable, D>
implements Serializable {
    private static final long serialVersionUID = -51335689636909L;
    private final SerializationUtils<T> serializationUtils = new SerializationUtils();
    private D encodedData;
    private byte[] serializedObject;
    private transient T deserializedObject = null;
    private final transient T embeddedObject;
    private String className = "";
    private AgentInfo originAgentInfo;
    private volatile transient CCSTimeStamp deserializationTimeStamp;
    private volatile transient CCSTimeStamp doneDeserializationTimeStamp;
    private volatile CCSTimeStamp serializationTimeStamp;
    private volatile transient CCSTimeStamp doneSerializationTimeStamp;
    private final CCSTimeStamp ccsTimeStamp = CCSTimeStamp.currentTime();

    public BusMessage(Class clazz, byte[] ser) {
        this.embeddedObject = null;
        this.className = clazz.getName();
        this.encodedData = null;
        this.serializedObject = ser;
    }

    public BusMessage(T obj) {
        this.embeddedObject = obj;
        if (obj != null) {
            this.className = obj.getClass().getName();
        } else {
            this.encodedData = null;
            this.serializedObject = null;
        }
    }

    protected abstract D encodeObject(T var1);

    public String getClassName() {
        return this.className;
    }

    public D getEncodedData() {
        if (this.embeddedObject != null) {
            return this.encodeObject(this.embeddedObject);
        }
        return this.encodedData;
    }

    public T getObject() {
        if (this.embeddedObject != null) {
            return this.embeddedObject;
        }
        if (this.serializedObject == null) {
            return null;
        }
        if (this.deserializedObject == null) {
            this.deserializedObject = this.serializationUtils.deserialize(this.serializedObject);
        }
        return this.deserializedObject;
    }

    public AgentInfo getOriginAgentInfo() {
        return this.originAgentInfo;
    }

    public final void setOriginAgentInfo(AgentInfo agent) {
        if (this.originAgentInfo != null) {
            throw new RuntimeException("The setOriginAgentInfo method on BusMessage must be invoked only once!!!");
        }
        this.originAgentInfo = agent;
    }

    public CCSTimeStamp getCCSTimeStamp() {
        return this.ccsTimeStamp;
    }

    public String toString() {
        D ed;
        StringBuilder sb = new StringBuilder(1);
        String sOrigin = this.getOriginAgentInfo() != null ? this.getOriginAgentInfo().getName() : "notSet";
        sb.append(this.getClass().getSimpleName()).append(" { origin=").append(sOrigin).append("\n");
        sb.append(" creation timestamp=").append(this.getCCSTimeStamp()).append("\n");
        if (!this.className.isEmpty()) {
            sb.append(" className=").append(this.className).append("\n");
        }
        if ((ed = this.getEncodedData()) != null) {
            sb.append(" encodedData:\n").append(ed).append("\n");
        }
        return sb.toString();
    }

    private void prepareForSendingOverTheBuses() throws IOException {
        if (this.embeddedObject != null) {
            this.encodedData = this.encodeObject(this.embeddedObject);
            this.serializedObject = this.serializationUtils.serialize(this.embeddedObject);
        }
        this.serializationTimeStamp = CCSTimeStamp.currentTime();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.prepareForSendingOverTheBuses();
        out.defaultWriteObject();
        out.writeObject(CCSTimeStamp.currentTime());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.deserializationTimeStamp = CCSTimeStamp.currentTime();
        in.defaultReadObject();
        try {
            this.doneSerializationTimeStamp = (CCSTimeStamp)in.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.doneDeserializationTimeStamp = CCSTimeStamp.currentTime();
    }

    public Duration getTransferDuration() {
        if (this.doneSerializationTimeStamp != null && this.deserializationTimeStamp != null) {
            return Duration.between(this.doneSerializationTimeStamp.getUTCInstant(), this.deserializationTimeStamp.getUTCInstant());
        }
        return null;
    }

    public CCSTimeStamp getDoneDeSerializationTime() {
        return this.deserializationTimeStamp;
    }

    public CCSTimeStamp getSerializationTime() {
        return this.serializationTimeStamp;
    }

    public Duration getSerializationDuration() {
        if (this.serializationTimeStamp != null && this.doneSerializationTimeStamp != null) {
            return Duration.between(this.serializationTimeStamp.getUTCInstant(), this.doneSerializationTimeStamp.getUTCInstant());
        }
        return null;
    }

    public Duration getDeserializationDuration() {
        if (this.deserializationTimeStamp != null && this.doneDeserializationTimeStamp != null) {
            return Duration.between(this.deserializationTimeStamp.getUTCInstant(), this.doneDeserializationTimeStamp.getUTCInstant());
        }
        return null;
    }

    private class SerializationUtils<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = -1377509787159869583L;

        private SerializationUtils() {
        }

        public byte[] serialize(T obj) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            return bos.toByteArray();
        }

        public T deserialize(byte[] bytes) throws EmbeddedObjectDeserializationException {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            try {
                ObjectInputStream ois = new ObjectInputStream(bis);
                return (T)((Serializable)ois.readObject());
            }
            catch (ClassNotFoundException x) {
                throw new EmbeddedObjectDeserializationException("Class not found while deserializing embedded object", x);
            }
            catch (IOException x) {
                throw new EmbeddedObjectDeserializationException("Could not deserialize embedded object", x);
            }
        }
    }
}

