/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import com.sun.management.OperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.ManagementFactory;

public final class RuntimeInfo
implements Serializable {
    private static final long serialVersionUID = -72154637904826248L;
    private final int nThreads;
    private final long maxMemory = Runtime.getRuntime().maxMemory();
    private final long totalMemory;
    private final long freeMemory;
    private final double processCpuLoad;
    private final double systemCpuLoad;
    private static final transient OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
    private static final transient Runtime runtime = Runtime.getRuntime();
    private final int uptime;

    public RuntimeInfo() {
        this(0);
    }

    public RuntimeInfo(int uptime) {
        this.nThreads = Thread.activeCount();
        this.freeMemory = runtime.freeMemory();
        this.totalMemory = runtime.totalMemory();
        this.processCpuLoad = osBean.getProcessCpuLoad();
        this.systemCpuLoad = osBean.getSystemCpuLoad();
        this.uptime = uptime;
    }

    public int getNThreads() {
        return this.nThreads;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public double getProcessCpuLoad() {
        return this.processCpuLoad;
    }

    public double getSystemCpuLoad() {
        return this.systemCpuLoad;
    }

    public int getUptime() {
        return this.uptime;
    }
}

